/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.OutputFile;
import com.android.build.gradle.internal.LoggingUtil;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dependency.SymbolFileProviderImpl;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantOutputScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.builder.core.AaptPackageProcessBuilder;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.dependency.LibraryDependency;
import com.android.ide.common.blame.MergingLog;
import com.android.ide.common.blame.MergingLogRewriter;
import com.android.ide.common.blame.MessageReceiver;
import com.android.ide.common.blame.ParsingProcessOutputHandler;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.blame.parser.ToolOutputParser;
import com.android.ide.common.blame.parser.aapt.AaptOutputParser;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.utils.FileUtils;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.gradle.api.Task;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class ProcessAndroidResources
extends IncrementalTask {
    private File manifestFile;
    private File resDir;
    private File assetsDir;
    private File sourceOutputDir;
    private File textSymbolOutputDir;
    private File packageOutputFile;
    private File proguardOutputFile;
    private Collection<String> resourceConfigs;
    private String preferredDensity;
    private List<SymbolFileProviderImpl> libraries;
    private String packageForR;
    private Collection<String> splits;
    private boolean enforceUniquePackageName;
    private VariantType type;
    private boolean debuggable;
    private boolean pseudoLocalesEnabled;
    private AaptOptions aaptOptions;
    private File mergeBlameLogFolder;

    @Override
    protected void doFullTaskAction() throws IOException {
        File srcOut = this.getSourceOutputDir();
        if (srcOut != null) {
            FileUtils.emptyFolder((File)srcOut);
        }
        File resOutBaseNameFile = this.getPackageOutputFile();
        AaptPackageProcessBuilder aaptPackageCommandBuilder = new AaptPackageProcessBuilder(this.getManifestFile(), (com.android.builder.model.AaptOptions)this.getAaptOptions()).setAssetsFolder(this.getAssetsDir()).setResFolder(this.getResDir()).setLibraries(this.getLibraries()).setPackageForR(this.getPackageForR()).setSourceOutputDir(ProcessAndroidResources.absolutePath(srcOut)).setSymbolOutputDir(ProcessAndroidResources.absolutePath(this.getTextSymbolOutputDir())).setResPackageOutput(ProcessAndroidResources.absolutePath(resOutBaseNameFile)).setProguardOutput(ProcessAndroidResources.absolutePath(this.getProguardOutputFile())).setType(this.getType()).setDebuggable(this.getDebuggable()).setPseudoLocalesEnabled(this.getPseudoLocalesEnabled()).setResourceConfigs(this.getResourceConfigs()).setSplits(this.getSplits()).setPreferredDensity(this.getPreferredDensity());
        AndroidBuilder builder = this.getBuilder();
        MergingLog mergingLog = new MergingLog(this.getMergeBlameLogFolder());
        ParsingProcessOutputHandler processOutputHandler = new ParsingProcessOutputHandler(new ToolOutputParser((PatternAwareOutputParser)new AaptOutputParser(), this.getILogger()), new MessageReceiver[]{new MergingLogRewriter(mergingLog, (MessageReceiver)builder.getErrorReporter())});
        try {
            builder.processResources(aaptPackageCommandBuilder, this.getEnforceUniquePackageName(), (ProcessOutputHandler)processOutputHandler);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ProcessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isSplitPackage(File file, File resBaseName) {
        if (file.getName().startsWith(resBaseName.getName())) {
            for (String split : this.splits) {
                if (!file.getName().contains(split)) continue;
                return true;
            }
        }
        return false;
    }

    private static String absolutePath(File file) {
        return file == null ? null : file.getAbsolutePath();
    }

    @InputFile
    public File getManifestFile() {
        return this.manifestFile;
    }

    public void setManifestFile(File manifestFile) {
        this.manifestFile = manifestFile;
    }

    @InputDirectory
    public File getResDir() {
        return this.resDir;
    }

    public void setResDir(File resDir) {
        this.resDir = resDir;
    }

    @InputDirectory
    @Optional
    public File getAssetsDir() {
        return this.assetsDir;
    }

    public void setAssetsDir(File assetsDir) {
        this.assetsDir = assetsDir;
    }

    @OutputDirectory
    @Optional
    public File getSourceOutputDir() {
        return this.sourceOutputDir;
    }

    public void setSourceOutputDir(File sourceOutputDir) {
        this.sourceOutputDir = sourceOutputDir;
    }

    @OutputDirectory
    @Optional
    public File getTextSymbolOutputDir() {
        return this.textSymbolOutputDir;
    }

    public void setTextSymbolOutputDir(File textSymbolOutputDir) {
        this.textSymbolOutputDir = textSymbolOutputDir;
    }

    @org.gradle.api.tasks.OutputFile
    @Optional
    public File getPackageOutputFile() {
        return this.packageOutputFile;
    }

    public void setPackageOutputFile(File packageOutputFile) {
        this.packageOutputFile = packageOutputFile;
    }

    @org.gradle.api.tasks.OutputFile
    @Optional
    public File getProguardOutputFile() {
        return this.proguardOutputFile;
    }

    public void setProguardOutputFile(File proguardOutputFile) {
        this.proguardOutputFile = proguardOutputFile;
    }

    @Input
    public Collection<String> getResourceConfigs() {
        return this.resourceConfigs;
    }

    public void setResourceConfigs(Collection<String> resourceConfigs) {
        this.resourceConfigs = resourceConfigs;
    }

    @Input
    @Optional
    public String getPreferredDensity() {
        return this.preferredDensity;
    }

    public void setPreferredDensity(String preferredDensity) {
        this.preferredDensity = preferredDensity;
    }

    @Input
    String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Nested
    @Optional
    public List<SymbolFileProviderImpl> getLibraries() {
        return this.libraries;
    }

    public void setLibraries(List<SymbolFileProviderImpl> libraries) {
        this.libraries = libraries;
    }

    @Input
    @Optional
    public String getPackageForR() {
        return this.packageForR;
    }

    public void setPackageForR(String packageForR) {
        this.packageForR = packageForR;
    }

    @Input
    @Optional
    public Collection<String> getSplits() {
        return this.splits;
    }

    public void setSplits(Collection<String> splits) {
        this.splits = splits;
    }

    @Input
    public boolean getEnforceUniquePackageName() {
        return this.enforceUniquePackageName;
    }

    public void setEnforceUniquePackageName(boolean enforceUniquePackageName) {
        this.enforceUniquePackageName = enforceUniquePackageName;
    }

    public VariantType getType() {
        return this.type;
    }

    public void setType(VariantType type) {
        this.type = type;
    }

    @Input
    public boolean getDebuggable() {
        return this.debuggable;
    }

    public void setDebuggable(boolean debuggable) {
        this.debuggable = debuggable;
    }

    @Input
    public boolean getPseudoLocalesEnabled() {
        return this.pseudoLocalesEnabled;
    }

    public void setPseudoLocalesEnabled(boolean pseudoLocalesEnabled) {
        this.pseudoLocalesEnabled = pseudoLocalesEnabled;
    }

    @Nested
    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public void setAaptOptions(AaptOptions aaptOptions) {
        this.aaptOptions = aaptOptions;
    }

    @Input
    public File getMergeBlameLogFolder() {
        return this.mergeBlameLogFolder;
    }

    public void setMergeBlameLogFolder(File mergeBlameLogFolder) {
        this.mergeBlameLogFolder = mergeBlameLogFolder;
    }

    public static class ConfigAction
    implements TaskConfigAction<ProcessAndroidResources> {
        private VariantOutputScope scope;
        private File symbolLocation;
        private boolean generateResourcePackage;

        public ConfigAction(VariantOutputScope scope, File symbolLocation, boolean generateResourcePackage) {
            this.scope = scope;
            this.symbolLocation = symbolLocation;
            this.generateResourcePackage = generateResourcePackage;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("process", "Resources");
        }

        @Override
        public Class<ProcessAndroidResources> getType() {
            return ProcessAndroidResources.class;
        }

        @Override
        public void execute(ProcessAndroidResources processResources) {
            final BaseVariantOutputData variantOutputData = this.scope.getVariantOutputData();
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantScope().getVariantData();
            variantOutputData.processResourcesTask = processResources;
            final GradleVariantConfiguration config = variantData.getVariantConfiguration();
            processResources.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            processResources.setVariantName(config.getFullName());
            if (variantData.getSplitHandlingPolicy() == BaseVariantData.SplitHandlingPolicy.RELEASE_21_AND_AFTER_POLICY) {
                HashSet<String> allFilters = new HashSet<String>();
                allFilters.addAll(variantData.getFilters(OutputFile.FilterType.DENSITY));
                allFilters.addAll(variantData.getFilters(OutputFile.FilterType.LANGUAGE));
                processResources.splits = allFilters;
            }
            if (variantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY) == null && variantData.generateRClassTask == null) {
                variantData.generateRClassTask = processResources;
                processResources.enforceUniquePackageName = this.scope.getGlobalScope().getExtension().getEnforceUniquePackageName();
                ConventionMappingHelper.map((Task)processResources, "libraries", new Callable<List<SymbolFileProviderImpl>>(){

                    @Override
                    public List<SymbolFileProviderImpl> call() throws Exception {
                        return ConfigAction.getTextSymbolDependencies(config.getAllLibraries());
                    }
                });
                ConventionMappingHelper.map((Task)processResources, "packageForR", new Callable<String>(){

                    @Override
                    public String call() throws Exception {
                        return config.getOriginalApplicationId();
                    }
                });
                processResources.setSourceOutputDir(this.scope.getVariantScope().getRClassSourceOutputDir());
                processResources.setTextSymbolOutputDir(this.symbolLocation);
                if (((CoreBuildType)config.getBuildType()).isMinifyEnabled()) {
                    if (((CoreBuildType)config.getBuildType()).isShrinkResources() && config.getUseJack()) {
                        LoggingUtil.displayWarning(Logging.getLogger(this.getClass()), this.scope.getGlobalScope().getProject(), "shrinkResources does not yet work with useJack=true");
                    }
                    processResources.setProguardOutputFile(this.scope.getVariantScope().getProcessAndroidResourcesProguardOutputFile());
                } else if (((CoreBuildType)config.getBuildType()).isShrinkResources()) {
                    LoggingUtil.displayWarning(Logging.getLogger(this.getClass()), this.scope.getGlobalScope().getProject(), "To shrink resources you must also enable ProGuard");
                }
            }
            ConventionMappingHelper.map((Task)processResources, "manifestFile", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return variantOutputData.manifestProcessorTask.getOutputFile();
                }
            });
            ConventionMappingHelper.map((Task)processResources, "resDir", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return ConfigAction.this.scope.getVariantScope().getFinalResourcesDir();
                }
            });
            ConventionMappingHelper.map((Task)processResources, "assetsDir", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    return variantData.mergeAssetsTask.getOutputDir();
                }
            });
            if (this.generateResourcePackage) {
                processResources.setPackageOutputFile(this.scope.getProcessResourcePackageOutputFile());
            }
            processResources.setType(config.getType());
            processResources.setDebuggable(((CoreBuildType)config.getBuildType()).isDebuggable());
            processResources.setAaptOptions(this.scope.getGlobalScope().getExtension().getAaptOptions());
            processResources.setPseudoLocalesEnabled(((CoreBuildType)config.getBuildType()).isPseudoLocalesEnabled());
            ConventionMappingHelper.map((Task)processResources, "resourceConfigs", new Callable<Collection<String>>(){

                @Override
                public Collection<String> call() throws Exception {
                    Collection resConfigs = config.getMergedFlavor().getResourceConfigurations();
                    if (resConfigs.size() == 1 && ((String)Iterators.getOnlyElement(resConfigs.iterator())).equals("auto")) {
                        if (ConfigAction.this.scope.getGlobalScope().getAndroidBuilder().getTargetInfo().getBuildTools().getRevision().getMajor() >= 21) {
                            return variantData.discoverListOfResourceConfigsNotDensities();
                        }
                        return variantData.discoverListOfResourceConfigs();
                    }
                    return config.getMergedFlavor().getResourceConfigurations();
                }
            });
            ConventionMappingHelper.map((Task)processResources, "preferredDensity", new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return variantOutputData.getMainOutputFile().getFilter(OutputFile.DENSITY);
                }
            });
            processResources.setMergeBlameLogFolder(this.scope.getVariantScope().getResourceBlameLogDir());
        }

        private static List<SymbolFileProviderImpl> getTextSymbolDependencies(List<LibraryDependency> libraries) {
            ArrayList list = Lists.newArrayListWithCapacity((int)libraries.size());
            for (LibraryDependency lib : libraries) {
                list.add(new SymbolFileProviderImpl(lib));
            }
            return list;
        }
    }
}

