/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ByteCodeUtils;
import com.android.build.gradle.internal.incremental.IncrementalVisitor;
import com.android.build.gradle.internal.incremental.Redirection;
import java.util.List;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.LabelNode;

public class ConstructorArgsRedirection
extends Redirection {
    private final String thisClassName;
    private final Type[] types;
    private final LabelNode end;
    private int locals;
    static final String DISPATCHING_THIS_SIGNATURE = "([Ljava/lang/Object;L" + IncrementalVisitor.INSTANT_RELOAD_EXCEPTION + ";)V";

    ConstructorArgsRedirection(LabelNode label, String thisClassName, String name, LabelNode end, Type[] types) {
        super(label, name);
        this.thisClassName = thisClassName;
        this.types = types;
        this.end = end;
        this.locals = -1;
    }

    @Override
    protected void createLocals(GeneratorAdapter mv, List<Type> args) {
        super.createLocals(mv, args);
        this.locals = mv.newLocal(Type.getType((String)"[Ljava/lang/Object;"));
        mv.dup();
        mv.storeLocal(this.locals);
    }

    @Override
    protected void redirectLocal(GeneratorAdapter mv, int stackIndex, Type arg) {
        if (stackIndex == 0) {
            mv.loadLocal(this.locals);
        } else {
            super.redirectLocal(mv, stackIndex, arg);
        }
    }

    @Override
    protected void restore(GeneratorAdapter mv, List<Type> args) {
        mv.visitTypeInsn(192, "[Ljava/lang/Object;");
        int constructorArgs = mv.newLocal(Type.getType((String)"[Ljava/lang/Object;"));
        mv.storeLocal(constructorArgs);
        mv.loadLocal(this.locals);
        int stackIndex = 0;
        for (int arrayIndex = 0; arrayIndex < args.size(); ++arrayIndex) {
            Type arg = args.get(arrayIndex);
            if (arrayIndex > 0) {
                mv.dup();
                mv.push(arrayIndex);
                mv.arrayLoad(Type.getType(Object.class));
                ByteCodeUtils.unbox(mv, arg);
                mv.visitVarInsn(arg.getOpcode(54), stackIndex);
            }
            stackIndex += arg.getSize();
        }
        mv.pop();
        mv.loadLocal(constructorArgs);
        mv.visitInsn(1);
        mv.visitMethodInsn(183, this.thisClassName, "<init>", DISPATCHING_THIS_SIGNATURE, false);
        mv.goTo(this.end.getLabel());
    }
}

