/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.LoggerWrapper;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class IncrementalVisitor
extends ClassVisitor {
    private static final ILogger LOG = LoggerWrapper.getLogger(IncrementalVisitor.class);
    public static final String PACKAGE = "com/android/tools/fd/runtime";
    public static final String ABSTRACT_PATCHES_LOADER_IMPL = "com/android/tools/fd/runtime/AbstractPatchesLoaderImpl";
    public static final String APP_PATCHES_LOADER_IMPL = "com/android/tools/fd/runtime/AppPatchesLoaderImpl";
    protected static final Type INSTANT_RELOAD_EXCEPTION = Type.getType((String)"com/android/tools/fd/runtime/InstantReloadException");
    protected static final Type RUNTIME_TYPE = Type.getType((String)"Lcom/android/tools/fd/runtime/AndroidInstantRuntime;");
    public static final Type DISABLE_ANNOTATION_TYPE = Type.getType((String)"Lcom/android/tools/ir/api/DisableInstantRun;");
    protected static final boolean TRACING_ENABLED = Boolean.getBoolean("FDR_TRACING");
    public static final Type CHANGE_TYPE = Type.getType((String)"Lcom/android/tools/fd/runtime/IncrementalChange;");
    protected String visitedClassName;
    protected String visitedSuperName;
    protected final ClassNode classNode;
    protected final List<ClassNode> parentNodes;

    public IncrementalVisitor(ClassNode classNode, List<ClassNode> parentNodes, ClassVisitor classVisitor) {
        super(327680, classVisitor);
        this.classNode = classNode;
        this.parentNodes = parentNodes;
        LOG.info("%s: Visiting %s", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), classNode.name});
    }

    protected static String getRuntimeTypeName(Type type) {
        return "L" + type.getInternalName() + ";";
    }

    FieldNode getFieldByName(String fieldName) {
        FieldNode fieldNode = IncrementalVisitor.getFieldByNameInClass(fieldName, this.classNode);
        Iterator<ClassNode> iterator = this.parentNodes.iterator();
        while (fieldNode == null && iterator.hasNext()) {
            ClassNode parentNode = iterator.next();
            fieldNode = IncrementalVisitor.getFieldByNameInClass(fieldName, parentNode);
        }
        return fieldNode;
    }

    protected static FieldNode getFieldByNameInClass(String fieldName, ClassNode classNode) {
        List fields = classNode.fields;
        for (FieldNode field : fields) {
            if (!field.name.equals(fieldName)) continue;
            return field;
        }
        return null;
    }

    protected MethodNode getMethodByName(String methodName, String desc) {
        MethodNode methodNode = IncrementalVisitor.getMethodByNameInClass(methodName, desc, this.classNode);
        Iterator<ClassNode> iterator = this.parentNodes.iterator();
        while (methodNode == null && iterator.hasNext()) {
            ClassNode parentNode = iterator.next();
            methodNode = IncrementalVisitor.getMethodByNameInClass(methodName, desc, parentNode);
        }
        return methodNode;
    }

    protected static MethodNode getMethodByNameInClass(String methodName, String desc, ClassNode classNode) {
        List methods = classNode.methods;
        for (MethodNode method : methods) {
            if (!method.name.equals(methodName) || !method.desc.equals(desc)) continue;
            return method;
        }
        return null;
    }

    protected static void trace(GeneratorAdapter mv, String s) {
        mv.push(s);
        mv.invokeStatic(Type.getType((String)"com/android/tools/fd/runtime.AndroidInstantRuntime"), Method.getMethod((String)"void trace(String)"));
    }

    protected static void trace(GeneratorAdapter mv, String s1, String s2) {
        mv.push(s1);
        mv.push(s2);
        mv.invokeStatic(Type.getType((String)"com/android/tools/fd/runtime.AndroidInstantRuntime"), Method.getMethod((String)"void trace(String, String)"));
    }

    protected static void trace(GeneratorAdapter mv, String s1, String s2, String s3) {
        mv.push(s1);
        mv.push(s2);
        mv.push(s3);
        mv.invokeStatic(Type.getType((String)"com/android/tools/fd/runtime.AndroidInstantRuntime"), Method.getMethod((String)"void trace(String, String, String)"));
    }

    protected static void trace(GeneratorAdapter mv, String s1, String s2, String s3, String s4) {
        mv.push(s1);
        mv.push(s2);
        mv.push(s3);
        mv.push(s4);
        mv.invokeStatic(Type.getType((String)"com/android/tools/fd/runtime.AndroidInstantRuntime"), Method.getMethod((String)"void trace(String, String, String, String)"));
    }

    protected static void trace(GeneratorAdapter mv, int argsNumber) {
        StringBuilder methodSignature = new StringBuilder("void trace(String");
        for (int i = 0; i < argsNumber - 1; ++i) {
            methodSignature.append(", String");
        }
        methodSignature.append(")");
        mv.invokeStatic(Type.getType((String)"com/android/tools/fd/runtime.AndroidInstantRuntime"), Method.getMethod((String)methodSignature.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void main(String[] args, VisitorBuilder visitorBuilder) throws IOException {
        if (args.length != 3) {
            throw new IllegalArgumentException("Needs to be given an input and output directory and a classpath");
        }
        File srcLocation = new File(args[0]);
        File baseInstrumentedCompileOutputFolder = new File(args[1]);
        FileUtils.emptyFolder((File)baseInstrumentedCompileOutputFolder);
        Iterable classPathStrings = Splitter.on((char)File.pathSeparatorChar).split((CharSequence)args[2]);
        ArrayList classPath = Lists.newArrayList();
        for (String classPathString : classPathStrings) {
            File path = new File(classPathString);
            if (!path.exists()) {
                throw new IllegalArgumentException(String.format("Invalid class path element %s", classPathString));
            }
            classPath.add(path.toURI().toURL());
        }
        classPath.add(srcLocation.toURI().toURL());
        URL[] classPathArray = (URL[])Iterables.toArray((Iterable)classPath, URL.class);
        URLClassLoader classesToInstrumentLoader = new URLClassLoader(classPathArray, null){

            @Override
            public URL getResource(String name) {
                return this.findResource(name);
            }
        };
        ClassLoader originalThreadContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(classesToInstrumentLoader);
            IncrementalVisitor.instrumentClasses(srcLocation, baseInstrumentedCompileOutputFolder, visitorBuilder);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalThreadContextClassLoader);
        }
    }

    private static void instrumentClasses(File rootLocation, File outLocation, VisitorBuilder visitorBuilder) throws IOException {
        FluentIterable files = Files.fileTreeTraverser().preOrderTraversal((Object)rootLocation).filter(Files.isFile());
        for (File inputFile : files) {
            IncrementalVisitor.instrumentClass(rootLocation, inputFile, outLocation, visitorBuilder);
        }
    }

    protected static boolean isAccessCompatibleWithInstantRun(int access) {
        return (access & 0x400) == 0 && (access & 0x40) == 0;
    }

    public static File instrumentClass(File inputRootDirectory, File inputFile, File outputDirectory, VisitorBuilder visitorBuilder) throws IOException {
        String path = FileUtils.relativePath((File)inputFile, (File)inputRootDirectory);
        if (!inputFile.getPath().endsWith(".class")) {
            File outputFile = new File(outputDirectory, path);
            Files.createParentDirs((File)outputFile);
            Files.copy((File)inputFile, (File)outputFile);
            return outputFile;
        }
        byte[] classBytes = Files.toByteArray((File)inputFile);
        ClassReader classReader = new ClassReader(classBytes);
        ClassWriter classWriter = new ClassWriter(classReader, 2){

            protected String getCommonSuperClass(String type1, String type2) {
                Class<?> d;
                Class<?> c;
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                try {
                    c = Class.forName(type1.replace('/', '.'), false, classLoader);
                    d = Class.forName(type2.replace('/', '.'), false, classLoader);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.toString());
                }
                if (c.isAssignableFrom(d)) {
                    return type1;
                }
                if (d.isAssignableFrom(c)) {
                    return type2;
                }
                if (c.isInterface() || d.isInterface()) {
                    return "java/lang/Object";
                }
                while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
                }
                return c.getName().replace('.', '/');
            }
        };
        ClassNode classNode = new ClassNode();
        classReader.accept((ClassVisitor)classNode, 8);
        AccessRight accessRight = AccessRight.fromNodeAccess(classNode.access);
        File outputFile = new File(outputDirectory, path);
        if ((classNode.access & 0x200) != 0) {
            if (visitorBuilder.getOutputType() == OutputType.INSTRUMENT) {
                Files.createParentDirs((File)outputFile);
                if (accessRight == AccessRight.PACKAGE_PRIVATE) {
                    classNode.access |= 1;
                    classNode.accept((ClassVisitor)classWriter);
                    Files.write((byte[])classWriter.toByteArray(), (File)outputFile);
                } else {
                    Files.write((byte[])classBytes, (File)outputFile);
                }
                return outputFile;
            }
            return null;
        }
        if (IncrementalVisitor.isPackageInstantRunDisabled(inputFile, classNode)) {
            if (visitorBuilder.getOutputType() == OutputType.INSTRUMENT) {
                Files.createParentDirs((File)outputFile);
                Files.write((byte[])classBytes, (File)outputFile);
                return outputFile;
            }
            return null;
        }
        List<ClassNode> parentsNodes = IncrementalVisitor.parseParents(inputFile, classNode);
        outputFile = new File(outputDirectory, visitorBuilder.getMangledRelativeClassFilePath(path));
        Files.createParentDirs((File)outputFile);
        IncrementalVisitor visitor = visitorBuilder.build(classNode, parentsNodes, (ClassVisitor)classWriter);
        classNode.accept((ClassVisitor)visitor);
        Files.write((byte[])classWriter.toByteArray(), (File)outputFile);
        return outputFile;
    }

    private static File getBinaryFolder(File inputFile, ClassNode classNode) {
        return new File(inputFile.getAbsolutePath().substring(0, inputFile.getAbsolutePath().length() - (classNode.name.length() + ".class".length())));
    }

    private static List<ClassNode> parseParents(File inputFile, ClassNode classNode) throws IOException {
        File binaryFolder = IncrementalVisitor.getBinaryFolder(inputFile, classNode);
        ArrayList<ClassNode> parentNodes = new ArrayList<ClassNode>();
        String currentParentName = classNode.superName;
        while (currentParentName != null) {
            File parentFile = new File(binaryFolder, currentParentName + ".class");
            if (parentFile.exists()) {
                LOG.info("Parsing %s.", new Object[]{parentFile});
                BufferedInputStream parentFileClassReader = new BufferedInputStream(new FileInputStream(parentFile));
                ClassReader parentClassReader = new ClassReader((InputStream)parentFileClassReader);
                ClassNode parentNode = new ClassNode();
                parentClassReader.accept((ClassVisitor)parentNode, 8);
                parentNodes.add(parentNode);
                currentParentName = parentNode.superName;
                continue;
            }
            try {
                ClassReader parentClassReader = new ClassReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(currentParentName + ".class"));
                ClassNode parentNode = new ClassNode();
                parentClassReader.accept((ClassVisitor)parentNode, 8);
                parentNodes.add(parentNode);
                currentParentName = parentNode.superName;
            }
            catch (IOException e) {
                LOG.error(null, "IncrementalVisitor parseParents could not locate %1$s which is an ancestor of project class %2$s.\n", new Object[]{currentParentName, classNode.name});
                currentParentName = null;
            }
        }
        return parentNodes;
    }

    private static ClassNode parsePackageInfo(File inputFile, ClassNode classNode) throws IOException {
        File packageFolder = inputFile.getParentFile();
        File packageInfoClass = new File(packageFolder, "package-info.class");
        if (packageInfoClass.exists()) {
            BufferedInputStream reader = new BufferedInputStream(new FileInputStream(packageInfoClass));
            ClassReader classReader = new ClassReader((InputStream)reader);
            ClassNode packageInfo = new ClassNode();
            classReader.accept((ClassVisitor)packageInfo, 8);
            return packageInfo;
        }
        return null;
    }

    private static boolean isPackageInstantRunDisabled(File inputFile, ClassNode classNode) throws IOException {
        ClassNode packageInfoClass = IncrementalVisitor.parsePackageInfo(inputFile, classNode);
        if (packageInfoClass != null) {
            List annotations = packageInfoClass.invisibleAnnotations;
            if (annotations == null) {
                return false;
            }
            for (AnnotationNode annotation : annotations) {
                if (!annotation.desc.equals(DISABLE_ANNOTATION_TYPE.getDescriptor())) continue;
                return true;
            }
        }
        return false;
    }

    public static interface VisitorBuilder {
        public IncrementalVisitor build(ClassNode var1, List<ClassNode> var2, ClassVisitor var3);

        public String getMangledRelativeClassFilePath(String var1);

        public OutputType getOutputType();
    }

    protected static enum AccessRight {
        PRIVATE,
        PACKAGE_PRIVATE,
        PROTECTED,
        PUBLIC;


        static AccessRight fromNodeAccess(int nodeAccess) {
            if ((nodeAccess & 2) != 0) {
                return PRIVATE;
            }
            if ((nodeAccess & 4) != 0) {
                return PROTECTED;
            }
            if ((nodeAccess & 1) != 0) {
                return PUBLIC;
            }
            return PACKAGE_PRIVATE;
        }
    }

    public static enum OutputType {
        INSTRUMENT,
        OVERRIDE;

    }
}

