/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.tasks;

import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.DefaultAndroidTask;
import com.android.ide.common.packaging.PackagingUtils;
import com.android.utils.FileUtils;
import com.google.common.io.ByteStreams;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.gradle.api.Task;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.ParallelizableTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

@ParallelizableTask
public class ExtractJavaResourcesTask
extends DefaultAndroidTask {
    @InputFiles
    public Set<File> jarInputFiles;
    @OutputDirectory
    public File outputDir;

    @InputFiles
    public Set<File> getJarInputFiles() {
        return this.jarInputFiles;
    }

    @TaskAction
    public void extractJavaResources(IncrementalTaskInputs incrementalTaskInputs) {
        incrementalTaskInputs.outOfDate((org.gradle.api.Action)new org.gradle.api.Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                File inputJar = inputFileDetails.getFile();
                String folderName = inputJar.getName() + inputJar.getPath().hashCode();
                File outputFolder = new File(ExtractJavaResourcesTask.this.outputDir, folderName);
                if (outputFolder.exists()) {
                    try {
                        FileUtils.deleteFolder((File)outputFolder);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                if (!outputFolder.mkdirs()) {
                    throw new RuntimeException("Cannot create folder to extract java resources in for " + inputJar.getAbsolutePath());
                }
                JarFile jarFile = null;
                try {
                    jarFile = new JarFile(inputJar);
                    Enumeration<JarEntry> entries = jarFile.entries();
                    while (entries.hasMoreElements()) {
                        JarEntry jarEntry = entries.nextElement();
                        if (jarEntry.isDirectory()) continue;
                        ExtractJavaResourcesTask.processJarEntry(jarFile, jarEntry, outputFolder);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (jarFile != null) {
                        try {
                            jarFile.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        });
        incrementalTaskInputs.removed((org.gradle.api.Action)new org.gradle.api.Action<InputFileDetails>(){

            public void execute(InputFileDetails inputFileDetails) {
                File deletedJar = inputFileDetails.getFile();
                String folderName = deletedJar.getName() + deletedJar.getPath().hashCode();
                File outputFolder = new File(ExtractJavaResourcesTask.this.outputDir, folderName);
                if (outputFolder.exists()) {
                    try {
                        FileUtils.deleteFolder((File)outputFolder);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processJarEntry(JarFile jarFile, JarEntry jarEntry, File outputDir) throws IOException {
        block14: {
            File outputFile = new File(outputDir, jarEntry.getName());
            Action action = ExtractJavaResourcesTask.getAction(jarEntry.getName());
            if (action == Action.COPY) {
                if (!outputFile.getParentFile().exists() && !outputFile.getParentFile().mkdirs()) {
                    throw new RuntimeException("Cannot create directory " + outputFile.getParent());
                }
                if (!outputFile.exists() || outputFile.lastModified() < jarEntry.getTime()) {
                    InputStream inputStream = null;
                    OutputStream outputStream = null;
                    try {
                        inputStream = jarFile.getInputStream(jarEntry);
                        if (inputStream != null) {
                            outputStream = new BufferedOutputStream(new FileOutputStream(outputFile));
                            ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
                            outputStream.flush();
                            break block14;
                        }
                        throw new RuntimeException("Cannot copy " + jarEntry.getName());
                    }
                    finally {
                        try {
                            if (outputStream != null) {
                                outputStream.close();
                            }
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                }
            }
        }
    }

    public static Action getAction(String archivePath) {
        if ("META-INF/MANIFEST.MF".equals(archivePath)) {
            return Action.IGNORE;
        }
        String[] segments = archivePath.split("/");
        if (segments.length == 0) {
            return Action.IGNORE;
        }
        for (int i = 0; i < segments.length - 1; ++i) {
            if (PackagingUtils.checkFolderForPackaging((String)segments[i])) continue;
            return Action.IGNORE;
        }
        String fileName = segments[segments.length - 1];
        return PackagingUtils.checkFileForPackaging((String)fileName) ? Action.COPY : Action.IGNORE;
    }

    public static class Config
    implements TaskConfigAction<ExtractJavaResourcesTask> {
        private final VariantScope scope;

        public Config(VariantScope scope) {
            this.scope = scope;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName("extract", "PackagedLibrariesJavaResources");
        }

        @Override
        public Class<ExtractJavaResourcesTask> getType() {
            return ExtractJavaResourcesTask.class;
        }

        @Override
        public void execute(ExtractJavaResourcesTask extractJavaResourcesTask) {
            ConventionMappingHelper.map((Task)extractJavaResourcesTask, "jarInputFiles", new Callable<Set<File>>(){

                @Override
                public Set<File> call() throws Exception {
                    return Config.this.scope.getVariantConfiguration().getAllPackagedJars();
                }
            });
            extractJavaResourcesTask.outputDir = this.scope.getPackagedJarsJavaResDestinationDir();
            extractJavaResourcesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
        }
    }

    static enum Action {
        COPY,
        IGNORE;

    }
}

