/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.tasks;

import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.AndroidGradleOptions;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.IncrementalTask;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.tasks.ResourceException;
import com.android.builder.model.VectorDrawablesOptions;
import com.android.builder.png.QueuedCruncher;
import com.android.builder.png.VectorDrawableRenderer;
import com.android.ide.common.internal.PngCruncher;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.res2.FileStatus;
import com.android.ide.common.res2.FileValidity;
import com.android.ide.common.res2.GeneratedResourceSet;
import com.android.ide.common.res2.MergeConsumer;
import com.android.ide.common.res2.MergedResourceWriter;
import com.android.ide.common.res2.MergingException;
import com.android.ide.common.res2.NoOpResourcePreprocessor;
import com.android.ide.common.res2.ResourceMerger;
import com.android.ide.common.res2.ResourcePreprocessor;
import com.android.ide.common.res2.ResourceSet;
import com.android.resources.Density;
import com.android.sdklib.BuildToolInfo;
import com.android.utils.FileUtils;
import com.android.utils.ILogger;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.ParallelizableTask;

@ParallelizableTask
public class MergeResources
extends IncrementalTask {
    private static final List<Pattern> IGNORED_WARNINGS = Lists.newArrayList((Object[])new Pattern[]{Pattern.compile("Not recognizing known sRGB profile that has been edited")});
    private File outputDir;
    private File generatedPngsOutputDir;
    private File publicFile;
    private boolean process9Patch;
    private boolean crunchPng;
    private boolean useNewCruncher;
    private boolean validateEnabled;
    private File blameLogFolder;
    private List<ResourceSet> inputResourceSets;
    private final FileValidity<ResourceSet> fileValidity = new FileValidity();
    private boolean disableVectorDrawables;
    private Collection<String> generatedDensities;
    private int minSdk;

    @InputFiles
    public Iterable<File> getRawInputFolders() {
        return MergeResources.flattenSourceSets(this.getInputResourceSets());
    }

    @Input
    public String getBuildToolsVersion() {
        return this.getBuildTools().getRevision().toString();
    }

    @Override
    protected boolean isIncremental() {
        return true;
    }

    private PngCruncher getCruncher() {
        if (this.getUseNewCruncher()) {
            BuildToolInfo buildTools = this.getBuilder().getTargetInfo().getBuildTools();
            if (buildTools.getRevision().getMajor() >= 22) {
                return QueuedCruncher.Builder.INSTANCE.newCruncher(buildTools.getPath(BuildToolInfo.PathId.AAPT), this.getFilteringLogger());
            }
            this.getLogger().info("New PNG cruncher will be enabled with build tools 22 and above.");
        }
        return this.getBuilder().getAaptCruncher((ProcessOutputHandler)new LoggedProcessOutputHandler(this.getFilteringLogger()));
    }

    private ILogger getFilteringLogger() {
        return new FilteringLogger(this.getILogger());
    }

    @Override
    protected void doFullTaskAction() throws IOException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        File destinationDir = this.getOutputDir();
        FileUtils.emptyFolder((File)destinationDir);
        List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            for (ResourceSet resourceSet : resourceSets) {
                resourceSet.loadFromFiles(this.getILogger());
                merger.addDataSet(resourceSet);
            }
            MergedResourceWriter writer = new MergedResourceWriter(destinationDir, this.getCruncher(), this.getCrunchPng(), this.getProcess9Patch(), this.getPublicFile(), this.getBlameLogFolder(), preprocessor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer);
        }
        catch (MergingException e) {
            System.out.println(e.getMessage());
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
    }

    @Override
    protected void doIncrementalTaskAction(Map<File, FileStatus> changedInputs) throws IOException {
        ResourcePreprocessor preprocessor = this.getPreprocessor();
        ResourceMerger merger = new ResourceMerger(this.minSdk);
        try {
            if (!merger.loadFromBlob(this.getIncrementalFolder(), true)) {
                this.doFullTaskAction();
                return;
            }
            for (ResourceSet resourceSet : merger.getDataSets()) {
                resourceSet.setPreprocessor(preprocessor);
            }
            List<ResourceSet> resourceSets = this.getConfiguredResourceSets(preprocessor);
            if (!merger.checkValidUpdate(resourceSets)) {
                this.getLogger().info("Changed Resource sets: full task run!");
                this.doFullTaskAction();
                return;
            }
            for (Map.Entry<File, FileStatus> entry : changedInputs.entrySet()) {
                File changedFile = entry.getKey();
                merger.findDataSetContaining(changedFile, this.fileValidity);
                if (this.fileValidity.getStatus() == FileValidity.FileStatus.UNKNOWN_FILE) {
                    this.doFullTaskAction();
                    return;
                }
                if (this.fileValidity.getStatus() != FileValidity.FileStatus.VALID_FILE || ((ResourceSet)this.fileValidity.getDataSet()).updateWith(this.fileValidity.getSourceFile(), changedFile, entry.getValue(), this.getILogger())) continue;
                this.getLogger().info(String.format("Failed to process %s event! Full task run", entry.getValue()));
                this.doFullTaskAction();
                return;
            }
            MergedResourceWriter writer = new MergedResourceWriter(this.getOutputDir(), this.getCruncher(), this.getCrunchPng(), this.getProcess9Patch(), this.getPublicFile(), this.getBlameLogFolder(), preprocessor);
            merger.mergeData((MergeConsumer)writer, false);
            merger.writeBlobTo(this.getIncrementalFolder(), (MergeConsumer)writer);
        }
        catch (MergingException e) {
            merger.cleanBlob(this.getIncrementalFolder());
            throw new ResourceException(e.getMessage(), e);
        }
        finally {
            this.fileValidity.clear();
        }
    }

    private ResourcePreprocessor getPreprocessor() {
        Collection<String> generatedDensitiesNames = this.getGeneratedDensities();
        if (this.isDisableVectorDrawables()) {
            return new NoOpResourcePreprocessor();
        }
        ArrayList densities = Lists.newArrayList();
        for (String density : generatedDensitiesNames) {
            densities.add(Density.getEnum((String)density));
        }
        return new VectorDrawableRenderer(this.getMinSdk(), this.getGeneratedPngsOutputDir(), (Collection)densities, this.getILogger());
    }

    private List<ResourceSet> getConfiguredResourceSets(ResourcePreprocessor preprocessor) {
        ArrayList resourceSets = Lists.newArrayList(this.getInputResourceSets());
        ArrayList generatedSets = Lists.newArrayListWithCapacity((int)resourceSets.size());
        for (ResourceSet resourceSet : resourceSets) {
            resourceSet.setPreprocessor(preprocessor);
            GeneratedResourceSet generatedSet = new GeneratedResourceSet(resourceSet);
            resourceSet.setGeneratedSet((ResourceSet)generatedSet);
            generatedSets.add(generatedSet);
        }
        resourceSets.addAll(0, generatedSets);
        return resourceSets;
    }

    public List<ResourceSet> getInputResourceSets() {
        return this.inputResourceSets;
    }

    public void setInputResourceSets(List<ResourceSet> inputResourceSets) {
        this.inputResourceSets = inputResourceSets;
    }

    public boolean getUseNewCruncher() {
        return this.useNewCruncher;
    }

    public void setUseNewCruncher(boolean useNewCruncher) {
        this.useNewCruncher = useNewCruncher;
    }

    @OutputDirectory
    public File getOutputDir() {
        return this.outputDir;
    }

    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    public boolean getCrunchPng() {
        return this.crunchPng;
    }

    public void setCrunchPng(boolean crunchPng) {
        this.crunchPng = crunchPng;
    }

    public boolean getProcess9Patch() {
        return this.process9Patch;
    }

    public void setProcess9Patch(boolean process9Patch) {
        this.process9Patch = process9Patch;
    }

    @Optional
    @OutputFile
    public File getPublicFile() {
        return this.publicFile;
    }

    public void setPublicFile(File publicFile) {
        this.publicFile = publicFile;
    }

    @Input
    public boolean isValidateEnabled() {
        return this.validateEnabled;
    }

    public void setValidateEnabled(boolean validateEnabled) {
        this.validateEnabled = validateEnabled;
    }

    @OutputDirectory
    @Optional
    public File getBlameLogFolder() {
        return this.blameLogFolder;
    }

    public void setBlameLogFolder(File blameLogFolder) {
        this.blameLogFolder = blameLogFolder;
    }

    public File getGeneratedPngsOutputDir() {
        return this.generatedPngsOutputDir;
    }

    public void setGeneratedPngsOutputDir(File generatedPngsOutputDir) {
        this.generatedPngsOutputDir = generatedPngsOutputDir;
    }

    @Input
    public Collection<String> getGeneratedDensities() {
        return this.generatedDensities;
    }

    @Input
    public int getMinSdk() {
        return this.minSdk;
    }

    public void setMinSdk(int minSdk) {
        this.minSdk = minSdk;
    }

    public void setGeneratedDensities(Collection<String> generatedDensities) {
        this.generatedDensities = generatedDensities;
    }

    @Input
    public boolean isDisableVectorDrawables() {
        return this.disableVectorDrawables;
    }

    public void setDisableVectorDrawables(boolean disableVectorDrawables) {
        this.disableVectorDrawables = disableVectorDrawables;
    }

    private static class FilteringLogger
    implements ILogger {
        private final ILogger mDelegate;

        FilteringLogger(ILogger delegate) {
            this.mDelegate = delegate;
        }

        public void error(Throwable t, String msgFormat, Object ... args) {
            if (msgFormat != null && this.isIgnored(msgFormat, args)) {
                this.mDelegate.info(Strings.nullToEmpty((String)msgFormat), args);
            } else {
                this.mDelegate.error(t, msgFormat, args);
            }
        }

        public void warning(String msgFormat, Object ... args) {
            if (this.isIgnored(msgFormat, args)) {
                this.mDelegate.info(msgFormat, args);
            } else {
                this.mDelegate.warning(msgFormat, args);
            }
        }

        public void info(String msgFormat, Object ... args) {
            this.mDelegate.info(msgFormat, args);
        }

        public void verbose(String msgFormat, Object ... args) {
            this.mDelegate.verbose(msgFormat, args);
        }

        private boolean isIgnored(String msgFormat, Object ... args) {
            String message = String.format(msgFormat, args);
            for (Pattern pattern : IGNORED_WARNINGS) {
                if (!pattern.matcher(message).find()) continue;
                return true;
            }
            return false;
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<MergeResources> {
        private final VariantScope scope;
        private final String taskNamePrefix;
        private final File outputLocation;
        private final boolean includeDependencies;
        private final boolean process9Patch;

        public ConfigAction(VariantScope scope, String taskNamePrefix, File outputLocation, boolean includeDependencies, boolean process9Patch) {
            this.scope = scope;
            this.taskNamePrefix = taskNamePrefix;
            this.outputLocation = outputLocation;
            this.includeDependencies = includeDependencies;
            this.process9Patch = process9Patch;
        }

        @Override
        public String getName() {
            return this.scope.getTaskName(this.taskNamePrefix, "Resources");
        }

        @Override
        public Class<MergeResources> getType() {
            return MergeResources.class;
        }

        @Override
        public void execute(MergeResources mergeResourcesTask) {
            final BaseVariantData<? extends BaseVariantOutputData> variantData = this.scope.getVariantData();
            AndroidConfig extension = this.scope.getGlobalScope().getExtension();
            mergeResourcesTask.setMinSdk(variantData.getVariantConfiguration().getMinSdkVersion().getApiLevel());
            mergeResourcesTask.setAndroidBuilder(this.scope.getGlobalScope().getAndroidBuilder());
            mergeResourcesTask.setVariantName(this.scope.getVariantConfiguration().getFullName());
            mergeResourcesTask.setIncrementalFolder(this.scope.getIncrementalDir(this.getName()));
            if (this.includeDependencies) {
                mergeResourcesTask.setBlameLogFolder(this.scope.getResourceBlameLogDir());
            }
            mergeResourcesTask.setProcess9Patch(this.process9Patch);
            mergeResourcesTask.setCrunchPng(extension.getAaptOptions().getCruncherEnabled());
            VectorDrawablesOptions vectorDrawablesOptions = variantData.getVariantConfiguration().getMergedFlavor().getVectorDrawables();
            Set generatedDensities = vectorDrawablesOptions.getGeneratedDensities();
            mergeResourcesTask.setGeneratedDensities((Collection)Objects.firstNonNull((Object)generatedDensities, Collections.emptySet()));
            mergeResourcesTask.setDisableVectorDrawables(vectorDrawablesOptions.getUseSupportLibrary() != false || mergeResourcesTask.getGeneratedDensities().isEmpty());
            mergeResourcesTask.setUseNewCruncher(extension.getAaptOptions().getUseNewCruncher());
            final boolean validateEnabled = AndroidGradleOptions.isResourceValidationEnabled(this.scope.getGlobalScope().getProject());
            mergeResourcesTask.setValidateEnabled(validateEnabled);
            ConventionMappingHelper.map((Task)mergeResourcesTask, "inputResourceSets", new Callable<List<ResourceSet>>(){

                @Override
                public List<ResourceSet> call() throws Exception {
                    ArrayList generatedResFolders = Lists.newArrayList((Object[])new File[]{ConfigAction.this.scope.getRenderscriptResOutputDir(), ConfigAction.this.scope.getGeneratedResOutputDir()});
                    if (variantData.getExtraGeneratedResFolders() != null) {
                        generatedResFolders.addAll(variantData.getExtraGeneratedResFolders());
                    }
                    if (variantData.generateApkDataTask != null && ((CoreBuildType)variantData.getVariantConfiguration().getBuildType()).isEmbedMicroApp()) {
                        generatedResFolders.add(variantData.generateApkDataTask.getResOutputDir());
                    }
                    return variantData.getVariantConfiguration().getResourceSets(generatedResFolders, ConfigAction.this.includeDependencies, validateEnabled);
                }
            });
            mergeResourcesTask.setOutputDir(this.outputLocation != null ? this.outputLocation : this.scope.getDefaultMergeResourcesOutputDir());
            mergeResourcesTask.setGeneratedPngsOutputDir(this.scope.getGeneratedPngsOutputDir());
            variantData.mergeResourcesTask = mergeResourcesTask;
        }
    }
}

