/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.model;

import com.android.build.OutputFile;
import com.android.build.gradle.AndroidConfig;
import com.android.build.gradle.api.ApkOutputFile;
import com.android.build.gradle.internal.BuildTypeData;
import com.android.build.gradle.internal.ExtraModelInfo;
import com.android.build.gradle.internal.NdkHandler;
import com.android.build.gradle.internal.ProductFlavorData;
import com.android.build.gradle.internal.TaskManager;
import com.android.build.gradle.internal.VariantManager;
import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.CoreBuildType;
import com.android.build.gradle.internal.dsl.CoreNdkOptions;
import com.android.build.gradle.internal.dsl.CoreProductFlavor;
import com.android.build.gradle.internal.dsl.LintOptions;
import com.android.build.gradle.internal.incremental.InstantRunAnchorTask;
import com.android.build.gradle.internal.incremental.InstantRunWrapperTask;
import com.android.build.gradle.internal.model.AaptOptionsImpl;
import com.android.build.gradle.internal.model.AndroidArtifactImpl;
import com.android.build.gradle.internal.model.AndroidArtifactOutputImpl;
import com.android.build.gradle.internal.model.ApiVersionImpl;
import com.android.build.gradle.internal.model.ArtifactMetaDataImpl;
import com.android.build.gradle.internal.model.BuildTypeContainerImpl;
import com.android.build.gradle.internal.model.DefaultAndroidProject;
import com.android.build.gradle.internal.model.DependenciesImpl;
import com.android.build.gradle.internal.model.InstantRunImpl;
import com.android.build.gradle.internal.model.JavaArtifactImpl;
import com.android.build.gradle.internal.model.NativeLibraryFactory;
import com.android.build.gradle.internal.model.NativeToolchainImpl;
import com.android.build.gradle.internal.model.OutputFileImpl;
import com.android.build.gradle.internal.model.ProductFlavorContainerImpl;
import com.android.build.gradle.internal.model.ProductFlavorImpl;
import com.android.build.gradle.internal.model.SigningConfigImpl;
import com.android.build.gradle.internal.model.SourceProviderImpl;
import com.android.build.gradle.internal.model.VariantImpl;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.internal.variant.BaseVariantData;
import com.android.build.gradle.internal.variant.BaseVariantOutputData;
import com.android.build.gradle.internal.variant.TestVariantData;
import com.android.build.gradle.internal.variant.TestedVariantData;
import com.android.builder.core.AndroidBuilder;
import com.android.builder.core.VariantType;
import com.android.builder.model.AaptOptions;
import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.AndroidProject;
import com.android.builder.model.ApiVersion;
import com.android.builder.model.JavaArtifact;
import com.android.builder.model.NativeLibrary;
import com.android.builder.model.NativeToolchain;
import com.android.builder.model.SigningConfig;
import com.android.builder.model.SourceProvider;
import com.android.builder.model.SourceProviderContainer;
import com.android.builder.model.SyncIssue;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.IAndroidTarget;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.Project;
import org.gradle.tooling.provider.model.ToolingModelBuilder;

public class ModelBuilder
implements ToolingModelBuilder {
    private final AndroidBuilder androidBuilder;
    private final AndroidConfig config;
    private final ExtraModelInfo extraModelInfo;
    private final VariantManager variantManager;
    private final TaskManager taskManager;
    private final NdkHandler ndkHandler;
    private Map<Abi, NativeToolchain> toolchains;
    private NativeLibraryFactory nativeLibFactory;
    private final boolean isLibrary;
    private final int generation;

    public ModelBuilder(AndroidBuilder androidBuilder, VariantManager variantManager, TaskManager taskManager, AndroidConfig config, ExtraModelInfo extraModelInfo, NdkHandler ndkHandler, NativeLibraryFactory nativeLibraryFactory, boolean isLibrary, int generation) {
        this.androidBuilder = androidBuilder;
        this.config = config;
        this.extraModelInfo = extraModelInfo;
        this.variantManager = variantManager;
        this.taskManager = taskManager;
        this.ndkHandler = ndkHandler;
        this.nativeLibFactory = nativeLibraryFactory;
        this.isLibrary = isLibrary;
        this.generation = generation;
    }

    public static void clearCaches() {
        DependenciesImpl.clearCaches();
    }

    public boolean canBuild(String modelName) {
        return modelName.equals(AndroidProject.class.getName());
    }

    public Object buildAll(String modelName, Project project) {
        Collection<? extends SigningConfig> signingConfigs = this.config.getSigningConfigs();
        List bootClasspath = this.androidBuilder.getBootClasspathAsStrings(false);
        List<File> frameworkSource = Collections.emptyList();
        ArrayList artifactMetaDataList = Lists.newArrayList(this.extraModelInfo.getExtraArtifacts());
        for (VariantType variantType : VariantType.getTestingTypes()) {
            artifactMetaDataList.add(new ArtifactMetaDataImpl(variantType.getArtifactName(), true, variantType.getArtifactType()));
        }
        com.android.builder.model.LintOptions lintOptions = LintOptions.create(this.config.getLintOptions());
        AaptOptions aaptOptions = AaptOptionsImpl.create(this.config.getAaptOptions());
        ArrayList syncIssues = Lists.newArrayList(this.extraModelInfo.getSyncIssues().values());
        ArrayList flavorDimensionList = this.config.getFlavorDimensionList() != null ? this.config.getFlavorDimensionList() : Lists.newArrayList();
        this.toolchains = ModelBuilder.createNativeToolchainModelMap(this.ndkHandler);
        DefaultAndroidProject androidProject = new DefaultAndroidProject("2.1.0", project.getName(), flavorDimensionList, this.androidBuilder.getTarget() != null ? this.androidBuilder.getTarget().hashString() : "", bootClasspath, frameworkSource, ModelBuilder.cloneSigningConfigs(this.config.getSigningConfigs()), aaptOptions, artifactMetaDataList, ModelBuilder.findUnresolvedDependencies(syncIssues), syncIssues, this.config.getCompileOptions(), lintOptions, project.getBuildDir(), this.config.getResourcePrefix(), (Collection<NativeToolchain>)ImmutableList.copyOf(this.toolchains.values()), this.config.getBuildToolsVersion(), this.isLibrary, 3, this.generation);
        androidProject.setDefaultConfig(ProductFlavorContainerImpl.createProductFlavorContainer(this.variantManager.getDefaultConfig(), this.extraModelInfo.getExtraFlavorSourceProviders(this.variantManager.getDefaultConfig().getProductFlavor().getName())));
        for (BuildTypeData buildTypeData : this.variantManager.getBuildTypes().values()) {
            androidProject.addBuildType(BuildTypeContainerImpl.create(buildTypeData, this.extraModelInfo.getExtraBuildTypeSourceProviders(buildTypeData.getBuildType().getName())));
        }
        for (ProductFlavorData productFlavorData : this.variantManager.getProductFlavors().values()) {
            androidProject.addProductFlavors(ProductFlavorContainerImpl.createProductFlavorContainer(productFlavorData, this.extraModelInfo.getExtraFlavorSourceProviders(productFlavorData.getProductFlavor().getName())));
        }
        for (BaseVariantData baseVariantData : this.variantManager.getVariantDataList()) {
            if (baseVariantData.getType().isForTesting()) continue;
            androidProject.addVariant(this.createVariant(baseVariantData));
        }
        return androidProject;
    }

    public static Map<Abi, NativeToolchain> createNativeToolchainModelMap(NdkHandler ndkHandler) {
        if (!ndkHandler.isNdkDirConfigured()) {
            return ImmutableMap.of();
        }
        HashMap toolchains = Maps.newHashMap();
        for (Abi abi : ndkHandler.getSupportedAbis()) {
            toolchains.put(abi, new NativeToolchainImpl(ndkHandler.getToolchain().getName() + "-" + abi.getName(), ndkHandler.getCCompiler(abi), ndkHandler.getCppCompiler(abi)));
        }
        return toolchains;
    }

    private VariantImpl createVariant(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        AndroidArtifact mainArtifact = this.createAndroidArtifact("_main_", variantData);
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        String variantName = variantConfiguration.getFullName();
        ArrayList extraAndroidArtifacts = Lists.newArrayList(this.extraModelInfo.getExtraAndroidArtifacts(variantName));
        Collection<JavaArtifact> extraJavaArtifacts = this.extraModelInfo.getExtraJavaArtifacts(variantName);
        ArrayList clonedExtraJavaArtifacts = Lists.newArrayListWithCapacity((int)extraJavaArtifacts.size());
        for (JavaArtifact javaArtifact : extraJavaArtifacts) {
            clonedExtraJavaArtifacts.add(JavaArtifactImpl.clone(javaArtifact));
        }
        if (variantData instanceof TestedVariantData) {
            block5: for (VariantType variantType : VariantType.getTestingTypes()) {
                VariantType type;
                TestVariantData testVariantData = ((TestedVariantData)((Object)variantData)).getTestVariantData(variantType);
                if (testVariantData == null || (type = testVariantData.getType()) == null) continue;
                switch (type) {
                    case ANDROID_TEST: {
                        extraAndroidArtifacts.add(this.createAndroidArtifact(variantType.getArtifactName(), testVariantData));
                        continue block5;
                    }
                    case UNIT_TEST: {
                        clonedExtraJavaArtifacts.add(this.createUnitTestsJavaArtifact(variantType, testVariantData));
                        continue block5;
                    }
                }
                throw new IllegalArgumentException("Unsupported test variant type ${variantType}.");
            }
        }
        ApiVersion sdkVersionOverride = null;
        IAndroidTarget androidTarget = this.androidBuilder.getTargetInfo().getTarget();
        AndroidVersion version = androidTarget.getVersion();
        if (version.getCodename() != null) {
            sdkVersionOverride = ApiVersionImpl.clone(version);
        }
        return new VariantImpl(variantName, variantConfiguration.getBaseName(), ((CoreBuildType)variantConfiguration.getBuildType()).getName(), ModelBuilder.getProductFlavorNames(variantData), ProductFlavorImpl.cloneFlavor(variantConfiguration.getMergedFlavor(), sdkVersionOverride, sdkVersionOverride), mainArtifact, extraAndroidArtifacts, clonedExtraJavaArtifacts);
    }

    private JavaArtifactImpl createUnitTestsJavaArtifact(VariantType variantType, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        DependenciesImpl dependencies = DependenciesImpl.cloneDependencies(variantData, this.androidBuilder);
        List<File> extraGeneratedSourceFolders = variantData.getExtraGeneratedSourceFolders();
        return new JavaArtifactImpl(variantType.getArtifactName(), variantData.assembleVariantTask.getName(), variantData.getScope().getCompileTask().getName(), Sets.newHashSet((Object[])new String[]{variantData.prepareDependenciesTask.getName(), this.taskManager.createMockableJar.getName()}), extraGeneratedSourceFolders != null ? extraGeneratedSourceFolders : Collections.emptyList(), variantData.javacTask != null ? variantData.javacTask.getDestinationDir() : variantData.getScope().getJavaOutputDir(), variantData.getJavaResourcesForUnitTesting(), this.taskManager.getGlobalScope().getMockableAndroidJarFile(), dependencies, sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider);
    }

    private Collection<NativeLibrary> createNativeLibraries(Collection<Abi> abis, VariantScope scope) {
        ArrayList nativeLibraries = Lists.newArrayListWithCapacity((int)abis.size());
        for (Abi abi : abis) {
            Optional<NativeLibrary> lib;
            NativeToolchain toolchain = this.toolchains.get((Object)abi);
            if (toolchain == null || !(lib = this.nativeLibFactory.create(scope, toolchain.getName(), abi)).isPresent()) continue;
            nativeLibraries.add(lib.get());
        }
        return nativeLibraries;
    }

    private AndroidArtifact createAndroidArtifact(String name, BaseVariantData<? extends BaseVariantOutputData> variantData) {
        VariantScope scope = variantData.getScope();
        GradleVariantConfiguration variantConfiguration = variantData.getVariantConfiguration();
        SigningConfig signingConfig = variantConfiguration.getSigningConfig();
        String signingConfigName = null;
        if (signingConfig != null) {
            signingConfigName = signingConfig.getName();
        }
        SourceProviders sourceProviders = ModelBuilder.determineSourceProviders(variantData);
        List<? extends BaseVariantOutputData> variantOutputs = variantData.getOutputs();
        ArrayList outputs = Lists.newArrayListWithCapacity((int)variantOutputs.size());
        CoreNdkOptions ndkConfig = variantData.getVariantConfiguration().getNdkConfig();
        Object nativeLibraries = ImmutableList.of();
        if (this.ndkHandler.getNdkDirectory() != null) {
            nativeLibraries = this.config.getSplits().getAbi().isEnable() ? this.createNativeLibraries(this.config.getSplits().getAbi().isUniversalApk() ? this.ndkHandler.getSupportedAbis() : ModelBuilder.createAbiList(this.config.getSplits().getAbiFilters()), scope) : (ndkConfig.getAbiFilters() == null || ndkConfig.getAbiFilters().isEmpty() ? this.createNativeLibraries(this.ndkHandler.getSupportedAbis(), scope) : this.createNativeLibraries(ModelBuilder.createAbiList(ndkConfig.getAbiFilters()), scope));
        }
        for (BaseVariantOutputData baseVariantOutputData : variantOutputs) {
            Integer versionCode;
            int intVersionCode = baseVariantOutputData instanceof ApkVariantOutputData ? baseVariantOutputData.getVersionCode() : ((versionCode = variantConfiguration.getMergedFlavor().getVersionCode()) != null ? versionCode : 1);
            ImmutableList.Builder outputFiles = ImmutableList.builder();
            outputFiles.add((Object)new OutputFileImpl(baseVariantOutputData.getMainOutputFile().getFilters(), baseVariantOutputData.getMainOutputFile().getType().name(), baseVariantOutputData.getOutputFile()));
            for (ApkOutputFile splitApk : baseVariantOutputData.getOutputs()) {
                if (splitApk.getType() != OutputFile.OutputType.SPLIT) continue;
                outputFiles.add((Object)new OutputFileImpl(splitApk.getFilters(), OutputFile.SPLIT, splitApk.getOutputFile()));
            }
            outputs.add(new AndroidArtifactOutputImpl((Collection<OutputFile>)outputFiles.build(), "assemble" + baseVariantOutputData.getFullName(), baseVariantOutputData.getScope().getManifestOutputFile(), intVersionCode));
        }
        InstantRunImpl instantRun = new InstantRunImpl(InstantRunAnchorTask.ConfigAction.getName(scope), InstantRunWrapperTask.ConfigAction.getBuildInfoFile(scope), variantConfiguration.isInstantRunSupported());
        return new AndroidArtifactImpl(name, outputs, variantData.assembleVariantTask == null ? scope.getTaskName("assemble") : variantData.assembleVariantTask.getName(), variantConfiguration.isSigningReady() || variantData.outputsAreSigned, signingConfigName, variantConfiguration.getApplicationId(), scope.getSourceGenTask() == null ? scope.getTaskName("generate", "Sources") : scope.getSourceGenTask().getName(), scope.getCompileTask() == null ? scope.getTaskName("compile", "Sources") : scope.getCompileTask().getName(), ModelBuilder.getGeneratedSourceFolders(variantData), ModelBuilder.getGeneratedResourceFolders(variantData), variantData.javacTask != null ? variantData.javacTask.getDestinationDir() : scope.getJavaOutputDir(), scope.getVariantData().getJavaResourcesForUnitTesting(), DependenciesImpl.cloneDependencies(variantData, this.androidBuilder), sourceProviders.variantSourceProvider, sourceProviders.multiFlavorSourceProvider, variantConfiguration.getSupportedAbis(), (Collection<NativeLibrary>)nativeLibraries, variantConfiguration.getMergedBuildConfigFields(), variantConfiguration.getMergedResValues(), instantRun);
    }

    private static Collection<Abi> createAbiList(Collection<String> abiNames) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String abiName : abiNames) {
            Abi abi = Abi.getByName(abiName);
            if (abi == null) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    private static SourceProviders determineSourceProviders(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        SourceProvider variantSourceProvider = variantData.getVariantConfiguration().getVariantSourceProvider();
        SourceProvider multiFlavorSourceProvider = variantData.getVariantConfiguration().getMultiFlavorSourceProvider();
        return new SourceProviders(variantSourceProvider != null ? SourceProviderImpl.cloneProvider(variantSourceProvider) : null, multiFlavorSourceProvider != null ? SourceProviderImpl.cloneProvider(multiFlavorSourceProvider) : null);
    }

    private static List<String> getProductFlavorNames(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        List productFlavors = variantData.getVariantConfiguration().getProductFlavors();
        ArrayList flavorNames = Lists.newArrayListWithCapacity((int)productFlavors.size());
        for (CoreProductFlavor flavor : productFlavors) {
            flavorNames.add(flavor.getName());
        }
        return flavorNames;
    }

    private static List<File> getGeneratedSourceFolders(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        ArrayList folders;
        if (variantData == null) {
            return Collections.emptyList();
        }
        List<File> extraFolders = variantData.getExtraGeneratedSourceFolders();
        if (extraFolders != null) {
            folders = Lists.newArrayListWithExpectedSize((int)(5 + extraFolders.size()));
            folders.addAll(extraFolders);
        } else {
            folders = Lists.newArrayListWithExpectedSize((int)5);
        }
        VariantScope scope = variantData.getScope();
        folders.add(scope.getRClassSourceOutputDir());
        folders.add(scope.getAidlSourceOutputDir());
        folders.add(scope.getBuildConfigSourceOutputDir());
        Boolean ndkMode = variantData.getVariantConfiguration().getMergedFlavor().getRenderscriptNdkModeEnabled();
        if (ndkMode == null || !ndkMode.booleanValue()) {
            folders.add(scope.getRenderscriptSourceOutputDir());
        }
        return folders;
    }

    private static List<File> getGeneratedResourceFolders(BaseVariantData<? extends BaseVariantOutputData> variantData) {
        ArrayList result;
        if (variantData == null) {
            return Collections.emptyList();
        }
        List<File> extraFolders = variantData.getExtraGeneratedResFolders();
        if (extraFolders != null && !extraFolders.isEmpty()) {
            result = Lists.newArrayListWithCapacity((int)(extraFolders.size() + 2));
            result.addAll(extraFolders);
        } else {
            result = Lists.newArrayListWithCapacity((int)2);
        }
        VariantScope scope = variantData.getScope();
        result.add(scope.getRenderscriptResOutputDir());
        result.add(scope.getGeneratedResOutputDir());
        return result;
    }

    private static Collection<SigningConfig> cloneSigningConfigs(Collection<? extends SigningConfig> signingConfigs) {
        ArrayList results = Lists.newArrayListWithCapacity((int)signingConfigs.size());
        for (SigningConfig signingConfig : signingConfigs) {
            results.add(SigningConfigImpl.createSigningConfig(signingConfig));
        }
        return results;
    }

    private static SourceProviderContainer getSourceProviderContainer(Collection<SourceProviderContainer> items, String name) {
        for (SourceProviderContainer item : items) {
            if (!name.equals(item.getArtifactName())) continue;
            return item;
        }
        return null;
    }

    private static Collection<String> findUnresolvedDependencies(Collection<SyncIssue> syncIssues) {
        ArrayList unresolvedDependencies = Lists.newArrayList();
        for (SyncIssue issue : syncIssues) {
            if (issue.getType() != 2) continue;
            unresolvedDependencies.add(issue.getData());
        }
        return unresolvedDependencies;
    }

    private static class SourceProviders {
        protected SourceProviderImpl variantSourceProvider;
        protected SourceProviderImpl multiFlavorSourceProvider;

        public SourceProviders(SourceProviderImpl variantSourceProvider, SourceProviderImpl multiFlavorSourceProvider) {
            this.variantSourceProvider = variantSourceProvider;
            this.multiFlavorSourceProvider = multiFlavorSourceProvider;
        }
    }
}

