/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal;

import com.android.build.gradle.internal.core.Abi;
import com.android.build.gradle.internal.core.Toolchain;
import com.android.repository.Revision;
import com.android.sdklib.AndroidTargetHash;
import com.android.sdklib.AndroidVersion;
import com.android.utils.FileUtils;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.gradle.api.InvalidUserDataException;

public class NdkHandler {
    private String platformVersion;
    private boolean resolvedSdkVersion;
    private final Toolchain toolchain;
    private final String toolchainVersion;
    private final File ndkDirectory;
    private final Revision revision;
    private Map<Pair<Toolchain, Abi>, String> defaultToolchainVersions = Maps.newHashMap();

    public NdkHandler(File projectDir, String platformVersion, String toolchainName, String toolchainVersion) {
        if (platformVersion != null) {
            this.setPlatformVersion(platformVersion);
        }
        this.toolchain = Toolchain.getByName(toolchainName);
        this.toolchainVersion = toolchainVersion;
        this.ndkDirectory = NdkHandler.findNdkDirectory(projectDir);
        this.revision = this.isNdkDirConfigured() ? this.readRevision() : null;
    }

    public Revision getRevision() {
        return this.revision;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Revision readRevision() {
        Properties properties = new Properties();
        InputStreamReader reader = null;
        File sourceProperties = new File(this.ndkDirectory, "source.properties");
        try {
            FileInputStream fis = new FileInputStream(sourceProperties);
            reader = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
            properties.load(reader);
            try {
                Closeables.close((Closeable)reader, (boolean)true);
            }
            catch (IOException e) {}
        }
        catch (FileNotFoundException ignored) {
            Revision revision = null;
            return revision;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(String.format("Unable to read %1$s.", sourceProperties), e);
            }
        }
        finally {
            try {
                Closeables.close(reader, (boolean)true);
            }
            catch (IOException e) {}
        }
        String rev = properties.getProperty("Pkg.Revision");
        if (rev != null) return Revision.parseRevision((String)rev);
        return null;
    }

    private String getPlatformVersion() {
        if (!this.resolvedSdkVersion) {
            this.resolveCompileSdkVersion();
        }
        return this.platformVersion;
    }

    private void resolveCompileSdkVersion() {
        if (!this.isNdkDirConfigured() || this.platformVersion == null) {
            return;
        }
        File platformFolder = new File(this.ndkDirectory, "/platforms/" + this.platformVersion);
        if (!platformFolder.exists()) {
            int targetVersion;
            try {
                targetVersion = Integer.parseInt(this.platformVersion.substring("android-".length()));
            }
            catch (NumberFormatException ignore) {
                targetVersion = Integer.MAX_VALUE;
            }
            File[] platformFolders = new File(this.ndkDirectory, "/platforms/").listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isDirectory();
                }
            });
            int highestVersion = 0;
            for (File platform : platformFolders) {
                if (!platform.getName().startsWith("android-")) continue;
                try {
                    int version = Integer.parseInt(platform.getName().substring("android-".length()));
                    if (version <= highestVersion || version >= targetVersion) continue;
                    highestVersion = version;
                    this.platformVersion = "android-" + version;
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
        }
        this.resolvedSdkVersion = true;
    }

    public void setPlatformVersion(String platformVersion) {
        AndroidVersion androidVersion = AndroidTargetHash.getVersionFromHash((String)platformVersion);
        this.platformVersion = androidVersion == null ? null : AndroidTargetHash.getPlatformHashString((AndroidVersion)androidVersion);
        this.resolvedSdkVersion = false;
    }

    public Toolchain getToolchain() {
        return this.toolchain;
    }

    public String getToolchainVersion() {
        return this.toolchainVersion;
    }

    /*
     * Loose catch block
     */
    private static File findNdkDirectory(File projectDir) {
        block16: {
            block14: {
                Properties properties;
                block15: {
                    File localProperties = new File(projectDir, "local.properties");
                    if (!localProperties.isFile()) break block14;
                    properties = new Properties();
                    InputStreamReader reader = null;
                    FileInputStream fis = new FileInputStream(localProperties);
                    reader = new InputStreamReader((InputStream)fis, Charsets.UTF_8);
                    properties.load(reader);
                    try {
                        Closeables.close((Closeable)reader, (boolean)true);
                    }
                    catch (IOException e) {}
                    break block15;
                    catch (FileNotFoundException ignored) {
                        try {
                            Closeables.close(reader, (boolean)true);
                        }
                        catch (IOException e) {}
                    }
                    catch (IOException e) {
                        throw new RuntimeException(String.format("Unable to read %1$s.", localProperties), e);
                        {
                            catch (Throwable throwable) {
                                try {
                                    Closeables.close(reader, (boolean)true);
                                }
                                catch (IOException e2) {
                                    // empty catch block
                                }
                                throw throwable;
                            }
                        }
                    }
                }
                String ndkDirProp = properties.getProperty("ndk.dir");
                if (ndkDirProp != null) {
                    return new File(ndkDirProp);
                }
                break block16;
            }
            String envVar = System.getenv("ANDROID_NDK_HOME");
            if (envVar != null) {
                return new File(envVar);
            }
        }
        return null;
    }

    public File getNdkDirectory() {
        return this.ndkDirectory;
    }

    public boolean isNdkDirConfigured() {
        return this.ndkDirectory != null;
    }

    private static String getToolchainPrefix(Toolchain toolchain, Abi abi) {
        if (toolchain == Toolchain.GCC) {
            return abi.getGccToolchainPrefix();
        }
        return "llvm";
    }

    private File getToolchainPath(Toolchain toolchain, String toolchainVersion, Abi abi) {
        String version = toolchainVersion.isEmpty() ? this.getDefaultToolchainVersion(toolchain, abi) : toolchainVersion;
        version = version.isEmpty() ? "" : "-" + version;
        File prebuiltFolder = new File(this.ndkDirectory, "toolchains/" + NdkHandler.getToolchainPrefix(toolchain, abi) + version + "/prebuilt");
        String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String hostOs = osName.contains("windows") ? "windows" : (osName.contains("mac") ? "darwin" : "linux");
        File[] toolchainPaths = prebuiltFolder.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory();
            }
        });
        if (toolchainPaths == null) {
            throw new InvalidUserDataException("Unable to find toolchain: " + prebuiltFolder);
        }
        if (toolchainPaths.length == 1) {
            return toolchainPaths[0];
        }
        File toolchainPath = new File(prebuiltFolder, hostOs + "-x86_64");
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        String osString = osName.equals("windows") ? hostOs : hostOs + "-x86";
        toolchainPath = new File(prebuiltFolder, osString);
        if (toolchainPath.isDirectory()) {
            return toolchainPath;
        }
        throw new InvalidUserDataException("Unable to find toolchain prebuilt folder in: " + prebuiltFolder);
    }

    public String getSysroot(Abi abi) {
        if (this.getPlatformVersion() == null) {
            return "";
        }
        return this.ndkDirectory + "/platforms/" + this.getPlatformVersion() + "/arch-" + abi.getArchitecture();
    }

    public boolean supports64Bits() {
        if (this.getPlatformVersion() == null) {
            return false;
        }
        String targetString = this.getPlatformVersion().replace("android-", "");
        try {
            return Integer.parseInt(targetString) >= 20;
        }
        catch (NumberFormatException ignored) {
            return true;
        }
    }

    private String getDefaultToolchainVersion(Toolchain toolchain, Abi abi) {
        String defaultVersion = this.defaultToolchainVersions.get(Pair.of((Object)((Object)toolchain), (Object)((Object)abi)));
        if (defaultVersion != null) {
            return defaultVersion;
        }
        File toolchains = new File(this.ndkDirectory, "toolchains");
        final String toolchainPrefix = NdkHandler.getToolchainPrefix(toolchain, abi);
        File[] toolchainsForAbi = toolchains.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(toolchainPrefix);
            }
        });
        if (toolchainsForAbi == null || toolchainsForAbi.length == 0) {
            throw new RuntimeException("No toolchains found in the NDK toolchains folder for ABI with prefix: " + toolchainPrefix);
        }
        Revision bestRevision = null;
        String bestVersionString = "";
        for (File toolchainFolder : toolchainsForAbi) {
            String folderName = toolchainFolder.getName();
            Revision revision = new Revision(0);
            String versionString = "";
            if (folderName.length() > toolchainPrefix.length() + 1) {
                try {
                    versionString = folderName.substring(toolchainPrefix.length() + 1);
                    revision = Revision.parseRevision((String)versionString);
                }
                catch (NumberFormatException ignore) {
                    // empty catch block
                }
            }
            if (bestRevision != null && revision.compareTo(bestRevision) <= 0) continue;
            bestRevision = revision;
            bestVersionString = versionString;
        }
        this.defaultToolchainVersions.put((Pair<Toolchain, Abi>)Pair.of((Object)((Object)toolchain), (Object)((Object)abi)), bestVersionString);
        if (bestRevision == null) {
            throw new RuntimeException("Unable to find a valid toolchain in " + toolchains);
        }
        return bestVersionString;
    }

    public String getGccToolchainVersion(Abi abi) {
        return this.toolchain == Toolchain.GCC && !this.toolchainVersion.isEmpty() ? this.toolchainVersion : this.getDefaultToolchainVersion(Toolchain.GCC, abi);
    }

    public File getDefaultGccToolchainPath(Abi abi) {
        return this.getToolchainPath(Toolchain.GCC, this.getGccToolchainVersion(abi), abi);
    }

    public static Collection<Abi> getAbiList() {
        return ImmutableList.copyOf((Object[])Abi.values());
    }

    public static Collection<Abi> getAbiList32() {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (Abi abi : Abi.values()) {
            if (abi.supports64Bits()) continue;
            builder.add((Object)abi);
        }
        return builder.build();
    }

    public Collection<Abi> getSupportedAbis() {
        return this.supports64Bits() ? NdkHandler.getAbiList() : NdkHandler.getAbiList32();
    }

    public File getCCompiler(Abi abi) {
        String compiler = this.toolchain == Toolchain.CLANG ? "clang" : abi.getGccExecutablePrefix() + "-gcc";
        return new File(this.getToolchainPath(this.toolchain, this.toolchainVersion, abi), "bin/" + compiler);
    }

    public File getCppCompiler(Abi abi) {
        String compiler = this.toolchain == Toolchain.CLANG ? "clang++" : abi.getGccExecutablePrefix() + "-g++";
        return new File(this.getToolchainPath(this.toolchain, this.toolchainVersion, abi), "bin/" + compiler);
    }

    public File getStripCommand(Abi abi) {
        return FileUtils.join((File)this.getDefaultGccToolchainPath(abi), (String[])new String[]{"bin", abi.getGccExecutablePrefix() + "-strip"});
    }

    public List<File> getStlIncludes(String stlName, String stlVersion, Abi abi) {
        File stlBaseDir = new File(this.ndkDirectory, "sources/cxx-stl/");
        if (stlName == null || stlName.isEmpty()) {
            stlName = "system";
        } else if (stlName.contains("_")) {
            stlName = stlName.substring(0, stlName.indexOf(95));
        }
        ArrayList includeDirs = Lists.newArrayList();
        if (stlName.equals("system")) {
            includeDirs.add(new File(stlBaseDir, "system/include"));
        } else if (stlName.equals("stlport")) {
            includeDirs.add(new File(stlBaseDir, "stlport/stlport"));
            includeDirs.add(new File(stlBaseDir, "gabi++/include"));
        } else if (stlName.equals("gnustl")) {
            String version = stlVersion != null ? stlVersion : this.getGccToolchainVersion(abi);
            includeDirs.add(new File(stlBaseDir, "gnu-libstdc++/" + version + "/include"));
            includeDirs.add(new File(stlBaseDir, "gnu-libstdc++/" + version + "/libs/" + abi.getName() + "/include"));
            includeDirs.add(new File(stlBaseDir, "gnu-libstdc++/" + version + "/include/backward"));
        } else if (stlName.equals("gabi++")) {
            includeDirs.add(new File(stlBaseDir, "gabi++/include"));
        } else if (stlName.equals("c++")) {
            includeDirs.add(new File(stlBaseDir, "llvm-libc++/libcxx/include"));
            if (this.revision == null || this.revision.getMajor() < 12) {
                includeDirs.add(new File(stlBaseDir, "gabi++/include"));
            }
            includeDirs.add(new File(stlBaseDir, "../android/support/include"));
        }
        return includeDirs;
    }
}

