/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import java.util.HashSet;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LineNumberNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TryCatchBlockNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.objectweb.asm.tree.analysis.Analyzer;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;
import org.objectweb.asm.tree.analysis.Frame;
import org.objectweb.asm.tree.analysis.Interpreter;
import org.objectweb.asm.tree.analysis.Value;

public class ConstructorDelegationDetector {
    public static Constructor deconstruct(String owner, MethodNode method) {
        BasicInterpreter interpreter = new BasicInterpreter(){
            boolean done = false;

            public BasicValue newValue(Type type) {
                if (type == null) {
                    return BasicValue.UNINITIALIZED_VALUE;
                }
                if (type.getSort() == 0) {
                    return null;
                }
                LocalValue ret = this.done ? super.newValue(type) : new LocalValue(type);
                this.done = true;
                return ret;
            }
        };
        Analyzer analyzer = new Analyzer((Interpreter)interpreter);
        AbstractInsnNode[] instructions = method.instructions.toArray();
        try {
            Frame[] frames = analyzer.analyze(owner, method);
            if (frames.length != instructions.length) {
                throw new IllegalStateException("The number of frames is not equals to the number of instructions");
            }
            VarInsnNode lastThis = null;
            int stackAtThis = -1;
            boolean poppedThis = false;
            int recentLine = -1;
            for (int i = 0; i < instructions.length; ++i) {
                AbstractInsnNode insn = instructions[i];
                Frame frame = frames[i];
                if (frame.getStackSize() < stackAtThis) {
                    poppedThis = true;
                }
                if (insn instanceof MethodInsnNode) {
                    MethodInsnNode methodhInsn = (MethodInsnNode)insn;
                    Type[] types = Type.getArgumentTypes((String)methodhInsn.desc);
                    Value value = frame.getStack(frame.getStackSize() - types.length - 1);
                    if (!(value instanceof LocalValue) || !methodhInsn.name.equals("<init>")) continue;
                    if (poppedThis) {
                        throw new IllegalStateException("Unexpected constructor structure.");
                    }
                    return ConstructorDelegationDetector.split(owner, method, lastThis, methodhInsn, recentLine);
                }
                if (insn instanceof VarInsnNode) {
                    VarInsnNode var = (VarInsnNode)insn;
                    if (var.var != 0) continue;
                    lastThis = var;
                    stackAtThis = frame.getStackSize();
                    poppedThis = false;
                    continue;
                }
                if (!(insn instanceof LineNumberNode)) continue;
                LineNumberNode lineNumberNode = (LineNumberNode)insn;
                recentLine = lineNumberNode.line;
            }
            throw new IllegalStateException("Unexpected constructor structure.");
        }
        catch (AnalyzerException e) {
            throw new IllegalStateException(e);
        }
    }

    private static Constructor split(String owner, MethodNode method, VarInsnNode loadThis, MethodInsnNode delegation, int loadThisLine) {
        AbstractInsnNode insn;
        String[] exceptions = method.exceptions.toArray(new String[method.exceptions.size()]);
        String newDesc = method.desc.replaceAll("\\((.*)\\)V", "([Ljava/lang/Object;$1)Ljava/lang/Object;");
        MethodNode initArgs = new MethodNode(9, "init$args", newDesc, null, exceptions);
        for (insn = loadThis.getNext(); insn != delegation; insn = insn.getNext()) {
            insn.accept((MethodVisitor)initArgs);
        }
        LabelNode labelBefore = new LabelNode();
        labelBefore.accept((MethodVisitor)initArgs);
        GeneratorAdapter mv = new GeneratorAdapter((MethodVisitor)initArgs, initArgs.access, initArgs.name, initArgs.desc);
        Type[] types = Type.getArgumentTypes((String)initArgs.desc);
        int stack = 1;
        for (int i = 1; i < types.length; ++i) {
            Type type = types[i];
            mv.visitVarInsn(25, 0);
            mv.push(i);
            mv.visitVarInsn(type.getOpcode(21), stack);
            mv.box(type);
            mv.arrayStore(Type.getType(Object.class));
            stack += type.getSize();
        }
        Type[] returnTypes = Type.getArgumentTypes((String)delegation.desc);
        mv.push(returnTypes.length + 1);
        mv.newArray(Type.getType(Object.class));
        int args = mv.newLocal(Type.getType((String)"[Ljava/lang/Object;"));
        mv.storeLocal(args);
        for (int i = returnTypes.length - 1; i >= 0; --i) {
            Type type = returnTypes[i];
            mv.loadLocal(args);
            mv.swap(type, Type.getType(Object.class));
            mv.push(i + 1);
            mv.swap(type, Type.INT_TYPE);
            mv.box(type);
            mv.arrayStore(Type.getType(Object.class));
        }
        mv.loadLocal(args);
        mv.push(0);
        mv.push(delegation.owner + "." + delegation.desc);
        mv.arrayStore(Type.getType(Object.class));
        mv.loadLocal(args);
        mv.returnValue();
        newDesc = method.desc.replace("(", "(L" + owner + ";");
        MethodNode body = new MethodNode(9, "init$body", newDesc, null, exceptions);
        LabelNode labelAfter = new LabelNode();
        labelAfter.accept((MethodVisitor)body);
        HashSet<LabelNode> bodyLabels = new HashSet<LabelNode>();
        for (insn = delegation.getNext(); insn != null; insn = insn.getNext()) {
            if (insn instanceof LabelNode) {
                bodyLabels.add((LabelNode)insn);
            }
            insn.accept((MethodVisitor)body);
        }
        for (TryCatchBlockNode tryCatch : method.tryCatchBlocks) {
            tryCatch.accept((MethodVisitor)body);
        }
        for (LocalVariableNode variable : method.localVariables) {
            boolean startsInBody = bodyLabels.contains(variable.start);
            boolean endsInBody = bodyLabels.contains(variable.end);
            if (!startsInBody && !endsInBody) {
                if (variable.index == 0) continue;
                variable.accept((MethodVisitor)initArgs);
                continue;
            }
            if (startsInBody && endsInBody) {
                variable.accept((MethodVisitor)body);
                continue;
            }
            if (!startsInBody && endsInBody) {
                if (variable.index != 0) {
                    LocalVariableNode var0 = new LocalVariableNode(variable.name, variable.desc, variable.signature, variable.start, labelBefore, variable.index);
                    var0.accept((MethodVisitor)initArgs);
                }
                LocalVariableNode var1 = new LocalVariableNode(variable.name, variable.desc, variable.signature, labelAfter, variable.end, variable.index);
                var1.accept((MethodVisitor)body);
                continue;
            }
            throw new IllegalStateException("Local variable starts after it ends.");
        }
        return new Constructor(loadThis, loadThisLine, initArgs, delegation, body);
    }

    static class Constructor {
        public final VarInsnNode loadThis;
        public final int lineForLoad;
        public final MethodNode args;
        public final MethodInsnNode delegation;
        public final MethodNode body;

        Constructor(VarInsnNode loadThis, int lineForLoad, MethodNode args, MethodInsnNode delegation, MethodNode body) {
            this.loadThis = loadThis;
            this.lineForLoad = lineForLoad;
            this.args = args;
            this.delegation = delegation;
            this.body = body;
        }
    }

    public static class LocalValue
    extends BasicValue {
        public LocalValue(Type type) {
            super(type);
        }

        public String toString() {
            return "*";
        }
    }
}

