/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.ColdswapMode;
import com.android.sdklib.AndroidVersion;
import com.google.common.base.Strings;
import java.util.Locale;

public enum InstantRunPatchingPolicy {
    PRE_LOLLIPOP,
    MULTI_DEX,
    MULTI_APK;


    public static InstantRunPatchingPolicy getPatchingPolicy(AndroidVersion version, String coldswapMode, String targetArchitecture) {
        if (version.compareTo(AndroidVersion.ART_RUNTIME) < 0) {
            return PRE_LOLLIPOP;
        }
        InstantRunPatchingPolicy defaultModeForArchitecture = MULTI_DEX;
        if (Strings.isNullOrEmpty((String)coldswapMode)) {
            return defaultModeForArchitecture;
        }
        ColdswapMode coldswap = ColdswapMode.valueOf(coldswapMode.toUpperCase(Locale.US));
        switch (coldswap) {
            case MULTIAPK: {
                return MULTI_APK;
            }
            case MULTIDEX: {
                return MULTI_DEX;
            }
            case AUTO: {
                if (version.getApiLevel() < 23) {
                    return MULTI_DEX;
                }
                return MULTI_APK;
            }
            case DEFAULT: {
                return MULTI_DEX;
            }
        }
        throw new RuntimeException("Cold-swap case not handled " + (Object)((Object)coldswap));
    }
}

