/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.incremental;

import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.transforms.InstantRunBuildType;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import java.io.File;
import java.nio.charset.Charset;
import java.util.Locale;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.logging.Logger;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;

public class InstantRunWrapperTask
extends BaseTask {
    @OutputFile
    File buildInfoFile;
    @Input
    String buildId;
    TaskType taskType;
    File incrementChangesFile;
    File tmpBuildInfoFile;
    Logger logger;
    InstantRunBuildContext instantRunBuildContext;

    @TaskAction
    public void executeAction() {
        InstantRunBuildContext.PersistenceMode persistenceMode = this.taskType == TaskType.FULL ? InstantRunBuildContext.PersistenceMode.FULL_BUILD : InstantRunBuildContext.PersistenceMode.INCREMENTAL_BUILD;
        this.instantRunBuildContext.close(persistenceMode);
        try {
            String xml = this.instantRunBuildContext.toXml(persistenceMode);
            if (this.logger.isEnabled(LogLevel.DEBUG)) {
                this.logger.debug("build-id $1$l, build-info.xml : %2$s", (Object)this.instantRunBuildContext.getBuildId(), (Object)xml);
            }
            Files.createParentDirs((File)this.buildInfoFile);
            Files.write((CharSequence)xml, (File)this.buildInfoFile, (Charset)Charsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("Exception while saving build-info.xml : %s", e.getMessage()));
        }
        if (this.taskType == TaskType.FULL && this.incrementChangesFile.exists() && !this.incrementChangesFile.delete()) {
            this.logger.warn(String.format("Cannot delete %1$s", this.incrementChangesFile));
        }
        if (this.tmpBuildInfoFile.exists() && !this.tmpBuildInfoFile.delete()) {
            this.logger.warn(String.format("Cannot delete %1$s", this.tmpBuildInfoFile));
        }
    }

    public static class ConfigAction
    implements TaskConfigAction<InstantRunWrapperTask> {
        private final String taskName;
        private final TaskType taskType;
        private final File incrementalChangesFile;
        private final VariantScope variantScope;
        private final Logger logger;

        public static File getBuildInfoFile(VariantScope scope) {
            return new File(scope.getRestartDexOutputFolder(), "build-info.xml");
        }

        public static File getTmpBuildInfoFile(VariantScope scope) {
            return new File(scope.getRestartDexOutputFolder(), "tmp-build-info.xml");
        }

        public ConfigAction(VariantScope scope, TaskType taskType, Logger logger) {
            this.taskName = scope.getTaskName(taskType.name().toLowerCase(Locale.getDefault()), "BuildInfoGenerator");
            this.variantScope = scope;
            this.logger = logger;
            this.taskType = taskType;
            this.incrementalChangesFile = InstantRunBuildType.RESTART.getIncrementalChangesFile(this.variantScope);
        }

        @Override
        public String getName() {
            return this.taskName;
        }

        @Override
        public Class<InstantRunWrapperTask> getType() {
            return InstantRunWrapperTask.class;
        }

        @Override
        public void execute(InstantRunWrapperTask task) {
            task.setDescription("InstantRun task to build incremental artifacts");
            task.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
            task.buildInfoFile = ConfigAction.getBuildInfoFile(this.variantScope);
            task.tmpBuildInfoFile = ConfigAction.getTmpBuildInfoFile(this.variantScope);
            task.instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            task.logger = this.logger;
            task.taskType = this.taskType;
            task.incrementChangesFile = this.incrementalChangesFile;
            task.buildId = String.valueOf(task.instantRunBuildContext.getBuildId());
        }
    }

    public static enum TaskType {
        INCREMENTAL,
        FULL;

    }
}

