/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.internal.transforms;

import com.android.build.gradle.internal.core.GradleVariantConfiguration;
import com.android.build.gradle.internal.dsl.AaptOptions;
import com.android.build.gradle.internal.incremental.InstantRunBuildContext;
import com.android.build.gradle.internal.scope.ConventionMappingHelper;
import com.android.build.gradle.internal.scope.TaskConfigAction;
import com.android.build.gradle.internal.scope.VariantScope;
import com.android.build.gradle.internal.tasks.BaseTask;
import com.android.build.gradle.internal.variant.ApkVariantOutputData;
import com.android.build.gradle.tasks.PackageApplication;
import com.android.builder.core.AaptPackageProcessBuilder;
import com.android.builder.model.SigningConfig;
import com.android.builder.packaging.DuplicateFileException;
import com.android.builder.packaging.PackagerException;
import com.android.builder.sdk.TargetInfo;
import com.android.ide.common.process.LoggedProcessOutputHandler;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessInfoBuilder;
import com.android.ide.common.process.ProcessOutputHandler;
import com.android.ide.common.signing.KeytoolException;
import com.android.sdklib.BuildToolInfo;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.incremental.IncrementalTaskInputs;
import org.gradle.api.tasks.incremental.InputFileDetails;

public class InstantRunSplitApkBuilder
extends BaseTask {
    private Set<File> dexFolders;
    private File outputDirectory;
    private SigningConfig signingConf;
    private String applicationId;
    private InstantRunBuildContext instantRunBuildContext;
    private File zipAlignExe;
    private AaptOptions aaptOptions;
    private File supportDir;
    private ApkVariantOutputData variantOutputData;

    @Input
    public String getApplicationId() {
        return this.applicationId;
    }

    public void setApplicationId(String applicationId) {
        this.applicationId = applicationId;
    }

    @Input
    public int getVersionCode() {
        return this.variantOutputData.getVersionCode();
    }

    @Input
    @Optional
    public String getVersionName() {
        return this.variantOutputData.getVersionName();
    }

    @InputFiles
    public Set<File> getDexFolders() {
        return this.dexFolders;
    }

    @OutputDirectory
    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    @Input
    public File getZipAlignExe() {
        return this.zipAlignExe;
    }

    @TaskAction
    public void run(IncrementalTaskInputs inputs) throws IOException, DuplicateFileException, KeytoolException, PackagerException, ProcessException, InterruptedException {
        if (inputs.isIncremental()) {
            inputs.outOfDate((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    try {
                        if (!inputFileDetails.getFile().getName().contains("main_slice")) {
                            InstantRunSplitApkBuilder.this.generateSplitApk(new DexFile(inputFileDetails.getFile(), inputFileDetails.getFile().getParentFile().getName()));
                        }
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            inputs.removed((Action)new Action<InputFileDetails>(){

                public void execute(InputFileDetails inputFileDetails) {
                    DexFile dexFile = new DexFile(inputFileDetails.getFile(), inputFileDetails.getFile().getParentFile().getName());
                    String outputFileName = dexFile.encodeName() + "_unaligned.apk";
                    new File(InstantRunSplitApkBuilder.this.getOutputDirectory(), outputFileName).delete();
                    outputFileName = dexFile.encodeName() + ".apk";
                    new File(InstantRunSplitApkBuilder.this.getOutputDirectory(), outputFileName).delete();
                }
            });
        } else {
            ArrayList<DexFile> allFiles = new ArrayList<DexFile>();
            for (File dexFolder : this.getDexFolders()) {
                File[] files;
                if (!dexFolder.isDirectory() || (files = dexFolder.listFiles()) == null) continue;
                for (File file : files) {
                    allFiles.add(new DexFile(file, dexFolder.getName()));
                }
            }
            for (DexFile file : allFiles) {
                if (file.dexFile.getParentFile().getName().contains("main_slice")) continue;
                this.generateSplitApk(file);
            }
        }
    }

    private void generateSplitApk(DexFile file) throws IOException, DuplicateFileException, KeytoolException, PackagerException, InterruptedException, ProcessException {
        File outputLocation = new File(this.getOutputDirectory(), file.encodeName() + "_unaligned.apk");
        Files.createParentDirs((File)outputLocation);
        File resPackageFile = this.generateSplitApkManifest(file.encodeName());
        this.getBuilder().packageCodeSplitApk(resPackageFile.getAbsolutePath(), file.dexFile, this.signingConf, outputLocation.getAbsolutePath());
        File alignedOutput = new File(this.getOutputDirectory(), file.encodeName() + ".apk");
        ProcessInfoBuilder processInfoBuilder = new ProcessInfoBuilder();
        processInfoBuilder.setExecutable(this.getZipAlignExe());
        processInfoBuilder.addArgs("-f", "4");
        processInfoBuilder.addArgs(outputLocation.getAbsolutePath());
        processInfoBuilder.addArgs(alignedOutput.getAbsolutePath());
        this.getBuilder().executeProcess(processInfoBuilder.createProcess(), (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
        this.instantRunBuildContext.addChangedFile(InstantRunBuildContext.FileType.SPLIT, alignedOutput);
        resPackageFile.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File generateSplitApkManifest(String uniqueName) throws IOException, ProcessException, InterruptedException {
        String versionNameToUse = this.getVersionName();
        if (versionNameToUse == null) {
            versionNameToUse = String.valueOf(this.getVersionCode());
        }
        File sliceSupportDir = new File(this.supportDir, uniqueName);
        sliceSupportDir.mkdirs();
        File androidManifest = new File(sliceSupportDir, "AndroidManifest.xml");
        OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(androidManifest), "UTF-8");
        try {
            fileWriter.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n      package=\"" + this.getApplicationId() + "\"\n" + "      android:versionCode=\"" + this.getVersionCode() + "\"\n" + "      android:versionName=\"" + versionNameToUse + "\"\n" + "      split=\"lib_" + uniqueName + "\">\n" + "</manifest>\n");
            fileWriter.flush();
        }
        finally {
            fileWriter.close();
        }
        File resFilePackageFile = new File(this.supportDir, "resources_ap");
        AaptPackageProcessBuilder aaptPackageCommandBuilder = new AaptPackageProcessBuilder(androidManifest, (com.android.builder.model.AaptOptions)this.getAaptOptions()).setDebuggable(true).setResPackageOutput(resFilePackageFile.getAbsolutePath());
        this.getBuilder().processResources(aaptPackageCommandBuilder, false, (ProcessOutputHandler)new LoggedProcessOutputHandler(this.getILogger()));
        return resFilePackageFile;
    }

    public AaptOptions getAaptOptions() {
        return this.aaptOptions;
    }

    public static class ConfigAction
    implements TaskConfigAction<InstantRunSplitApkBuilder> {
        private final VariantScope variantScope;

        public ConfigAction(VariantScope variantScope) {
            this.variantScope = variantScope;
        }

        @Override
        public String getName() {
            return this.variantScope.getTaskName("instantRun", "PureSplitBuilder");
        }

        @Override
        public Class<InstantRunSplitApkBuilder> getType() {
            return InstantRunSplitApkBuilder.class;
        }

        @Override
        public void execute(InstantRunSplitApkBuilder task) {
            final GradleVariantConfiguration config = this.variantScope.getVariantConfiguration();
            task.outputDirectory = this.variantScope.getInstantRunSplitApkOutputFolder();
            task.signingConf = config.getSigningConfig();
            task.setApplicationId(config.getApplicationId());
            task.variantOutputData = (ApkVariantOutputData)this.variantScope.getVariantData().getOutputs().get(0);
            task.setVariantName(this.variantScope.getVariantConfiguration().getFullName());
            task.setAndroidBuilder(this.variantScope.getGlobalScope().getAndroidBuilder());
            task.instantRunBuildContext = this.variantScope.getInstantRunBuildContext();
            task.supportDir = this.variantScope.getInstantRunSliceSupportDir();
            ConventionMappingHelper.map((Task)task, "zipAlignExe", new Callable<File>(){

                @Override
                public File call() throws Exception {
                    TargetInfo info = ConfigAction.this.variantScope.getGlobalScope().getAndroidBuilder().getTargetInfo();
                    if (info == null) {
                        return null;
                    }
                    String path = info.getBuildTools().getPath(BuildToolInfo.PathId.ZIP_ALIGN);
                    if (path == null) {
                        return null;
                    }
                    return new File(path);
                }
            });
            ConventionMappingHelper.map((Task)task, "dexFolders", new Callable<Set<File>>(){

                @Override
                public Set<File> call() {
                    if (config.getUseJack()) {
                        throw new IllegalStateException("InstantRun does not support Jack compiler yet.");
                    }
                    return ConfigAction.this.variantScope.getTransformManager().getPipelineOutput(PackageApplication.sDexFilter).keySet();
                }
            });
            ConventionMappingHelper.map((Task)task, "aaptOptions", new Callable<AaptOptions>(){

                @Override
                public AaptOptions call() throws Exception {
                    return ConfigAction.this.variantScope.getGlobalScope().getExtension().getAaptOptions();
                }
            });
        }
    }

    private static class DexFile {
        private final File dexFile;
        private final String dexFolderName;

        private DexFile(File dexFile, String dexFolderName) {
            this.dexFile = dexFile;
            this.dexFolderName = dexFolderName;
        }

        private String encodeName() {
            return this.dexFolderName.replace('-', '_');
        }
    }
}

