/*
 * Decompiled with CFR 0.152.
 */
package com.android.build.gradle.shrinker;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Set;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;

public class FilterMembersVisitor
extends ClassVisitor {
    private final Set<String> mMembers;
    private final Predicate<String> mClassKeptPredicate;

    public FilterMembersVisitor(Set<String> members, Predicate<String> classKeptPredicate, ClassVisitor cv) {
        super(327680, cv);
        this.mMembers = members;
        this.mClassKeptPredicate = classKeptPredicate;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        ArrayList interfacesToKeep = Lists.newArrayList();
        for (String iface : interfaces) {
            if (!this.mClassKeptPredicate.apply((Object)iface)) continue;
            interfacesToKeep.add(iface);
        }
        super.visit(version, access, name, signature, superName, (String[])Iterables.toArray((Iterable)interfacesToKeep, String.class));
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        if (this.mMembers.contains(name + ":" + desc)) {
            return super.visitField(access, name, desc, signature, value);
        }
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if (this.mMembers.contains(name + ":" + desc)) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        return null;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (this.mClassKeptPredicate.apply((Object)name)) {
            super.visitInnerClass(name, outerName, innerName, access);
        }
    }
}

