/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.annotations.concurrency.Immutable;
import com.android.manifmerger.ActionRecorder;
import com.android.manifmerger.Actions;
import com.android.manifmerger.ElementsTrimmer;
import com.android.manifmerger.KeyResolver;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.PlaceholderHandler;
import com.android.manifmerger.PositionImpl;
import com.android.manifmerger.PostValidator;
import com.android.manifmerger.PreValidator;
import com.android.manifmerger.ToolsInstructionsCleaner;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.utils.ILogger;
import com.android.utils.Pair;
import com.android.utils.SdkUtils;
import com.android.utils.StdLogger;
import com.android.utils.XmlUtils;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Immutable
public class ManifestMerger2 {
    private final File mMainManifestFile;
    private final ImmutableList<Pair<String, File>> mLibraryFiles;
    private final ImmutableList<File> mFlavorsAndBuildTypeFiles;
    private final ImmutableList<Invoker.Feature> mOptionalFeatures;
    private final PlaceholderHandler.KeyBasedValueResolver<String> mPlaceHolderValueResolver;
    private final PlaceholderHandler.KeyBasedValueResolver<SystemProperty> mSystemPropertyResolver;
    private final ILogger mLogger;

    private ManifestMerger2(@NonNull ILogger logger, @NonNull File mainManifestFile, @NonNull ImmutableList<Pair<String, File>> libraryFiles, @NonNull ImmutableList<File> flavorsAndBuildTypeFiles, @NonNull ImmutableList<Invoker.Feature> optionalFeatures, @NonNull PlaceholderHandler.KeyBasedValueResolver<String> placeHolderValueResolver, @NonNull PlaceholderHandler.KeyBasedValueResolver<SystemProperty> systemPropertiesResolver) {
        this.mLogger = logger;
        this.mMainManifestFile = mainManifestFile;
        this.mLibraryFiles = libraryFiles;
        this.mFlavorsAndBuildTypeFiles = flavorsAndBuildTypeFiles;
        this.mOptionalFeatures = optionalFeatures;
        this.mPlaceHolderValueResolver = placeHolderValueResolver;
        this.mSystemPropertyResolver = systemPropertiesResolver;
    }

    private MergingReport merge() throws MergeFailureException {
        XmlDocument cleanedDocument;
        MergingReport.Builder mergingReportBuilder = new MergingReport.Builder(this.mLogger);
        SelectorResolver selectors = new SelectorResolver();
        Optional<XmlDocument> xmlDocumentOptional = Optional.absent();
        for (File inputFile : this.mFlavorsAndBuildTypeFiles) {
            this.mLogger.info("Merging flavors and build manifest %s \n", new Object[]{inputFile.getPath()});
            if ((xmlDocumentOptional = this.merge(xmlDocumentOptional, (Pair<String, File>)Pair.of((Object)null, (Object)inputFile), selectors, mergingReportBuilder)).isPresent()) continue;
            return mergingReportBuilder.build();
        }
        List<XmlDocument> loadedLibraryDocuments = this.loadLibraries(selectors);
        this.mLogger.info("Merging main manifest %s\n", new Object[]{this.mMainManifestFile.getPath()});
        xmlDocumentOptional = this.merge(xmlDocumentOptional, (Pair<String, File>)Pair.of((Object)this.mMainManifestFile.getName(), (Object)this.mMainManifestFile), selectors, mergingReportBuilder);
        if (!xmlDocumentOptional.isPresent()) {
            return mergingReportBuilder.build();
        }
        for (XmlDocument libraryDocument : loadedLibraryDocuments) {
            this.mLogger.info("Merging library manifest " + libraryDocument.getSourceLocation(), new Object[0]);
            if ((xmlDocumentOptional = this.merge(xmlDocumentOptional, libraryDocument, mergingReportBuilder)).isPresent()) continue;
            return mergingReportBuilder.build();
        }
        ElementsTrimmer.trim((XmlDocument)xmlDocumentOptional.get(), mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        PlaceholderHandler placeholderHandler = new PlaceholderHandler();
        placeholderHandler.visit((XmlDocument)xmlDocumentOptional.get(), this.mPlaceHolderValueResolver, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            return mergingReportBuilder.build();
        }
        this.performSystemPropertiesInjection(mergingReportBuilder, (XmlDocument)xmlDocumentOptional.get());
        XmlDocument finalMergedDocument = (XmlDocument)xmlDocumentOptional.get();
        PostValidator.validate(finalMergedDocument, mergingReportBuilder);
        if (mergingReportBuilder.hasErrors()) {
            finalMergedDocument.getRootNode().addMessage(mergingReportBuilder, MergingReport.Record.Severity.WARNING, "Post merge validation failed");
        }
        if ((cleanedDocument = ToolsInstructionsCleaner.cleanToolsReferences(finalMergedDocument, this.mLogger)) != null) {
            mergingReportBuilder.setMergedDocument(cleanedDocument);
        }
        MergingReport build = mergingReportBuilder.build();
        StdLogger stdLogger = new StdLogger(StdLogger.Level.INFO);
        build.log((ILogger)stdLogger);
        stdLogger.verbose(((XmlDocument)build.getMergedDocument().get()).prettyPrint(), new Object[0]);
        return build;
    }

    private Optional<XmlDocument> merge(Optional<XmlDocument> xmlDocument, Pair<String, File> lowerPriorityXmlFile, KeyResolver<String> selectors, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        XmlDocument lowerPriorityDocument;
        try {
            lowerPriorityDocument = XmlLoader.load(selectors, this.mSystemPropertyResolver, (String)lowerPriorityXmlFile.getFirst(), (File)lowerPriorityXmlFile.getSecond());
        }
        catch (Exception e) {
            throw new MergeFailureException(e);
        }
        return this.merge(xmlDocument, lowerPriorityDocument, mergingReportBuilder);
    }

    private Optional<XmlDocument> merge(Optional<XmlDocument> xmlDocument, XmlDocument lowerPriorityDocument, MergingReport.Builder mergingReportBuilder) throws MergeFailureException {
        Optional result;
        MergingReport.Result validationResult = PreValidator.validate(mergingReportBuilder, lowerPriorityDocument);
        if (validationResult == MergingReport.Result.ERROR) {
            mergingReportBuilder.addMessage(lowerPriorityDocument.getSourceLocation(), 0, 0, MergingReport.Record.Severity.ERROR, "Validation failed, exiting");
            return Optional.absent();
        }
        if (xmlDocument.isPresent()) {
            result = ((XmlDocument)xmlDocument.get()).merge(lowerPriorityDocument, mergingReportBuilder);
        } else {
            mergingReportBuilder.getActionRecorder().recordDefaultNodeAction(lowerPriorityDocument.getRootNode());
            result = Optional.of((Object)lowerPriorityDocument);
        }
        if (this.mOptionalFeatures.contains((Object)Invoker.Feature.KEEP_INTERMEDIARY_STAGES) && result.isPresent()) {
            mergingReportBuilder.addMergingStage(((XmlDocument)result.get()).prettyPrint());
        }
        return result;
    }

    private List<XmlDocument> loadLibraries(SelectorResolver selectors) throws MergeFailureException {
        ImmutableList.Builder loadedLibraryDocuments = ImmutableList.builder();
        for (Pair libraryFile : this.mLibraryFiles) {
            XmlDocument libraryDocument;
            this.mLogger.info("Loading library manifest " + ((File)libraryFile.getSecond()).getPath(), new Object[0]);
            try {
                libraryDocument = XmlLoader.load((KeyResolver<String>)selectors, this.mSystemPropertyResolver, (String)libraryFile.getFirst(), (File)libraryFile.getSecond());
            }
            catch (Exception e) {
                throw new MergeFailureException(e);
            }
            String libraryPackage = libraryDocument.getRootNode().getXml().getAttribute("package");
            if (!Strings.isNullOrEmpty((String)libraryPackage)) {
                selectors.addSelector(libraryPackage, (String)libraryFile.getFirst());
            }
            loadedLibraryDocuments.add((Object)libraryDocument);
        }
        return loadedLibraryDocuments.build();
    }

    private void performSystemPropertiesInjection(MergingReport.Builder mergingReport, XmlDocument xmlDocument) {
        for (SystemProperty systemProperty : SystemProperty.values()) {
            String propertyOverride = this.mSystemPropertyResolver.getValue(systemProperty);
            if (propertyOverride == null) continue;
            systemProperty.addTo(mergingReport.getActionRecorder(), xmlDocument, propertyOverride);
        }
    }

    public static Invoker newInvoker(@NonNull File mainManifestFile, @NonNull ILogger logger) {
        return new Invoker(mainManifestFile, logger);
    }

    public static class MapBasedKeyBasedValueResolver<T>
    implements PlaceholderHandler.KeyBasedValueResolver<T> {
        private final ImmutableMap<T, String> keyValues;

        public MapBasedKeyBasedValueResolver(Map<T, String> keyValues) {
            this.keyValues = ImmutableMap.copyOf(keyValues);
        }

        @Override
        @Nullable
        public String getValue(@NonNull T key) {
            return (String)this.keyValues.get(key);
        }
    }

    public static final class Invoker {
        private final File mMainManifestFile;
        private final ImmutableList.Builder<Pair<String, File>> mLibraryFilesBuilder = new ImmutableList.Builder();
        private final ImmutableList.Builder<File> mFlavorsAndBuildTypeFiles = new ImmutableList.Builder();
        private final ImmutableList.Builder<Feature> mFeaturesBuilder = new ImmutableList.Builder();
        private final ImmutableMap.Builder<SystemProperty, String> mSystemProperties = new ImmutableMap.Builder();
        private final ImmutableMap.Builder<String, String> mPlaceHolders = new ImmutableMap.Builder();
        private final ILogger mLogger;

        private Invoker(@NonNull File mainManifestFile, @NonNull ILogger logger) {
            this.mMainManifestFile = (File)Preconditions.checkNotNull((Object)mainManifestFile);
            this.mLogger = logger;
        }

        public Invoker addLibraryManifest(File file) {
            this.mLibraryFilesBuilder.add((Object)Pair.of((Object)file.getName(), (Object)file));
            return this;
        }

        public Invoker addLibraryManifests(List<Pair<String, File>> namesAndFiles) {
            this.mLibraryFilesBuilder.addAll(namesAndFiles);
            return this;
        }

        public Invoker addLibraryManifests(File ... files) {
            for (File file : files) {
                this.addLibraryManifest(file);
            }
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifest(File file) {
            this.mFlavorsAndBuildTypeFiles.add((Object)file);
            return this;
        }

        public Invoker addFlavorAndBuildTypeManifests(File ... files) {
            this.mFlavorsAndBuildTypeFiles.add((Object[])files);
            return this;
        }

        public Invoker withFeatures(Feature ... features) {
            this.mFeaturesBuilder.add((Object[])features);
            return this;
        }

        public Invoker setPlaceHolderValue(String placeHolderName, String value) {
            this.mPlaceHolders.put((Object)placeHolderName, (Object)value);
            return this;
        }

        public Invoker setOverride(SystemProperty override, String value) {
            this.mSystemProperties.put((Object)override, (Object)value);
            return this;
        }

        public MergingReport merge() throws MergeFailureException {
            ImmutableMap systemProperties = this.mSystemProperties.build();
            if (systemProperties.containsKey((Object)SystemProperty.PACKAGE)) {
                this.mPlaceHolders.put((Object)"packageName", systemProperties.get((Object)SystemProperty.PACKAGE));
            }
            ManifestMerger2 manifestMerger = new ManifestMerger2(this.mLogger, this.mMainManifestFile, this.mLibraryFilesBuilder.build(), this.mFlavorsAndBuildTypeFiles.build(), this.mFeaturesBuilder.build(), new MapBasedKeyBasedValueResolver(this.mPlaceHolders.build()), new MapBasedKeyBasedValueResolver(systemProperties));
            return manifestMerger.merge();
        }

        public static enum Feature {
            KEEP_INTERMEDIARY_STAGES,
            PRINT_SIMPLE_FILENAMES;

        }
    }

    public static class MergeFailureException
    extends Exception {
        private MergeFailureException(Exception cause) {
            super(cause);
        }
    }

    public static enum SystemProperty implements AutoAddingProperty
    {
        PACKAGE{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElement((SystemProperty)this, actionRecorder, value, document.getRootNode());
            }
        }
        ,
        VERSION_CODE{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, document.getRootNode());
            }
        }
        ,
        VERSION_NAME{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, document.getRootNode());
            }
        }
        ,
        MIN_SDK_VERSION{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, SystemProperty.createOrGetUseSdk(actionRecorder, document));
            }
        }
        ,
        TARGET_SDK_VERSION{

            @Override
            public void addTo(@NonNull ActionRecorder actionRecorder, @NonNull XmlDocument document, @NonNull String value) {
                SystemProperty.addToElementInAndroidNS((SystemProperty)this, actionRecorder, value, SystemProperty.createOrGetUseSdk(actionRecorder, document));
            }
        };


        public String toCamelCase() {
            return SdkUtils.constantNameToCamelCase((String)this.name());
        }

        private static void addToElement(SystemProperty systemProperty, ActionRecorder actionRecorder, String value, XmlElement to) {
            to.getXml().setAttribute(systemProperty.toCamelCase(), value);
            XmlAttribute xmlAttribute = new XmlAttribute(to, to.getXml().getAttributeNode(systemProperty.toCamelCase()), null);
            actionRecorder.recordAttributeAction(xmlAttribute, new Actions.AttributeRecord(Actions.ActionType.INJECTED, new Actions.ActionLocation(to.getSourceLocation(), PositionImpl.UNKNOWN), xmlAttribute.getId(), null, null));
        }

        private static void addToElementInAndroidNS(SystemProperty systemProperty, ActionRecorder actionRecorder, String value, XmlElement to) {
            String toolsPrefix = XmlUtils.lookupNamespacePrefix((Node)to.getXml(), (String)"http://schemas.android.com/apk/res/android", (String)"android", (boolean)false);
            to.getXml().setAttributeNS("http://schemas.android.com/apk/res/android", toolsPrefix + ':' + systemProperty.toCamelCase(), value);
            Attr attr = to.getXml().getAttributeNodeNS("http://schemas.android.com/apk/res/android", systemProperty.toCamelCase());
            XmlAttribute xmlAttribute = new XmlAttribute(to, attr, null);
            actionRecorder.recordAttributeAction(xmlAttribute, new Actions.AttributeRecord(Actions.ActionType.INJECTED, new Actions.ActionLocation(to.getSourceLocation(), PositionImpl.UNKNOWN), xmlAttribute.getId(), null, null));
        }

        private static XmlElement createOrGetUseSdk(ActionRecorder actionRecorder, XmlDocument document) {
            Element manifest = document.getXml().getDocumentElement();
            NodeList usesSdks = manifest.getElementsByTagName(ManifestModel.NodeTypes.USES_SDK.toXmlName());
            if (usesSdks.getLength() == 0) {
                Element useSdk = manifest.getOwnerDocument().createElement(ManifestModel.NodeTypes.USES_SDK.toXmlName());
                manifest.appendChild(useSdk);
                XmlElement xmlElement = new XmlElement(useSdk, document);
                Actions.NodeRecord nodeRecord = new Actions.NodeRecord(Actions.ActionType.INJECTED, new Actions.ActionLocation(xmlElement.getSourceLocation(), PositionImpl.UNKNOWN), xmlElement.getId(), "use-sdk injection requested", NodeOperationType.STRICT);
                actionRecorder.recordNodeAction(xmlElement, nodeRecord);
                return xmlElement;
            }
            return new XmlElement((Element)usesSdks.item(0), document);
        }
    }

    private static class SelectorResolver
    implements KeyResolver<String> {
        private final Map<String, String> mSelectors = new HashMap<String, String>();

        private SelectorResolver() {
        }

        private void addSelector(String key, String value) {
            this.mSelectors.put(key, value);
        }

        @Override
        @Nullable
        public String resolve(String key) {
            return this.mSelectors.get(key);
        }

        @Override
        public Iterable<String> getKeys() {
            return this.mSelectors.keySet();
        }
    }

    public static interface AutoAddingProperty {
        public void addTo(@NonNull ActionRecorder var1, @NonNull XmlDocument var2, @NonNull String var3);
    }
}

