/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.ManifestModel;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.NodeOperationType;
import com.android.manifmerger.XmlAttribute;
import com.android.manifmerger.XmlDocument;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlNode;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Node;

public class PostValidator {
    public static void validate(@NonNull XmlDocument xmlDocument, @NonNull MergingReport.Builder mergingReport) {
        Preconditions.checkNotNull((Object)xmlDocument);
        Preconditions.checkNotNull((Object)mergingReport);
        PostValidator.reOrderElements(xmlDocument.getRootNode());
        PostValidator.validate(xmlDocument.getRootNode(), mergingReport.getActionRecorder().build(), mergingReport);
    }

    private static void reOrderElements(XmlElement xmlElement) {
        Optional<XmlElement> element = xmlElement.getNodeByTypeAndKey(ManifestModel.NodeTypes.APPLICATION, null);
        if (!element.isPresent()) {
            return;
        }
        XmlElement applicationElement = (XmlElement)element.get();
        List<Node> comments = XmlElement.getLeadingComments(applicationElement.getXml());
        for (Node comment : comments) {
            xmlElement.getXml().removeChild(comment);
            xmlElement.getXml().appendChild(comment);
        }
        xmlElement.getXml().removeChild(applicationElement.getXml());
        xmlElement.getXml().appendChild(applicationElement.getXml());
    }

    private static void validate(XmlElement xmlElement, Actions actions, MergingReport.Builder mergingReport) {
        NodeOperationType operationType = xmlElement.getOperationType();
        switch (operationType) {
            case REPLACE: {
                if (PostValidator.isNodeOperationPresent(xmlElement, actions, Actions.ActionType.REJECTED)) break;
                xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.WARNING, String.format("%1$s was tagged at %2$s:%3$d to replace another declaration but no other declaration present", xmlElement.getId(), xmlElement.getDocument().getSourceLocation().print(true), xmlElement.getPosition().getLine()));
                break;
            }
            case REMOVE: 
            case REMOVE_ALL: {
                if (PostValidator.isNodeOperationPresent(xmlElement, actions, Actions.ActionType.REJECTED)) break;
                xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.WARNING, String.format("%1$s was tagged at %2$s:%3$d to remove other declarations but no other declaration present", xmlElement.getId(), xmlElement.getDocument().getSourceLocation().print(true), xmlElement.getPosition().getLine()));
            }
        }
        PostValidator.validateAttributes(xmlElement, actions, mergingReport);
        PostValidator.validateAndroidAttributes(xmlElement, mergingReport);
        for (XmlElement child : xmlElement.getMergeableElements()) {
            PostValidator.validate(child, actions, mergingReport);
        }
    }

    private static void validateAttributes(XmlElement xmlElement, Actions actions, MergingReport.Builder mergingReport) {
        Collection<Map.Entry<XmlNode.NodeName, AttributeOperationType>> attributeOperations = xmlElement.getAttributeOperations();
        for (Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation : attributeOperations) {
            switch (attributeOperation.getValue()) {
                case REMOVE: {
                    if (PostValidator.isAttributeOperationPresent(xmlElement, attributeOperation, actions, Actions.ActionType.REJECTED)) break;
                    xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.WARNING, String.format("%1$s@%2$s was tagged at %3$s:%4$d to remove other declarations but no other declaration present", xmlElement.getId(), attributeOperation.getKey(), xmlElement.getDocument().getSourceLocation().print(true), xmlElement.getPosition().getLine()));
                    break;
                }
                case REPLACE: {
                    if (PostValidator.isAttributeOperationPresent(xmlElement, attributeOperation, actions, Actions.ActionType.REJECTED)) break;
                    xmlElement.addMessage(mergingReport, MergingReport.Record.Severity.WARNING, String.format("%1$s@%2$s was tagged at %3$s:%4$d to replace other declarations but no other declaration present", xmlElement.getId(), attributeOperation.getKey(), xmlElement.getDocument().getSourceLocation().print(true), xmlElement.getPosition().getLine()));
                }
            }
        }
    }

    private static boolean isNodeOperationPresent(XmlElement xmlElement, Actions actions, Actions.ActionType action) {
        for (Actions.NodeRecord nodeRecord : actions.getNodeRecords(xmlElement.getId())) {
            if (nodeRecord.getActionType() != action) continue;
            return true;
        }
        return false;
    }

    private static boolean isAttributeOperationPresent(XmlElement xmlElement, Map.Entry<XmlNode.NodeName, AttributeOperationType> attributeOperation, Actions actions, Actions.ActionType action) {
        for (Actions.AttributeRecord attributeRecord : actions.getAttributeRecords(xmlElement.getId(), attributeOperation.getKey())) {
            if (attributeRecord.getActionType() != action) continue;
            return true;
        }
        return false;
    }

    private static void validateAndroidAttributes(XmlElement xmlElement, MergingReport.Builder mergingReport) {
        for (XmlAttribute xmlAttribute : xmlElement.getAttributes()) {
            AttributeModel.Validator onWriteValidator;
            if (xmlAttribute.getModel() == null || (onWriteValidator = xmlAttribute.getModel().getOnWriteValidator()) == null) continue;
            onWriteValidator.validates(mergingReport, xmlAttribute, xmlAttribute.getValue());
        }
    }
}

