/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.manifmerger.Actions;
import com.android.manifmerger.AttributeModel;
import com.android.manifmerger.AttributeOperationType;
import com.android.manifmerger.MergingReport;
import com.android.manifmerger.XmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.manifmerger.XmlNode;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import org.w3c.dom.Attr;

public class XmlAttribute
extends XmlNode {
    private final XmlElement mOwnerElement;
    private final Attr mXml;
    @Nullable
    private final AttributeModel mAttributeModel;

    public XmlAttribute(@NonNull XmlElement ownerElement, @NonNull Attr xml, @Nullable AttributeModel attributeModel) {
        this.mOwnerElement = (XmlElement)Preconditions.checkNotNull((Object)ownerElement);
        this.mXml = (Attr)Preconditions.checkNotNull((Object)xml);
        this.mAttributeModel = attributeModel;
        if (this.mAttributeModel != null && this.mAttributeModel.isPackageDependent()) {
            String value = this.mXml.getValue();
            String pkg = this.mOwnerElement.getDocument().getPackageName();
            if (!(value == null || value.isEmpty() || value.indexOf(46) != -1 && value.charAt(0) != '.')) {
                value = value.charAt(0) == '.' ? pkg + value : pkg + '.' + value;
                this.mXml.setValue(value);
            }
        }
    }

    @Override
    public XmlNode.NodeName getName() {
        return XmlNode.unwrapName(this.mXml);
    }

    public String getValue() {
        return this.mXml.getValue();
    }

    @Override
    public XmlNode.NodeKey getId() {
        return new XmlNode.NodeKey(this.mOwnerElement.getId() + "@" + this.mXml.getLocalName());
    }

    @Override
    @NonNull
    public PositionXmlParser.Position getPosition() {
        return this.mOwnerElement.getDocument().getNodePosition(this);
    }

    @Override
    @NonNull
    public Attr getXml() {
        return this.mXml;
    }

    @Nullable
    public AttributeModel getModel() {
        return this.mAttributeModel;
    }

    XmlElement getOwnerElement() {
        return this.mOwnerElement;
    }

    void mergeInHigherPriorityElement(XmlElement higherPriorityElement, MergingReport.Builder mergingReport) {
        Optional<XmlAttribute> higherPriorityAttributeOptional = higherPriorityElement.getAttribute(this.getName());
        AttributeOperationType attributeOperationType = higherPriorityElement.getAttributeOperationType(this.getName());
        if (higherPriorityAttributeOptional.isPresent()) {
            XmlAttribute higherPriorityAttribute = (XmlAttribute)higherPriorityAttributeOptional.get();
            this.handleBothAttributePresent(mergingReport, higherPriorityAttribute, attributeOperationType);
            return;
        }
        if (attributeOperationType == AttributeOperationType.REMOVE) {
            mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.REJECTED, AttributeOperationType.REMOVE);
            return;
        }
        String mergedValue = this.mergeThisAndDefaultValue(mergingReport, higherPriorityElement);
        if (mergedValue == null) {
            return;
        }
        this.getName().addToNode(higherPriorityElement.getXml(), mergedValue);
        mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.ADDED, this.getOwnerElement().getAttributeOperationType(this.getName()));
    }

    private void handleBothAttributePresent(MergingReport.Builder report, XmlAttribute higherPriority, AttributeOperationType operationType) {
        if (operationType == AttributeOperationType.REPLACE) {
            report.getActionRecorder().recordAttributeAction(this, Actions.ActionType.REJECTED, AttributeOperationType.REPLACE);
            return;
        }
        if (this.mAttributeModel != null) {
            String mergedValue = this.mAttributeModel.getMergingPolicy().merge(higherPriority.getValue(), this.getValue());
            if (mergedValue != null) {
                higherPriority.mXml.setValue(mergedValue);
            } else {
                this.addConflictingValueMessage(report, higherPriority);
            }
            return;
        }
        if (!this.getValue().equals(higherPriority.getValue())) {
            this.addConflictingValueMessage(report, higherPriority);
        }
    }

    private String mergeThisAndDefaultValue(MergingReport.Builder mergingReport, XmlElement implicitNode) {
        String mergedValue = this.getValue();
        if (this.mAttributeModel == null || this.mAttributeModel.getDefaultValue() == null || !this.mAttributeModel.getMergingPolicy().shouldMergeDefaultValues()) {
            return mergedValue;
        }
        String defaultValue = this.mAttributeModel.getDefaultValue();
        if (defaultValue.equals(mergedValue)) {
            return mergedValue;
        }
        mergedValue = this.mAttributeModel.getMergingPolicy().merge(defaultValue, mergedValue);
        if (mergedValue == null) {
            this.addIllegalImplicitOverrideMessage(mergingReport, this.mAttributeModel, implicitNode);
            return null;
        }
        if (mergedValue.equals(defaultValue)) {
            return null;
        }
        return mergedValue;
    }

    void mergeWithLowerPriorityDefaultValue(MergingReport.Builder mergingReport, XmlElement implicitNode) {
        if (this.mAttributeModel == null || this.mAttributeModel.getDefaultValue() == null || !this.mAttributeModel.getMergingPolicy().shouldMergeDefaultValues()) {
            return;
        }
        if (this.mOwnerElement.getAttributeOperationType(this.getName()) == AttributeOperationType.REPLACE) {
            mergingReport.getActionRecorder().recordImplicitRejection(this, implicitNode);
            return;
        }
        String mergedValue = this.mAttributeModel.getMergingPolicy().merge(this.getValue(), this.mAttributeModel.getDefaultValue());
        if (mergedValue == null) {
            this.addIllegalImplicitOverrideMessage(mergingReport, this.mAttributeModel, implicitNode);
        } else {
            this.getXml().setValue(mergedValue);
            mergingReport.getActionRecorder().recordAttributeAction(this, Actions.ActionType.MERGED, null);
        }
    }

    private void addIllegalImplicitOverrideMessage(@NonNull MergingReport.Builder mergingReport, @NonNull AttributeModel attributeModel, @NonNull XmlElement implicitNode) {
        String error = String.format("Attribute %1$s value=(%2$s) at %3$s cannot override implicit default value=(%4$s) at %5$s", this.getId(), this.getValue(), this.printPosition(), attributeModel.getDefaultValue(), implicitNode.printPosition());
        this.addMessage(mergingReport, MergingReport.Record.Severity.ERROR, error);
    }

    private void addConflictingValueMessage(MergingReport.Builder report, XmlAttribute higherPriority) {
        Actions.AttributeRecord attributeRecord = report.getActionRecorder().getAttributeCreationRecord(higherPriority);
        String error = String.format("Attribute %1$s value=(%2$s) from %3$s\n\tis also present at %4$s value=(%5$s)\n\tSuggestion: add 'tools:replace=\"%6$s\"' to <%7$s> element at %8$s to override", higherPriority.getId(), higherPriority.getValue(), attributeRecord != null ? attributeRecord.getActionLocation().toString() : "(unknown)", this.printPosition(), this.getValue(), this.mXml.getLocalName(), this.getOwnerElement().getType().toXmlName(), higherPriority.getOwnerElement().printPosition(true));
        higherPriority.addMessage(report, MergingReport.Record.Severity.ERROR, error);
    }

    void addMessage(MergingReport.Builder report, MergingReport.Record.Severity severity, String message) {
        report.addMessage(this.getOwnerElement().getDocument().getSourceLocation(), this.getLine(), this.getColumn(), severity, message);
    }

    @Override
    @NonNull
    public XmlLoader.SourceLocation getSourceLocation() {
        return this.getOwnerElement().getSourceLocation();
    }
}

