/*
 * Decompiled with CFR 0.152.
 */
package com.android.manifmerger;

import com.android.annotations.NonNull;
import com.android.annotations.concurrency.Immutable;
import com.android.manifmerger.OrphanXmlElement;
import com.android.manifmerger.XmlLoader;
import com.android.utils.PositionXmlParser;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class XmlNode {
    private static final String UNKNOWN_POSITION = "Unknown position";
    protected static final Function<Node, String> NODE_TO_NAME = new Function<Node, String>(){

        public String apply(Node input) {
            return input.getNodeName();
        }
    };

    public abstract NodeKey getId();

    public abstract PositionXmlParser.Position getPosition();

    @NonNull
    public abstract XmlLoader.SourceLocation getSourceLocation();

    @NonNull
    public abstract Node getXml();

    public abstract NodeName getName();

    public static NodeName unwrapName(Node node) {
        return node.getNamespaceURI() == null ? new Name(node.getNodeName()) : new NamespaceAwareName(node);
    }

    public static NodeName fromXmlName(String name) {
        return name.contains(":") ? new NamespaceAwareName("http://schemas.android.com/apk/res/android", name.substring(0, name.indexOf(58)), name.substring(name.indexOf(58) + 1)) : new Name(name);
    }

    public static NodeName fromNSName(String namespaceUri, String prefix, String localName) {
        return new NamespaceAwareName(namespaceUri, prefix, localName);
    }

    public int getLine() {
        PositionXmlParser.Position position = this.getPosition();
        return position != null ? position.getLine() : 0;
    }

    public int getColumn() {
        PositionXmlParser.Position position = this.getPosition();
        return position != null ? position.getColumn() : 0;
    }

    public String printPosition() {
        return this.printPosition(true);
    }

    public String printPosition(boolean shortFormat) {
        PositionXmlParser.Position position = this.getPosition();
        if (position == null) {
            return UNKNOWN_POSITION;
        }
        return (this.getSourceLocation() != null ? this.getSourceLocation().print(shortFormat) : "Unknown location") + ":" + position.getLine() + ":" + position.getColumn();
    }

    @Immutable
    public static class NodeKey {
        @NonNull
        private final String mKey;

        NodeKey(@NonNull String key) {
            this.mKey = key;
        }

        public static NodeKey fromXml(Element element) {
            return new OrphanXmlElement(element).getId();
        }

        public String toString() {
            return this.mKey;
        }

        public boolean equals(Object o) {
            return o != null && o instanceof NodeKey && ((NodeKey)o).mKey.equals(this.mKey);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mKey});
        }
    }

    private static final class NamespaceAwareName
    implements NodeName {
        private final String mNamespaceURI;
        private final String mPrefix;
        private final String mLocalName;

        private NamespaceAwareName(@NonNull Node node) {
            this.mNamespaceURI = (String)Preconditions.checkNotNull((Object)node.getNamespaceURI());
            this.mPrefix = (String)Preconditions.checkNotNull((Object)node.getPrefix());
            this.mLocalName = (String)Preconditions.checkNotNull((Object)node.getLocalName());
        }

        private NamespaceAwareName(@NonNull String namespaceURI, @NonNull String prefix, @NonNull String localName) {
            this.mNamespaceURI = (String)Preconditions.checkNotNull((Object)namespaceURI);
            this.mPrefix = (String)Preconditions.checkNotNull((Object)prefix);
            this.mLocalName = (String)Preconditions.checkNotNull((Object)localName);
        }

        @Override
        public boolean isInNamespace(String namespaceURI) {
            return this.mNamespaceURI.equals(namespaceURI);
        }

        @Override
        public void addToNode(Element to, String withValue) {
            to.setAttributeNS(this.mNamespaceURI, this.mPrefix + ":" + this.mLocalName, withValue);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mNamespaceURI, this.mLocalName});
        }

        public boolean equals(Object o) {
            return o != null && o instanceof NamespaceAwareName && ((NamespaceAwareName)o).mLocalName.equals(this.mLocalName) && ((NamespaceAwareName)o).mNamespaceURI.equals(this.mNamespaceURI);
        }

        public String toString() {
            return this.mPrefix + ":" + this.mLocalName;
        }

        @Override
        public void persistTo(Element node) {
            node.setAttribute("prefix", this.mPrefix);
            node.setAttribute("local-name", this.mLocalName);
            node.setAttribute("namespace-uri", this.mNamespaceURI);
        }
    }

    private static final class Name
    implements NodeName {
        private final String mName;

        private Name(@NonNull String name) {
            this.mName = (String)Preconditions.checkNotNull((Object)name);
        }

        @Override
        public boolean isInNamespace(String namespaceURI) {
            return false;
        }

        @Override
        public void addToNode(Element to, String withValue) {
            to.setAttribute(this.mName, withValue);
        }

        public boolean equals(Object o) {
            return o != null && o instanceof Name && ((Name)o).mName.equals(this.mName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.mName});
        }

        public String toString() {
            return this.mName;
        }

        @Override
        public void persistTo(Element node) {
            node.setAttribute("name", this.mName);
        }
    }

    public static interface NodeName {
        public boolean isInNamespace(String var1);

        public void addToNode(Element var1, String var2);

        public void persistTo(Element var1);
    }
}

