/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.google.common.annotations.Beta;
import java.util.EnumSet;

@Beta
public enum Scope {
    RESOURCE_FILE,
    ALL_RESOURCE_FILES,
    JAVA_FILE,
    ALL_JAVA_FILES,
    CLASS_FILE,
    ALL_CLASS_FILES,
    MANIFEST,
    PROGUARD_FILE,
    JAVA_LIBRARIES,
    OTHER;

    public static final EnumSet<Scope> ALL;
    public static final EnumSet<Scope> RESOURCE_FILE_SCOPE;
    public static final EnumSet<Scope> ALL_RESOURCES_SCOPE;
    public static final EnumSet<Scope> JAVA_FILE_SCOPE;
    public static final EnumSet<Scope> CLASS_FILE_SCOPE;
    public static final EnumSet<Scope> MANIFEST_SCOPE;
    public static final EnumSet<Scope> OTHER_SCOPE;
    public static final EnumSet<Scope> PROGUARD_SCOPE;
    public static final EnumSet<Scope> JAVA_AND_RESOURCE_FILES;
    public static final EnumSet<Scope> CLASS_AND_ALL_RESOURCE_FILES;
    public static final EnumSet<Scope> JAVA_LIBRARY_SCOPE;

    public static boolean checkSingleFile(@NonNull EnumSet<Scope> scopes) {
        int size = scopes.size();
        if (size == 2) {
            return scopes.contains((Object)JAVA_FILE) && scopes.contains((Object)CLASS_FILE);
        }
        return size == 1 && (scopes.contains((Object)JAVA_FILE) || scopes.contains((Object)CLASS_FILE) || scopes.contains((Object)RESOURCE_FILE) || scopes.contains((Object)PROGUARD_FILE) || scopes.contains((Object)MANIFEST));
    }

    @NonNull
    public static EnumSet<Scope> intersect(@NonNull EnumSet<Scope> scope1, @NonNull EnumSet<Scope> scope2) {
        EnumSet<Scope> scope = EnumSet.copyOf(scope1);
        scope.retainAll(scope2);
        return scope;
    }

    static {
        ALL = EnumSet.allOf(Scope.class);
        RESOURCE_FILE_SCOPE = EnumSet.of(RESOURCE_FILE);
        ALL_RESOURCES_SCOPE = EnumSet.of(ALL_RESOURCE_FILES);
        JAVA_FILE_SCOPE = EnumSet.of(JAVA_FILE);
        CLASS_FILE_SCOPE = EnumSet.of(CLASS_FILE);
        MANIFEST_SCOPE = EnumSet.of(MANIFEST);
        OTHER_SCOPE = EnumSet.of(OTHER);
        PROGUARD_SCOPE = EnumSet.of(PROGUARD_FILE);
        JAVA_AND_RESOURCE_FILES = EnumSet.of(RESOURCE_FILE, JAVA_FILE);
        CLASS_AND_ALL_RESOURCE_FILES = EnumSet.of(ALL_RESOURCE_FILES, CLASS_FILE);
        JAVA_LIBRARY_SCOPE = EnumSet.of(JAVA_LIBRARIES);
    }
}

