/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.client.api.Configuration;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.client.api.SdkInfo;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import com.google.common.base.Splitter;
import java.io.File;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Beta
public class Context {
    public final File file;
    protected final LintDriver mDriver;
    @NonNull
    private final Project mProject;
    private final Project mMainProject;
    private final Configuration mConfiguration;
    private String mContents;
    private Map<String, Object> mProperties;
    private Boolean mContainsCommentSuppress;
    private static final Pattern VERSION_PATTERN = Pattern.compile("^v(\\d+)$");
    private static File sCachedFolder = null;
    private static int sCachedFolderVersion = -1;

    public Context(@NonNull LintDriver driver, @NonNull Project project, @Nullable Project main, @NonNull File file) {
        this.file = file;
        this.mDriver = driver;
        this.mProject = project;
        this.mMainProject = main;
        this.mConfiguration = project.getConfiguration();
    }

    @NonNull
    public EnumSet<Scope> getScope() {
        return this.mDriver.getScope();
    }

    @NonNull
    public Configuration getConfiguration() {
        return this.mConfiguration;
    }

    @NonNull
    public Project getProject() {
        return this.mProject;
    }

    @NonNull
    public Project getMainProject() {
        return this.mMainProject != null ? this.mMainProject : this.mProject;
    }

    @NonNull
    public LintClient getClient() {
        return this.mDriver.getClient();
    }

    @NonNull
    public LintDriver getDriver() {
        return this.mDriver;
    }

    @Nullable
    public String getContents() {
        if (this.mContents == null) {
            this.mContents = this.mDriver.getClient().readFile(this.file);
        }
        return this.mContents;
    }

    @Nullable
    public Object getProperty(String name) {
        if (this.mProperties == null) {
            return null;
        }
        return this.mProperties.get(name);
    }

    public void setProperty(@NonNull String name, @Nullable Object value) {
        if (value == null) {
            if (this.mProperties != null) {
                this.mProperties.remove(name);
            }
        } else {
            if (this.mProperties == null) {
                this.mProperties = new HashMap<String, Object>();
            }
            this.mProperties.put(name, value);
        }
    }

    @NonNull
    public SdkInfo getSdkInfo() {
        return this.mProject.getSdkInfo();
    }

    public boolean isEnabled(@NonNull Issue issue) {
        return this.mConfiguration.isEnabled(issue);
    }

    public void report(@NonNull Issue issue, @Nullable Location location, @NonNull String message, @Nullable Object data) {
        Project project;
        Configuration configuration = this.mConfiguration;
        if (location != null && location.getFile() != null && (project = this.mDriver.findProjectFor(location.getFile())) != null) {
            configuration = project.getConfiguration();
        }
        if (configuration != this.mConfiguration && this.mConfiguration.getSeverity(issue) == Severity.IGNORE) {
            return;
        }
        Severity severity = configuration.getSeverity(issue);
        if (severity == Severity.IGNORE) {
            return;
        }
        this.mDriver.getClient().report(this, issue, severity, location, message, data);
    }

    public void log(@Nullable Throwable exception, @Nullable String format, Object ... args) {
        this.mDriver.getClient().log(exception, format, args);
    }

    public int getPhase() {
        return this.mDriver.getPhase();
    }

    public void requestRepeat(@NonNull Detector detector, @Nullable EnumSet<Scope> scope) {
        this.mDriver.requestRepeat(detector, scope);
    }

    public int getFolderVersion() {
        return Context.getFolderVersion(this.file);
    }

    public static int getFolderVersion(File file) {
        File parent = file.getParentFile();
        if (parent.equals(sCachedFolder)) {
            return sCachedFolderVersion;
        }
        sCachedFolder = parent;
        sCachedFolderVersion = -1;
        for (String qualifier : Splitter.on((char)'-').split((CharSequence)parent.getName())) {
            Matcher matcher = VERSION_PATTERN.matcher(qualifier);
            if (!matcher.matches()) continue;
            sCachedFolderVersion = Integer.parseInt(matcher.group(1));
            break;
        }
        return sCachedFolderVersion;
    }

    @Nullable
    protected String getSuppressCommentPrefix() {
        String path = this.file.getPath();
        if (path.endsWith(".java") || path.endsWith(".gradle")) {
            return "//noinspection ";
        }
        if (path.endsWith(".xml")) {
            return "<!--suppress ";
        }
        if (path.endsWith(".cfg") || path.endsWith(".pro")) {
            return "#suppress ";
        }
        return null;
    }

    public boolean containsCommentSuppress() {
        if (this.mContainsCommentSuppress == null) {
            String contents;
            this.mContainsCommentSuppress = false;
            String prefix = this.getSuppressCommentPrefix();
            if (prefix != null && (contents = this.getContents()) != null) {
                this.mContainsCommentSuppress = contents.contains(prefix);
            }
        }
        return this.mContainsCommentSuppress;
    }

    public boolean isSuppressedWithComment(int startOffset, @NonNull Issue issue) {
        String prefix = this.getSuppressCommentPrefix();
        if (prefix == null) {
            return false;
        }
        if (startOffset == -1) {
            return false;
        }
        String contents = this.getContents();
        assert (contents != null);
        if (startOffset >= contents.length()) {
            return false;
        }
        int lineStart = contents.lastIndexOf(10, startOffset) + 1;
        if (lineStart <= 1) {
            return false;
        }
        int prevLineStart = contents.lastIndexOf(10, lineStart - 2) + 1;
        if (prevLineStart == 0) {
            return false;
        }
        int index = Context.findPrefixOnPreviousLine(contents, lineStart, prefix);
        if (index != -1 && index + prefix.length() < lineStart) {
            String line = contents.substring(index + prefix.length(), lineStart);
            return line.contains(issue.getId()) || line.contains("all") && line.trim().startsWith("all");
        }
        return false;
    }

    private static int findPrefixOnPreviousLine(String contents, int lineStart, String prefix) {
        char first = prefix.charAt(0);
        boolean seenNonWhitespace = false;
        for (int offset = lineStart - 2; offset >= 0; --offset) {
            char c = contents.charAt(offset);
            if (seenNonWhitespace && c == '\n') {
                return -1;
            }
            if (!seenNonWhitespace && !Character.isWhitespace(c)) {
                seenNonWhitespace = true;
            }
            if (c != first || !contents.regionMatches(false, offset, prefix, 0, prefix.length())) continue;
            return offset;
        }
        return -1;
    }
}

