/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Project;
import com.google.common.annotations.Beta;
import java.io.File;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;

@Beta
public enum Scope {
    RESOURCE_FILE,
    ALL_RESOURCE_FILES,
    JAVA_FILE,
    ALL_JAVA_FILES,
    CLASS_FILE,
    ALL_CLASS_FILES,
    MANIFEST,
    PROGUARD_FILE,
    JAVA_LIBRARIES,
    GRADLE_FILE,
    OTHER;

    public static final EnumSet<Scope> ALL;
    public static final EnumSet<Scope> RESOURCE_FILE_SCOPE;
    public static final EnumSet<Scope> ALL_RESOURCES_SCOPE;
    public static final EnumSet<Scope> JAVA_FILE_SCOPE;
    public static final EnumSet<Scope> CLASS_FILE_SCOPE;
    public static final EnumSet<Scope> GRADLE_SCOPE;
    public static final EnumSet<Scope> MANIFEST_SCOPE;
    public static final EnumSet<Scope> OTHER_SCOPE;
    public static final EnumSet<Scope> PROGUARD_SCOPE;
    public static final EnumSet<Scope> JAVA_AND_RESOURCE_FILES;
    public static final EnumSet<Scope> CLASS_AND_ALL_RESOURCE_FILES;
    public static final EnumSet<Scope> ALL_CLASSES_AND_LIBRARIES;
    public static final EnumSet<Scope> JAVA_LIBRARY_SCOPE;

    public static boolean checkSingleFile(@NonNull EnumSet<Scope> scopes) {
        int size = scopes.size();
        if (size == 2) {
            return scopes.contains((Object)JAVA_FILE) && scopes.contains((Object)CLASS_FILE);
        }
        return size == 1 && (scopes.contains((Object)JAVA_FILE) || scopes.contains((Object)CLASS_FILE) || scopes.contains((Object)RESOURCE_FILE) || scopes.contains((Object)PROGUARD_FILE) || scopes.contains((Object)MANIFEST));
    }

    @NonNull
    public static EnumSet<Scope> intersect(@NonNull EnumSet<Scope> scope1, @NonNull EnumSet<Scope> scope2) {
        EnumSet<Scope> scope = EnumSet.copyOf(scope1);
        scope.retainAll(scope2);
        return scope;
    }

    @NonNull
    public static EnumSet<Scope> infer(@NonNull Collection<Project> projects) {
        EnumSet<Scope> scope = EnumSet.noneOf(Scope.class);
        for (Project project : projects) {
            List<File> subset = project.getSubset();
            if (subset != null) {
                for (File file : subset) {
                    String name = file.getName();
                    if (name.equals("AndroidManifest.xml")) {
                        scope.add(MANIFEST);
                        continue;
                    }
                    if (name.endsWith(".xml")) {
                        scope.add(RESOURCE_FILE);
                        continue;
                    }
                    if (name.equals("res") || file.getParent().equals("res")) {
                        scope.add(ALL_RESOURCE_FILES);
                        scope.add(RESOURCE_FILE);
                        continue;
                    }
                    if (name.endsWith(".java")) {
                        scope.add(JAVA_FILE);
                        continue;
                    }
                    if (name.endsWith(".class")) {
                        scope.add(CLASS_FILE);
                        continue;
                    }
                    if (name.endsWith(".gradle")) {
                        scope.add(GRADLE_FILE);
                        continue;
                    }
                    if (!name.equals("proguard.cfg") && !name.equals("proguard-project.txt")) continue;
                    scope.add(PROGUARD_FILE);
                }
                continue;
            }
            scope = ALL;
            break;
        }
        return scope;
    }

    static {
        ALL = EnumSet.allOf(Scope.class);
        RESOURCE_FILE_SCOPE = EnumSet.of(RESOURCE_FILE);
        ALL_RESOURCES_SCOPE = EnumSet.of(ALL_RESOURCE_FILES);
        JAVA_FILE_SCOPE = EnumSet.of(JAVA_FILE);
        CLASS_FILE_SCOPE = EnumSet.of(CLASS_FILE);
        GRADLE_SCOPE = EnumSet.of(GRADLE_FILE);
        MANIFEST_SCOPE = EnumSet.of(MANIFEST);
        OTHER_SCOPE = EnumSet.of(OTHER);
        PROGUARD_SCOPE = EnumSet.of(PROGUARD_FILE);
        JAVA_AND_RESOURCE_FILES = EnumSet.of(RESOURCE_FILE, JAVA_FILE);
        CLASS_AND_ALL_RESOURCE_FILES = EnumSet.of(ALL_RESOURCE_FILES, CLASS_FILE);
        ALL_CLASSES_AND_LIBRARIES = EnumSet.of(ALL_CLASS_FILES, JAVA_LIBRARIES);
        JAVA_LIBRARY_SCOPE = EnumSet.of(JAVA_LIBRARIES);
    }
}

