/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.detector.api;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Severity;
import com.google.common.annotations.Beta;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@Beta
public final class Issue
implements Comparable<Issue> {
    private static final String HTTP_PREFIX = "http://";
    private final String mId;
    private final String mBriefDescription;
    private final String mDescription;
    private final String mExplanation;
    private final Category mCategory;
    private final int mPriority;
    private final Severity mSeverity;
    private Object mMoreInfoUrls;
    private boolean mEnabledByDefault = true;
    private Implementation mImplementation;

    private Issue(@NonNull String id, @NonNull String shortDescription, @NonNull String description, @NonNull String explanation, @NonNull Category category, int priority, @NonNull Severity severity, @NonNull Implementation implementation) {
        assert (!shortDescription.isEmpty());
        assert (!description.isEmpty());
        assert (!explanation.isEmpty());
        this.mId = id;
        this.mBriefDescription = shortDescription;
        this.mDescription = description;
        this.mExplanation = explanation;
        this.mCategory = category;
        this.mPriority = priority;
        this.mSeverity = severity;
        this.mImplementation = implementation;
    }

    @NonNull
    public static Issue create(@NonNull String id, @NonNull String briefDescription, @NonNull String description, @NonNull String explanation, @NonNull Category category, int priority, @NonNull Severity severity, @NonNull Implementation implementation) {
        return new Issue(id, briefDescription, description, explanation, category, priority, severity, implementation);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @NonNull
    public String getBriefDescription(@NonNull OutputFormat format) {
        switch (format) {
            case TEXT: {
                return Issue.convertMarkup(this.mBriefDescription, false);
            }
            case HTML: {
                return Issue.convertMarkup(this.mBriefDescription, true);
            }
        }
        return this.mBriefDescription;
    }

    @NonNull
    public String getDescription(@NonNull OutputFormat format) {
        switch (format) {
            case TEXT: {
                return Issue.convertMarkup(this.mDescription, false);
            }
            case HTML: {
                return Issue.convertMarkup(this.mDescription, true);
            }
        }
        return this.mDescription;
    }

    @NonNull
    public String getExplanation(@NonNull OutputFormat format) {
        switch (format) {
            case TEXT: {
                return Issue.convertMarkup(this.mExplanation, false);
            }
            case HTML: {
                return Issue.convertMarkup(this.mExplanation, true);
            }
        }
        return this.mExplanation;
    }

    @NonNull
    public Category getCategory() {
        return this.mCategory;
    }

    public int getPriority() {
        return this.mPriority;
    }

    @NonNull
    public Severity getDefaultSeverity() {
        return this.mSeverity;
    }

    @NonNull
    public List<String> getMoreInfo() {
        if (this.mMoreInfoUrls == null) {
            return Collections.emptyList();
        }
        if (this.mMoreInfoUrls instanceof String) {
            return Collections.singletonList((String)this.mMoreInfoUrls);
        }
        assert (this.mMoreInfoUrls instanceof List);
        return (List)this.mMoreInfoUrls;
    }

    @NonNull
    public Issue addMoreInfo(@NonNull String moreInfoUrl) {
        if (this.mMoreInfoUrls == null) {
            this.mMoreInfoUrls = moreInfoUrl;
        } else if (this.mMoreInfoUrls instanceof String) {
            String existing = (String)this.mMoreInfoUrls;
            ArrayList<String> list = new ArrayList<String>(2);
            list.add(existing);
            list.add(moreInfoUrl);
            this.mMoreInfoUrls = list;
        } else {
            assert (this.mMoreInfoUrls instanceof List);
            ((List)this.mMoreInfoUrls).add(moreInfoUrl);
        }
        return this;
    }

    public boolean isEnabledByDefault() {
        return this.mEnabledByDefault;
    }

    @NonNull
    public Implementation getImplementation() {
        return this.mImplementation;
    }

    public void setImplementation(@NonNull Implementation implementation) {
        this.mImplementation = implementation;
    }

    @Override
    public int compareTo(Issue other) {
        return this.getId().compareTo(other.getId());
    }

    @NonNull
    public Issue setEnabledByDefault(boolean enabledByDefault) {
        this.mEnabledByDefault = enabledByDefault;
        return this;
    }

    public String toString() {
        return this.mId;
    }

    @NonNull
    public static String convertMarkup(@NonNull String text, boolean html) {
        StringBuilder sb = new StringBuilder(3 * text.length() / 2);
        char prev = '\u0000';
        int flushIndex = 0;
        int n = text.length();
        for (int i = 0; i < n; ++i) {
            int end;
            char c = text.charAt(i);
            if (c == '*' || c == '`' && i < n - 1) {
                if (!(Character.isLetterOrDigit(prev) || Character.isWhitespace(text.charAt(i + 1)) || (end = text.indexOf(c, i + 1)) == -1 || end != n - 1 && Character.isLetter(text.charAt(end + 1)))) {
                    if (i > flushIndex) {
                        Issue.appendEscapedText(sb, text, html, flushIndex, i);
                    }
                    if (html) {
                        String tag = c == '*' ? "b" : "code";
                        sb.append('<').append(tag).append('>');
                        Issue.appendEscapedText(sb, text, html, i + 1, end);
                        sb.append('<').append('/').append(tag).append('>');
                    } else {
                        Issue.appendEscapedText(sb, text, html, i + 1, end);
                    }
                    flushIndex = end + 1;
                    i = flushIndex - 1;
                }
            } else if (html && c == 'h' && i < n - 1 && text.charAt(i + 1) == 't' && text.startsWith(HTTP_PREFIX, i) && !Character.isLetterOrDigit(prev)) {
                char d;
                for (end = i + HTTP_PREFIX.length(); end < n && !Character.isWhitespace(d = text.charAt(end)); ++end) {
                }
                char last = text.charAt(end - 1);
                if (last == '.' || last == ')' || last == '!') {
                    --end;
                }
                if (end > i + HTTP_PREFIX.length()) {
                    if (i > flushIndex) {
                        Issue.appendEscapedText(sb, text, html, flushIndex, i);
                    }
                    String url = text.substring(i, end);
                    sb.append("<a href=\"");
                    sb.append(url);
                    sb.append('\"').append('>');
                    sb.append(url);
                    sb.append("</a>");
                    flushIndex = end;
                    i = flushIndex - 1;
                }
            }
            prev = c;
        }
        if (flushIndex < n) {
            Issue.appendEscapedText(sb, text, html, flushIndex, n);
        }
        return sb.toString();
    }

    private static void appendEscapedText(StringBuilder sb, String text, boolean html, int start, int end) {
        if (html) {
            for (int i = start; i < end; ++i) {
                char c = text.charAt(i);
                if (c == '<') {
                    sb.append("&lt;");
                    continue;
                }
                if (c == '&') {
                    sb.append("&amp;");
                    continue;
                }
                if (c == '\n') {
                    sb.append("<br/>\n");
                    continue;
                }
                if (c > '\u00ff') {
                    sb.append("&#");
                    sb.append(Integer.toString(c));
                    sb.append(';');
                    continue;
                }
                sb.append(c);
            }
        } else {
            for (int i = start; i < end; ++i) {
                char c = text.charAt(i);
                sb.append(c);
            }
        }
    }

    public static enum OutputFormat {
        RAW,
        TEXT,
        HTML;

    }
}

