/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class FragmentDetector
extends Detector
implements Detector.ClassScanner {
    private static final String FRAGMENT_NAME_SUFFIX = "Fragment";
    public static final Issue ISSUE = Issue.create((String)"ValidFragment", (String)"Fragment not instantiatable", (String)"Ensures that `Fragment` subclasses can be instantiated", (String)"From the Fragment documentation:\n*Every* fragment must have an empty constructor, so it can be instantiated when restoring its activity's state. It is strongly recommended that subclasses do not have other constructors with parameters, since these constructors will not be called when the fragment is re-instantiated; instead, arguments can be supplied by the caller with `setArguments(Bundle)` and later retrieved by the Fragment with `getArguments()`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)new Implementation(FragmentDetector.class, Scope.CLASS_FILE_SCOPE)).addMoreInfo("http://developer.android.com/reference/android/app/Fragment.html#Fragment()");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if ((classNode.access & 0x400) != 0) {
            return;
        }
        LintDriver driver = context.getDriver();
        if (!driver.isSubclassOf(classNode, "android/app/Fragment") && !driver.isSubclassOf(classNode, "android/support/v4/app/Fragment")) {
            return;
        }
        if ((classNode.access & 1) == 0) {
            context.report(ISSUE, context.getLocation(classNode), String.format("This fragment class should be public (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
            return;
        }
        if (classNode.name.indexOf(36) != -1 && !LintUtils.isStaticInnerClass((ClassNode)classNode)) {
            context.report(ISSUE, context.getLocation(classNode), String.format("This fragment inner class should be static (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
            return;
        }
        boolean hasDefaultConstructor = false;
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!method.name.equals("<init>")) continue;
            if (method.desc.equals("()V")) {
                if ((method.access & 1) != 0) {
                    hasDefaultConstructor = true;
                    continue;
                }
                context.report(ISSUE, context.getLocation(method, classNode), "The default constructor must be public", null);
                hasDefaultConstructor = true;
                continue;
            }
            if (method.desc.contains("()")) continue;
            context.report(ISSUE, context.getLocation(method, classNode), "Avoid non-default constructors in fragments: use a default constructor plus Fragment#setArguments(Bundle) instead", null);
        }
        if (!hasDefaultConstructor) {
            context.report(ISSUE, context.getLocation(classNode), String.format("This fragment should provide a default constructor (a public constructor with no arguments) (%1$s)", ClassContext.createSignature((String)classNode.name, null, null)), null);
        }
    }
}

