/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.LintUtils;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.utils.Pair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodInvocation;
import lombok.ast.Select;
import lombok.ast.StrictListAccessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MergeRootFrameLayoutDetector
extends LayoutDetector
implements Detector.JavaScanner {
    private Set<String> mWhitelistedLayouts;
    private List<Pair<String, Location.Handle>> mPending;
    public static final Issue ISSUE = Issue.create((String)"MergeRootFrame", (String)"FrameLayout can be replaced with `<merge>` tag", (String)"Checks whether a root <FrameLayout> can be replaced with a `<merge>` tag", (String)"If a `<FrameLayout>` is the root of a layout and does not provide background or padding etc, it can often be replaced with a `<merge>` tag which is slightly more efficient. Note that this depends on context, so make sure you understand how the `<merge>` tag works before proceeding.", (Category)Category.PERFORMANCE, (int)4, (Severity)Severity.WARNING, (Implementation)new Implementation(MergeRootFrameLayoutDetector.class, EnumSet.of(Scope.ALL_RESOURCE_FILES, Scope.JAVA_FILE))).addMoreInfo("http://android-developers.blogspot.com/2009/03/android-layout-tricks-3-optimize-by.html");

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return LintUtils.isXmlFile((File)file) || LintUtils.endsWith((String)file.getName(), (String)".java");
    }

    public void afterCheckProject(@NonNull Context context) {
        if (this.mPending != null && this.mWhitelistedLayouts != null) {
            for (Pair<String, Location.Handle> pair : this.mPending) {
                String layout = (String)pair.getFirst();
                if (!this.mWhitelistedLayouts.contains(layout)) continue;
                Location.Handle handle = (Location.Handle)pair.getSecond();
                Object clientData = handle.getClientData();
                if (clientData instanceof Node && context.getDriver().isSuppressed(null, ISSUE, (Node)clientData)) {
                    return;
                }
                Location location = handle.resolve();
                context.report(ISSUE, location, "This <FrameLayout> can be replaced with a <merge> tag", null);
            }
        }
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList("include", "FrameLayout");
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String tag = element.getTagName();
        if (tag.equals("include")) {
            String layout = element.getAttribute("layout");
            if (layout.startsWith("@layout/")) {
                layout = layout.substring("@layout/".length());
                this.whiteListLayout(layout);
            }
        } else {
            assert (tag.equals("FrameLayout"));
            if (LintUtils.isRootElement((Element)element) && (MergeRootFrameLayoutDetector.isWidthFillParent((Element)element) && MergeRootFrameLayoutDetector.isHeightFillParent((Element)element) || !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "layout_gravity")) && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "background") && !element.hasAttributeNS("http://schemas.android.com/apk/res/android", "foreground") && !this.hasPadding(element)) {
                String layout = LintUtils.getLayoutName((File)context.file);
                Location.Handle handle = context.parser.createLocationHandle(context, (Node)element);
                handle.setClientData((Object)element);
                if (!context.getProject().getReportIssues()) {
                    return;
                }
                if (this.mPending == null) {
                    this.mPending = new ArrayList<Pair<String, Location.Handle>>();
                }
                this.mPending.add((Pair<String, Location.Handle>)Pair.of((Object)layout, (Object)handle));
            }
        }
    }

    private void whiteListLayout(String layout) {
        if (this.mWhitelistedLayouts == null) {
            this.mWhitelistedLayouts = new HashSet<String>();
        }
        this.mWhitelistedLayouts.add(layout);
    }

    public List<String> getApplicableMethodNames() {
        return Collections.singletonList("setContentView");
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        String expression;
        Expression argument;
        StrictListAccessor argumentList = node.astArguments();
        if (argumentList != null && argumentList.size() == 1 && (argument = (Expression)argumentList.first()) instanceof Select && (expression = argument.toString()).startsWith("R.layout.")) {
            this.whiteListLayout(expression.substring("R.layout.".length()));
        }
    }
}

