/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.List;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class ViewConstructorDetector
extends Detector
implements Detector.ClassScanner {
    private static final String SIG1 = "(Landroid/content/Context;)V";
    private static final String SIG2 = "(Landroid/content/Context;Landroid/util/AttributeSet;)V";
    private static final String SIG3 = "(Landroid/content/Context;Landroid/util/AttributeSet;I)V";
    public static final Issue ISSUE = Issue.create((String)"ViewConstructor", (String)"Missing View constructors for XML inflation", (String)"Checks that custom views define the expected constructors", (String)"Some layout tools (such as the Android layout editor for Studio & Eclipse) needs to find a constructor with one of the following signatures:\n* `View(Context context)`\n* `View(Context context, AttributeSet attrs)`\n* `View(Context context, AttributeSet attrs, int defStyle)`\n\nIf your custom view needs to perform initialization which does not apply when used in a layout editor, you can surround the given code with a check to see if `View#isInEditMode()` is false, since that method will return `false` at runtime but true within a user interface editor.", (Category)Category.USABILITY, (int)3, (Severity)Severity.WARNING, (Implementation)new Implementation(ViewConstructorDetector.class, Scope.CLASS_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if (classNode.name.indexOf(36) != -1 && (classNode.access & 8) == 0) {
            return;
        }
        if ((classNode.access & 0x400) != 0) {
            return;
        }
        if (ViewConstructorDetector.isViewClass(context, classNode)) {
            ViewConstructorDetector.checkConstructors(context, classNode);
        }
    }

    private static boolean isViewClass(ClassContext context, ClassNode node) {
        String superName = node.superName;
        while (superName != null) {
            if (superName.equals("android/view/View") || superName.equals("android/view/ViewGroup") || superName.startsWith("android/widget/") && !superName.endsWith("Adapter") && !superName.endsWith("Controller") && !superName.endsWith("Service") && !superName.endsWith("Provider") && !superName.endsWith("Filter")) {
                return true;
            }
            superName = context.getDriver().getSuperClass(superName);
        }
        return false;
    }

    private static void checkConstructors(ClassContext context, ClassNode classNode) {
        List methods = classNode.methods;
        for (Object methodObject : methods) {
            String desc;
            MethodNode method = (MethodNode)methodObject;
            if (!method.name.equals("<init>") || !(desc = method.desc).equals(SIG1) && !desc.equals(SIG2) && !desc.equals(SIG3)) continue;
            return;
        }
        String message = String.format("Custom view %1$s is missing constructor used by tools: (Context) or (Context,AttributeSet) or (Context,AttributeSet,int)", classNode.name);
        File sourceFile = context.getSourceFile();
        Location location = Location.create((File)(sourceFile != null ? sourceFile : context.file));
        context.report(ISSUE, location, message, null);
    }
}

