/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public class WrongCallDetector
extends Detector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"WrongCall", (String)"Using wrong draw/layout method", (String)"Finds cases where the wrong call is made, such as calling `onMeasure` instead of `measure`", (String)"Custom views typically need to call `measure()` on their children, not `onMeasure`. Ditto for onDraw, onLayout, etc.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(WrongCallDetector.class, Scope.CLASS_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public List<String> getApplicableCallNames() {
        return Arrays.asList("onDraw", "onMeasure", "onLayout");
    }

    public void checkCall(@NonNull ClassContext context, @NonNull ClassNode classNode, @NonNull MethodNode method, @NonNull MethodInsnNode call) {
        String name = call.name;
        if (call.getOpcode() != 183 || !name.equals(method.name)) {
            String suggestion = Character.toLowerCase(name.charAt(2)) + name.substring(3);
            String message = String.format("Suspicious method call; should probably call \"%1$s\" rather than \"%2$s\"", suggestion, name);
            context.report(ISSUE, method, (AbstractInsnNode)call, context.getLocation((AbstractInsnNode)call), message, null);
        }
    }
}

