/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.sdklib.repository.FullRevision;
import com.android.tools.lint.checks.ManifestDetector;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;

public class GradleDetector
extends Detector
implements Detector.GradleScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(GradleDetector.class, Scope.GRADLE_SCOPE);
    public static final Issue DEPENDENCY = Issue.create((String)"GradleDependency", (String)"Obsolete Gradle Dependency", (String)"Looks for old or obsolete Gradle library dependencies", (String)"This detector looks for usages of libraries where the version you are using is not the current stable release. Using older versions is fine, and there are cases where you deliberately want to stick with an older version. However, you may simply not be aware that a more recent version is available, and that is what this lint check helps find.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue PATH = Issue.create((String)"GradlePath", (String)"Gradle Path Issues", (String)"Looks for Gradle path problems such as using platform specific path separators", (String)"Gradle build scripts are meant to be cross platform, so file paths use Unix-style path separators (a forward slash) rather than Windows path separators (a backslash). Similarly, to keep projects portable and repeatable, avoid using absolute paths on the system; keep files within the project instead. To share code between projects, consider creating an android-library and an AAR dependency", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION);
    public static final Issue IDE_SUPPORT = Issue.create((String)"GradleIdeError", (String)"Gradle IDE Support Issues", (String)"Looks for constructs in Gradle files which affect IDE usage", (String)"Gradle is highly flexible, and there are things you can do in Gradle files which can make it hard or impossible for IDEs to properly handle the project. This lint check looks for constructs that potentially break IDE support.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue PLUS = Issue.create((String)"GradleDynamicVersion", (String)"Gradle Dynamic Version", (String)"Looks for dependencies using a dynamic version rather than a fixed version", (String)"Using `+` in dependencies lets you automatically pick up the latest available version rather than a specific, named version. However, this is not recommended; your builds are not repeatable; you may have tested with a slightly different version than what the build server used. (Using a dynamic version as the major version number is more problematic than using it in the minor version position.)", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue GRADLE_GETTER = Issue.create((String)"GradleGetter", (String)"Gradle Implicit Getter Call", (String)"Identifies accidental calls to implicit getters", (String)"Gradle will let you replace specific constants in your build scripts with method calls, so you can for example dynamically compute a version string based on your current version control revision number, rather than hardcoding a number.\n\nWhen computing a version name, it's tempting to for example call the method to do that `getVersionName`. However, when you put that method call inside the `defaultConfig` block, you will actually be calling the Groovy getter for the `versionName` property instead. Therefore, you need to name your method something which does not conflict with the existing implicit getters. Consider using `compute` as a prefix instead of `get`.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue COMPATIBILITY = Issue.create((String)"GradleCompatible", (String)"Incompatible Gradle Versions", (String)"Ensures that tool and library versions are compatible", (String)"There are some combinations of libraries, or tools and libraries, that are incompatible, or can lead to bugs. One such incompatibility is compiling with a version of the Android support libraries that is not the latest version (or in particular, a version lower than your `targetSdkVersion`.)", (Category)Category.CORRECTNESS, (int)8, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    public static final Issue REMOTE_VERSION = Issue.create((String)"NewerVersionAvailable", (String)"Newer Library Versions Available", (String)"Looks for Gradle library dependencies that can be replaced by newer versions", (String)"This detector checks with a central repository to see if there are newer versions available for the dependencies used by this project.\nThis is similar to the `GradleDependency` check, which checks for newer versions available in the Android SDK tools and libraries, but this works with any MavenCentral dependency, and connects to the library every time, which makes it more flexible but also *much* slower.", (Category)Category.CORRECTNESS, (int)4, (Severity)Severity.WARNING, (Implementation)IMPLEMENTATION).setEnabledByDefault(false);
    public static final Issue ACCIDENTAL_OCTAL = Issue.create((String)"AccidentalOctal", (String)"Accidental Octal", (String)"Looks for integer literals that are interpreted as octal numbers", (String)"In Groovy, an integer literal that starts with a leading 0 will be interpreted as an octal number. That is usually (always?) an accident and can lead to subtle bugs, for example when used in the `versionCode` of an app.", (Category)Category.CORRECTNESS, (int)2, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);
    private int mMinSdkVersion;
    private int mCompileSdkVersion;
    private int mTargetSdkVersion;
    private static int sMajorBuildTools;
    private static FullRevision sLatestBuildTools;

    public boolean appliesTo(@NonNull Context context, @NonNull File file) {
        return true;
    }

    @NonNull
    public Speed getSpeed(@NonNull Issue issue) {
        return issue == REMOTE_VERSION ? Speed.REALLY_SLOW : Speed.NORMAL;
    }

    public void visitBuildScript(@NonNull Context context, Map<String, Object> sharedData) {
    }

    protected static boolean isInterestingBlock(@NonNull String parent, @Nullable String parentParent) {
        return parent.equals("defaultConfig") || parent.equals("android") || parent.equals("dependencies") || parentParent != null && parentParent.equals("buildTypes");
    }

    protected static boolean isInterestingProperty(@NonNull String property, @NonNull String parent, @Nullable String parentParent) {
        return property.equals("targetSdkVersion") || property.equals("buildToolsVersion") || property.equals("compile") || property.endsWith("Compile") || property.equals("classpath") || property.equals("versionName") || property.equals("versionCode") || property.equals("compileSdkVersion") || property.equals("minSdkVersion") || property.equals("packageNameSuffix");
    }

    protected void checkOctal(@NonNull Context context, @NonNull String value, @NonNull Object cookie) {
        if (value.length() >= 2 && value.charAt(0) == '0' && (value.length() > 2 || value.charAt(1) >= '8' && GradleDetector.isInteger(value)) && context.isEnabled(ACCIDENTAL_OCTAL)) {
            String message = "The leading 0 turns this number into octal which is probably not what was intended";
            try {
                long numericValue = Long.decode(value);
                message = message + " (interpreted as " + numericValue + ")";
            }
            catch (NumberFormatException nufe) {
                message = message + " (and it is not a valid octal number)";
            }
            this.report(context, cookie, ACCIDENTAL_OCTAL, message);
        }
    }

    protected void checkDslPropertyAssignment(@NonNull Context context, @NonNull String property, @NonNull String value, @NonNull String parent, @Nullable String parentParent, @NonNull Object cookie) {
        String suffix;
        if (parent.equals("defaultConfig")) {
            if (property.equals("targetSdkVersion")) {
                int version = GradleDetector.getIntLiteralValue(value, -1);
                if (version > 0 && version < 19) {
                    String message = "Not targeting the latest versions of Android; compatibility modes apply. Consider testing and updating this version. Consult the android.os.Build.VERSION_CODES javadoc for details.";
                    this.report(context, cookie, ManifestDetector.TARGET_NEWER, message);
                }
                if (version > 0) {
                    this.mTargetSdkVersion = version;
                    this.checkTargetCompatibility(context, cookie);
                }
            }
            if (value.startsWith("0")) {
                this.checkOctal(context, value, cookie);
            }
            if ((property.equals("versionName") || property.equals("versionCode") && !GradleDetector.isInteger(value) || !GradleDetector.isStringLiteral(value)) && (value.equals("getVersionCode") || value.equals("getVersionName"))) {
                String message = "Bad method name: pick a unique method name which does not conflict with the implicit getters for the defaultConfig properties. For example, try using the prefix compute- instead of get-.";
                this.report(context, cookie, GRADLE_GETTER, message);
            }
        } else if (property.equals("compileSdkVersion") && parent.equals("android")) {
            int version = GradleDetector.getIntLiteralValue(value, -1);
            if (version > 0) {
                this.mCompileSdkVersion = version;
                this.checkTargetCompatibility(context, cookie);
            }
        } else if (property.equals("minSdkVersion") && parent.equals("android")) {
            int version = GradleDetector.getIntLiteralValue(value, -1);
            if (version > 0) {
                this.mMinSdkVersion = version;
            }
        } else if (property.equals("buildToolsVersion") && parent.equals("android")) {
            FullRevision recommended;
            FullRevision version;
            String versionString = GradleDetector.getStringLiteralValue(value);
            if (versionString != null && (version = GradleDetector.parseRevisionSilently(versionString)) != null && (recommended = GradleDetector.getLatestBuildTools(context.getClient(), version.getMajor())) != null && version.compareTo(recommended) < 0) {
                String message = "Old buildToolsVersion; recommended version is " + recommended + " or later";
                this.report(context, cookie, DEPENDENCY, message);
            }
        } else if (parent.equals("dependencies") && (property.equals("compile") || property.endsWith("Compile") || property.equals("classpath"))) {
            if (value.startsWith("files('") && value.endsWith("')")) {
                String path = value.substring("files('".length(), value.length() - 2);
                if (path.contains("\\\\")) {
                    String message = "Do not use Windows file separators in .gradle files; use / instead";
                    this.report(context, cookie, PATH, message);
                } else if (new File(path.replace('/', File.separatorChar)).isAbsolute()) {
                    String message = "Avoid using absolute paths in .gradle files";
                    this.report(context, cookie, PATH, message);
                }
            } else {
                GradleCoordinate gc;
                String dependency = GradleDetector.getStringLiteralValue(value);
                if (dependency != null && (gc = GradleCoordinate.parseCoordinateString((String)dependency)) != null) {
                    this.checkDependency(context, gc, cookie);
                    if (!dependency.startsWith("com.android.tools.build:gradle:") && gc.acceptsGreaterRevisions()) {
                        String message = "Avoid using + in version numbers; can lead to unpredictable and  unrepeatable builds";
                        this.report(context, cookie, PLUS, message);
                    }
                }
            }
        } else if (property.equals("packageNameSuffix") && (suffix = GradleDetector.getStringLiteralValue(value)) != null && !suffix.startsWith(".")) {
            String message = "Package suffix should probably start with a \".\"";
            this.report(context, cookie, PATH, message);
        }
    }

    @Nullable
    private static FullRevision parseRevisionSilently(String versionString) {
        try {
            return FullRevision.parseRevision((String)versionString);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @Nullable
    private static FullRevision getLatestBuildTools(@NonNull LintClient client, int major) {
        if (major != sMajorBuildTools) {
            File[] dirs;
            sMajorBuildTools = major;
            ArrayList revisions = Lists.newArrayList();
            if (major == 19) {
                revisions.add(new FullRevision(19, 1, 0));
            } else if (major == 18) {
                revisions.add(new FullRevision(18, 1, 1));
            }
            File sdkHome = client.getSdkHome();
            if (sdkHome != null && (dirs = new File(sdkHome, "build-tools").listFiles()) != null) {
                for (File dir : dirs) {
                    FullRevision v;
                    String name = dir.getName();
                    if (!dir.isDirectory() || !Character.isDigit(name.charAt(0)) || (v = GradleDetector.parseRevisionSilently(name)) == null || v.getMajor() != major) continue;
                    revisions.add(v);
                }
            }
            if (!revisions.isEmpty()) {
                sLatestBuildTools = (FullRevision)Collections.max(revisions);
            }
        }
        return sLatestBuildTools;
    }

    private void checkTargetCompatibility(Context context, Object cookie) {
        if (this.mCompileSdkVersion > 0 && this.mTargetSdkVersion > 0 && this.mTargetSdkVersion > this.mCompileSdkVersion) {
            String message = "The targetSdkVersion should not be higher than the compileSdkVersion";
            this.report(context, cookie, DEPENDENCY, message);
        }
    }

    @Nullable
    private static String getStringLiteralValue(@NonNull String value) {
        if (value.length() > 2 && (value.startsWith("'") && value.endsWith("'") || value.startsWith("\"") && value.endsWith("\""))) {
            return value.substring(1, value.length() - 1);
        }
        return null;
    }

    private static int getIntLiteralValue(@NonNull String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    private static boolean isInteger(String token) {
        return token.matches("\\d+");
    }

    private static boolean isStringLiteral(String token) {
        return token.startsWith("\"") && token.endsWith("\"") || token.startsWith("'") && token.endsWith("'");
    }

    private void checkDependency(@NonNull Context context, @NonNull GradleCoordinate dependency, @NonNull Object cookie) {
        FullRevision latest;
        if ("com.android.support".equals(dependency.getGroupId()) && ("support-v4".equals(dependency.getArtifactId()) || "appcompat-v7".equals(dependency.getArtifactId()))) {
            this.checkSupportLibraries(context, dependency, cookie);
            if (this.mMinSdkVersion >= 14 && "appcompat-v7".equals(dependency.getArtifactId())) {
                this.report(context, cookie, DEPENDENCY, "Using the appcompat library when minSdkVersion >= 14 is not necessary");
            }
            return;
        }
        if ("com.google.android.gms".equals(dependency.getGroupId()) && "play-services".equals(dependency.getArtifactId())) {
            this.checkPlayServices(context, dependency, cookie);
            return;
        }
        FullRevision version = null;
        Issue issue = DEPENDENCY;
        if ("com.android.tools.build".equals(dependency.getGroupId()) && "gradle".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, 0, 10, 1);
        } else if ("com.google.guava".equals(dependency.getGroupId()) && "guava".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, 17, 0, 0);
        } else if ("com.google.code.gson".equals(dependency.getGroupId()) && "gson".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, 2, 2, 4);
        } else if ("org.apache.httpcomponents".equals(dependency.getGroupId()) && "httpclient".equals(dependency.getArtifactId())) {
            version = GradleDetector.getNewerRevision(dependency, 4, 3, 3);
        }
        if (context.getScope().size() > 1 && context.isEnabled(REMOTE_VERSION) && (latest = GradleDetector.getLatestVersion(context, dependency)) != null && GradleDetector.isOlderThan(dependency, latest.getMajor(), latest.getMinor(), latest.getMicro())) {
            version = latest;
            issue = REMOTE_VERSION;
        }
        if (version != null) {
            String message = "A newer version of " + dependency.getGroupId() + ":" + dependency.getArtifactId() + " than " + dependency.getFullRevision() + " is available: " + version.toShortString();
            this.report(context, cookie, issue, message);
        }
    }

    private static FullRevision getLatestVersion(@NonNull Context context, @NonNull GradleCoordinate dependency) {
        int start;
        int end;
        StringBuilder query = new StringBuilder();
        String encoding = Charsets.UTF_8.name();
        try {
            query.append("http://search.maven.org/solrsearch/select?q=g:%22");
            query.append(URLEncoder.encode(dependency.getGroupId(), encoding));
            query.append("%22+AND+a:%22");
            query.append(URLEncoder.encode(dependency.getArtifactId(), encoding));
        }
        catch (UnsupportedEncodingException ee) {
            return null;
        }
        query.append("%22&core=gav&rows=1&wt=json");
        String response = GradleDetector.readUrlData(context, dependency, query.toString());
        if (response == null) {
            return null;
        }
        int index = response.indexOf("\"response\"");
        if (index != -1 && (index = response.indexOf("\"v\":", index)) != -1 && (end = response.indexOf(34, (start = response.indexOf(34, index += 4) + 1) + 1)) > start && start >= 0) {
            return GradleDetector.parseRevisionSilently(response.substring(start, end));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private static String readUrlData(@NonNull Context context, @NonNull GradleCoordinate dependency, @NonNull String query) {
        LintClient client = context.getClient();
        try {
            URL url = new URL(query);
            URLConnection connection = client.openConnection(url);
            if (connection == null) {
                return null;
            }
            try {
                String string;
                InputStream is = connection.getInputStream();
                if (is == null) {
                    String string2 = null;
                    return string2;
                }
                BufferedReader reader = new BufferedReader(new InputStreamReader(is, Charsets.UTF_8));
                try {
                    String line;
                    StringBuilder sb = new StringBuilder(500);
                    while ((line = reader.readLine()) != null) {
                        sb.append(line);
                        sb.append('\n');
                    }
                    string = sb.toString();
                }
                catch (Throwable throwable) {
                    reader.close();
                    throw throwable;
                }
                reader.close();
                return string;
            }
            finally {
                client.closeConnection(connection);
            }
        }
        catch (IOException ioe) {
            client.log((Throwable)ioe, "Could not connect to maven central to look up the latest available version for %1$s", new Object[]{dependency});
            return null;
        }
    }

    private void checkSupportLibraries(Context context, GradleCoordinate dependency, Object cookie) {
        File repository;
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        assert (groupId != null && artifactId != null);
        if (this.mTargetSdkVersion > 0 && dependency.getMajorVersion() < this.mTargetSdkVersion && dependency.getMajorVersion() != -1 && context.isEnabled(COMPATIBILITY)) {
            String message = "The support library should not use a lower version (" + dependency.getMajorVersion() + ") than the targetSdkVersion (" + this.mCompileSdkVersion + ")";
            this.report(context, cookie, COMPATIBILITY, message);
        }
        if ((repository = GradleDetector.findRepository(context.getClient(), "android")) == null) {
            this.report(context, cookie, DEPENDENCY, "Dependency on a support library, but the SDK installation does not have the \"Extras > Android Support Repository\" installed. Open the SDK manager and install it.");
        } else {
            this.checkLocalMavenVersions(context, dependency, cookie, groupId, artifactId, repository);
        }
    }

    private void checkPlayServices(Context context, GradleCoordinate dependency, Object cookie) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        assert (groupId != null && artifactId != null);
        File repository = GradleDetector.findRepository(context.getClient(), "google");
        if (repository == null) {
            this.report(context, cookie, DEPENDENCY, "Dependency on Play Services, but the SDK installation does not have the \"Extras > Google Repository\" installed. Open the SDK manager and install it.");
        } else {
            this.checkLocalMavenVersions(context, dependency, cookie, groupId, artifactId, repository);
        }
    }

    private void checkLocalMavenVersions(Context context, GradleCoordinate dependency, Object cookie, String groupId, String artifactId, File repository) {
        GradleCoordinate max = GradleDetector.getHighestInstalledVersion(groupId, artifactId, repository);
        if (max != null && GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, max) < 0 && context.isEnabled(DEPENDENCY)) {
            String message = "A newer version of " + groupId + ":" + artifactId + " than " + dependency.getFullRevision() + " is available: " + max.getFullRevision();
            this.report(context, cookie, DEPENDENCY, message);
        }
    }

    private static File findRepository(LintClient client, String extrasName) {
        File repository;
        File sdkHome = client.getSdkHome();
        if (sdkHome != null && (repository = new File(sdkHome, "extras" + File.separator + extrasName + File.separator + "m2repository")).exists()) {
            return repository;
        }
        return null;
    }

    @Nullable
    private static GradleCoordinate getHighestInstalledVersion(@NonNull String groupId, @NonNull String artifactId, @NonNull File repository) {
        File versionDir = new File(repository, groupId.replace('.', File.separatorChar) + File.separator + artifactId);
        File[] versions = versionDir.listFiles();
        if (versions != null) {
            ArrayList versionCoordinates = Lists.newArrayList();
            for (File dir : versions) {
                GradleCoordinate gc;
                if (!dir.isDirectory() || (gc = GradleCoordinate.parseCoordinateString((String)(groupId + ":" + artifactId + ":" + dir.getName()))) == null) continue;
                versionCoordinates.add(gc);
            }
            if (!versionCoordinates.isEmpty()) {
                return (GradleCoordinate)Collections.max(versionCoordinates, GradleCoordinate.COMPARE_PLUS_HIGHER);
            }
        }
        return null;
    }

    private static FullRevision getNewerRevision(@NonNull GradleCoordinate dependency, int major, int minor, int micro) {
        assert (dependency.getGroupId() != null);
        assert (dependency.getArtifactId() != null);
        if (GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, new GradleCoordinate(dependency.getGroupId(), dependency.getArtifactId(), new int[]{major, minor, micro})) < 0) {
            return new FullRevision(major, minor, micro);
        }
        return null;
    }

    private static boolean isOlderThan(@NonNull GradleCoordinate dependency, int major, int minor, int micro) {
        assert (dependency.getGroupId() != null);
        assert (dependency.getArtifactId() != null);
        return GradleCoordinate.COMPARE_PLUS_HIGHER.compare(dependency, new GradleCoordinate(dependency.getGroupId(), dependency.getArtifactId(), new int[]{major, minor, micro})) < 0;
    }

    private void report(@NonNull Context context, @NonNull Object cookie, @NonNull Issue issue, @NonNull String message) {
        if (context.isEnabled(issue)) {
            int startOffset;
            boolean checkComments = context.containsCommentSuppress();
            if (checkComments && (startOffset = this.getStartOffset(context, cookie)) >= 0 && context.isSuppressedWithComment(startOffset, issue)) {
                return;
            }
            context.report(issue, this.createLocation(context, cookie), message, null);
        }
    }

    protected int getStartOffset(@NonNull Context context, @NonNull Object cookie) {
        return -1;
    }

    protected Location createLocation(@NonNull Context context, @NonNull Object cookie) {
        return null;
    }
}

