/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.Expression;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Super;

public class WrongCallDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"WrongCall", (String)"Using wrong draw/layout method", (String)"Finds cases where the wrong call is made, such as calling `onMeasure` instead of `measure`", (String)"Custom views typically need to call `measure()` on their children, not `onMeasure`. Ditto for onDraw, onLayout, etc.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.FATAL, (Implementation)new Implementation(WrongCallDetector.class, Scope.JAVA_FILE_SCOPE));

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    @Nullable
    public List<String> getApplicableMethodNames() {
        return Arrays.asList("onDraw", "onMeasure", "onLayout");
    }

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        Expression operand = node.astOperand();
        if (!(operand instanceof Super)) {
            WrongCallDetector.report(context, node);
            return;
        }
        Node method = StringFormatDetector.getParentMethod((Node)node);
        if (!(method instanceof MethodDeclaration) || !((MethodDeclaration)method).astMethodName().astValue().equals(node.astName().astValue())) {
            WrongCallDetector.report(context, node);
        }
    }

    private static void report(JavaContext context, MethodInvocation node) {
        JavaParser.ResolvedMethod method;
        JavaParser.ResolvedClass containingClass;
        JavaParser.ResolvedNode resolved = context.resolve((Node)node);
        if (resolved instanceof JavaParser.ResolvedMethod && !(containingClass = (method = (JavaParser.ResolvedMethod)resolved).getContainingClass()).isSubclassOf("android.view.View", false)) {
            return;
        }
        String name = node.astName().astValue();
        String suggestion = Character.toLowerCase(name.charAt(2)) + name.substring(3);
        String message = String.format("Suspicious method call; should probably call \"%1$s\" rather than \"%2$s\"", suggestion, name);
        context.report(ISSUE, (Node)node, context.getLocation((Node)node.astName()), message, null);
    }
}

