/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Arrays;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ExpressionStatement;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;

public class CheckPermissionDetector
extends Detector
implements Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"UseCheckPermission", (String)"Using the result of check permission calls", (String)"You normally want to use the result of checking a permission; these methods return whether the permission is held; they do not throw an error if the permission is not granted. Code which does not do anything with the return value probably meant to be calling the enforce methods instead, e.g. rather than `Context#checkCallingPermission` it should call `Context#enforceCallingPermission`.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(CheckPermissionDetector.class, Scope.JAVA_FILE_SCOPE));
    private static final String CHECK_PERMISSION = "checkPermission";

    public void visitMethod(@NonNull JavaContext context, @Nullable AstVisitor visitor, @NonNull MethodInvocation node) {
        if (node.getParent() instanceof ExpressionStatement) {
            String check = node.astName().astValue();
            if (CHECK_PERMISSION.equals(check) && !context.isContextMethod(node)) {
                return;
            }
            assert (check.startsWith("check")) : check;
            String enforce = "enforce" + check.substring("check".length());
            context.report(ISSUE, (Node)node, context.getLocation((Node)node), String.format("The result of `%1$s` is not used; did you mean to call `%2$s`?", check, enforce));
        }
    }

    public List<String> getApplicableMethodNames() {
        return Arrays.asList(CHECK_PERMISSION, "checkUriPermission", "checkCallingOrSelfPermission", "checkCallingPermission", "checkCallingUriPermission", "checkCallingOrSelfUriPermission");
    }
}

