/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.annotations.NonNull;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LayoutDetector;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import com.android.tools.lint.detector.api.XmlContext;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import org.objectweb.asm.tree.ClassNode;
import org.w3c.dom.Element;

public class RegistrationDetector
extends LayoutDetector
implements Detector.ClassScanner {
    public static final Issue ISSUE = Issue.create((String)"Registered", (String)"Class is not registered in the manifest", (String)"Activities, services and content providers should be registered in the `AndroidManifest.xml` file using `<activity>`, `<service>` and `<provider>` tags.\n\nIf your activity is simply a parent class intended to be subclassed by other \"real\" activities, make it an abstract class.", (Category)Category.CORRECTNESS, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(RegistrationDetector.class, EnumSet.of(Scope.MANIFEST, Scope.CLASS_FILE))).addMoreInfo("http://developer.android.com/guide/topics/manifest/manifest-intro.html");
    protected Multimap<String, String> mManifestRegistrations;
    private static final String[] sTags = new String[]{"activity", "service", "receiver", "provider"};
    private static final String[] sClasses = new String[]{"android/app/Activity", "android/app/Service", "android/content/BroadcastReceiver", "android/content/ContentProvider"};

    @NonNull
    public Speed getSpeed() {
        return Speed.FAST;
    }

    public Collection<String> getApplicableElements() {
        return Arrays.asList(sTags);
    }

    public void visitElement(@NonNull XmlContext context, @NonNull Element element) {
        String fqcn = RegistrationDetector.getFqcn(context, element);
        String tag = element.getTagName();
        String frameworkClass = RegistrationDetector.tagToClass(tag);
        if (frameworkClass != null) {
            String signature = ClassContext.getInternalName((String)fqcn);
            if (this.mManifestRegistrations == null) {
                this.mManifestRegistrations = ArrayListMultimap.create((int)4, (int)8);
            }
            this.mManifestRegistrations.put((Object)frameworkClass, (Object)signature);
            if (signature.indexOf(36) != -1) {
                signature = signature.replace('$', '/');
                this.mManifestRegistrations.put((Object)frameworkClass, (Object)signature);
            }
        }
    }

    @NonNull
    private static String getFqcn(@NonNull XmlContext context, @NonNull Element element) {
        String className = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
        if (className.startsWith(".")) {
            return context.getMainProject().getPackage() + className;
        }
        if (className.indexOf(46) == -1) {
            return context.getMainProject().getPackage() + '.' + className;
        }
        return className;
    }

    public void checkClass(@NonNull ClassContext context, @NonNull ClassNode classNode) {
        if ((classNode.access & 0x400) != 0) {
            return;
        }
        String curr = classNode.name;
        int lastIndex = curr.lastIndexOf(36);
        if (lastIndex != -1 && lastIndex < curr.length() - 1 && Character.isDigit(curr.charAt(lastIndex + 1))) {
            return;
        }
        while (curr != null) {
            for (String s : sClasses) {
                Collection registered;
                if (!curr.equals(s)) continue;
                Collection collection = registered = this.mManifestRegistrations != null ? this.mManifestRegistrations.get((Object)curr) : null;
                if (registered != null && registered.contains(classNode.name)) continue;
                this.report(context, classNode, curr);
            }
            curr = context.getDriver().getSuperClass(curr);
        }
    }

    private void report(ClassContext context, ClassNode classNode, String curr) {
        Location location;
        String tag = RegistrationDetector.classToTag(curr);
        String className = ClassContext.createSignature((String)classNode.name, null, null);
        String wrongClass = null;
        if (this.mManifestRegistrations != null) {
            Collection entries = this.mManifestRegistrations.entries();
            for (Map.Entry entry : entries) {
                if (!((String)entry.getValue()).equals(classNode.name)) continue;
                wrongClass = (String)entry.getKey();
                break;
            }
        }
        if (wrongClass != null) {
            location = context.getLocation(classNode);
            context.report(ISSUE, location, String.format("`%1$s` is a `<%2$s>` but is registered in the manifest as a `<%3$s>`", className, tag, RegistrationDetector.classToTag(wrongClass)));
        } else if (!"receiver".equals(tag)) {
            if (context.getMainProject().isGradleProject()) {
                return;
            }
            location = context.getLocation(classNode);
            context.report(ISSUE, location, String.format("The `<%1$s> %2$s` is not registered in the manifest", tag, className));
        }
    }

    private static String tagToClass(String tag) {
        int n = sTags.length;
        for (int i = 0; i < n; ++i) {
            if (!sTags[i].equals(tag)) continue;
            return sClasses[i];
        }
        return null;
    }

    protected static String classToTag(String className) {
        int n = sClasses.length;
        for (int i = 0; i < n; ++i) {
            if (!sClasses[i].equals(className)) continue;
            return sTags[i];
        }
        return null;
    }
}

