/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ClassContext;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ConstructorInvocation;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.Identifier;
import lombok.ast.Node;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;

public class AllowAllHostnameVerifierDetector
extends Detector
implements Detector.ClassScanner,
Detector.JavaScanner {
    public static final Issue ISSUE = Issue.create((String)"AllowAllHostnameVerifier", (String)"Insecure HostnameVerifier", (String)"This check looks for declaration or use of HostnameVerifier implementations whose `verify` method always returns true (thus trusting any hostname) which could result in insecure network traffic caused by trusting arbitrary hostnames in TLS/SSL certificates presented by peers.", (Category)Category.SECURITY, (int)6, (Severity)Severity.WARNING, (Implementation)new Implementation(AllowAllHostnameVerifierDetector.class, EnumSet.of(Scope.ALL_CLASS_FILES, Scope.ALL_JAVA_FILES)));

    public Speed getSpeed() {
        return Speed.SLOW;
    }

    public void checkClass(ClassContext context, ClassNode classNode) {
        if (!classNode.interfaces.contains("javax/net/ssl/HostnameVerifier")) {
            return;
        }
        List methodList = classNode.methods;
        for (Object m : methodList) {
            MethodNode method = (MethodNode)m;
            if (!"verify".equals(method.name)) continue;
            InsnList nodes = method.instructions;
            boolean emptyMethod = true;
            boolean containsIconst1 = false;
            int n = nodes.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode instruction = nodes.get(i);
                int type = instruction.getType();
                if (type != 8 && type != 15 && (type != 0 || instruction.getOpcode() != 4 && instruction.getOpcode() != 172)) {
                    emptyMethod = false;
                    break;
                }
                if (type != 0 || instruction.getOpcode() != 4) continue;
                containsIconst1 = true;
            }
            if (!containsIconst1 || !emptyMethod) continue;
            Location location = context.getLocation(method, classNode);
            context.report(ISSUE, location, method.name + " always returns true, which " + "could cause insecure network traffic due to trusting TLS/SSL " + "server certificates for wrong hostnames");
        }
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Arrays.asList(ConstructorInvocation.class, Identifier.class);
    }

    public AstVisitor createJavaVisitor(JavaContext context) {
        return new IdentifierVisitor(context);
    }

    private static class IdentifierVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;

        public IdentifierVisitor(JavaContext context) {
            this.mContext = context;
        }

        public boolean visitConstructorInvocation(ConstructorInvocation node) {
            if ("AllowAllHostnameVerifier".equals(node.astTypeReference().getTypeName())) {
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(ISSUE, (Node)node, location, "Using the AllowAllHostnameVerifier HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames");
            }
            return super.visitConstructorInvocation(node);
        }

        public boolean visitIdentifier(Identifier node) {
            if ("ALLOW_ALL_HOSTNAME_VERIFIER".equals(node.astValue())) {
                Location location = this.mContext.getLocation((Node)node);
                this.mContext.report(ISSUE, (Node)node, location, "Using the ALLOW_ALL_HOSTNAME_VERIFIER HostnameVerifier is unsafe because it always returns true, which could cause insecure network traffic due to trusting TLS/SSL server certificates for wrong hostnames");
                return true;
            }
            return false;
        }
    }
}

