/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.SupportAnnotationDetector;
import com.android.tools.lint.client.api.JavaParser;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.Speed;
import java.io.File;
import java.util.Collections;
import java.util.List;
import lombok.ast.AstVisitor;
import lombok.ast.ForwardingAstVisitor;
import lombok.ast.MethodDeclaration;
import lombok.ast.MethodInvocation;
import lombok.ast.Node;
import lombok.ast.Super;

public class CallSuperDetector
extends Detector
implements Detector.JavaScanner {
    private static final String CALL_SUPER_ANNOTATION = "android.support.annotation.CallSuper";
    private static final String ON_DETACHED_FROM_WINDOW = "onDetachedFromWindow";
    private static final String ON_VISIBILITY_CHANGED = "onVisibilityChanged";
    private static final Implementation IMPLEMENTATION = new Implementation(CallSuperDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create((String)"MissingSuperCall", (String)"Missing Super Call", (String)"Some methods, such as `View#onDetachedFromWindow`, require that you also call the super implementation as part of your method.", (Category)Category.CORRECTNESS, (int)9, (Severity)Severity.ERROR, (Implementation)IMPLEMENTATION);

    public boolean appliesTo(Context context, File file) {
        return true;
    }

    public Speed getSpeed() {
        return Speed.FAST;
    }

    public List<Class<? extends Node>> getApplicableNodeTypes() {
        return Collections.singletonList(MethodDeclaration.class);
    }

    public AstVisitor createJavaVisitor(final JavaContext context) {
        return new ForwardingAstVisitor(){

            public boolean visitMethodDeclaration(MethodDeclaration node) {
                JavaParser.ResolvedNode resolved = context.resolve((Node)node);
                if (resolved instanceof JavaParser.ResolvedMethod) {
                    JavaParser.ResolvedMethod method = (JavaParser.ResolvedMethod)resolved;
                    CallSuperDetector.checkCallSuper(context, node, method);
                }
                return false;
            }
        };
    }

    private static void checkCallSuper(JavaContext context, MethodDeclaration declaration, JavaParser.ResolvedMethod method) {
        JavaParser.ResolvedMethod superMethod = CallSuperDetector.getRequiredSuperMethod(method);
        if (superMethod != null && !SuperCallVisitor.callsSuper(context, declaration, superMethod)) {
            String methodName = method.getName();
            String message = "Overriding method should call `super." + methodName + "`";
            Location location = context.getLocation((Node)declaration.astMethodName());
            context.report(ISSUE, (Node)declaration, location, message);
        }
    }

    private static JavaParser.ResolvedMethod getRequiredSuperMethod(JavaParser.ResolvedMethod method) {
        JavaParser.ResolvedMethod directSuper;
        String name = method.getName();
        if (ON_DETACHED_FROM_WINDOW.equals(name)) {
            if (!method.getContainingClass().isSubclassOf("android.view.View", false)) {
                return null;
            }
            return method.getSuperMethod();
        }
        if (ON_VISIBILITY_CHANGED.equals(name)) {
            if (!method.getContainingClass().isSubclassOf("android.support.wearable.watchface.WatchFaceService.Engine", false)) {
                return null;
            }
            return method.getSuperMethod();
        }
        for (JavaParser.ResolvedMethod superMethod = directSuper = method.getSuperMethod(); superMethod != null; superMethod = superMethod.getSuperMethod()) {
            Iterable<JavaParser.ResolvedAnnotation> annotations = superMethod.getAnnotations();
            annotations = SupportAnnotationDetector.filterRelevantAnnotations(annotations);
            for (JavaParser.ResolvedAnnotation annotation : annotations) {
                String signature = annotation.getSignature();
                if (CALL_SUPER_ANNOTATION.equals(signature)) {
                    return directSuper;
                }
                if (!signature.endsWith(".OverrideMustInvoke")) continue;
                return directSuper;
            }
        }
        return null;
    }

    private static class SuperCallVisitor
    extends ForwardingAstVisitor {
        private final JavaContext mContext;
        private final JavaParser.ResolvedMethod mMethod;
        private boolean mCallsSuper;

        public static boolean callsSuper(JavaContext context, MethodDeclaration methodDeclaration, JavaParser.ResolvedMethod method) {
            SuperCallVisitor visitor = new SuperCallVisitor(context, method);
            methodDeclaration.accept((AstVisitor)visitor);
            return visitor.mCallsSuper;
        }

        private SuperCallVisitor(JavaContext context, JavaParser.ResolvedMethod method) {
            this.mContext = context;
            this.mMethod = method;
        }

        public boolean visitSuper(Super node) {
            JavaParser.ResolvedNode resolved = null;
            if (node.getParent() instanceof MethodInvocation) {
                resolved = this.mContext.resolve(node.getParent());
            }
            if (resolved == null) {
                resolved = this.mContext.resolve((Node)node);
            }
            if (this.mMethod.equals(resolved)) {
                this.mCallsSuper = true;
                return true;
            }
            return false;
        }

        public boolean visitNode(Node node) {
            return this.mCallsSuper || super.visitNode(node);
        }
    }
}

