/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.res2;

import com.android.SdkConstants;
import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.ArrayResourceValue;
import com.android.ide.common.rendering.api.AttrResourceValue;
import com.android.ide.common.rendering.api.DeclareStyleableResourceValue;
import com.android.ide.common.rendering.api.DensityBasedResourceValue;
import com.android.ide.common.rendering.api.PluralsResourceValue;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.res2.DataItem;
import com.android.ide.common.res2.NodeUtils;
import com.android.ide.common.res2.ResourceFile;
import com.android.ide.common.res2.ValueXmlHelper;
import com.android.ide.common.resources.configuration.Configurable;
import com.android.ide.common.resources.configuration.DensityQualifier;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.resources.Density;
import com.android.resources.ResourceType;
import com.google.common.base.Splitter;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ResourceItem
extends DataItem<ResourceFile>
implements Configurable,
Comparable<ResourceItem> {
    private final ResourceType mType;
    private Node mValue;
    protected ResourceValue mResourceValue;
    private boolean mIgnoredFromDiskMerge = false;

    public ResourceItem(@NonNull String name, @NonNull ResourceType type, Node value) {
        super(name);
        this.mType = type;
        this.mValue = value;
    }

    @NonNull
    public ResourceType getType() {
        return this.mType;
    }

    @Nullable
    public Node getValue() {
        return this.mValue;
    }

    @Nullable
    public String getValueText() {
        return this.mValue != null ? this.mValue.getTextContent() : null;
    }

    void setValue(ResourceItem from) {
        this.mValue = from.mValue;
        this.setTouched();
    }

    @Override
    public FolderConfiguration getConfiguration() {
        assert (this.getSource() != null) : this;
        String qualifier = ((ResourceFile)this.getSource()).getQualifiers();
        if (qualifier.isEmpty()) {
            return new FolderConfiguration();
        }
        return FolderConfiguration.getConfigFromQualifiers(Splitter.on((char)'-').split((CharSequence)qualifier));
    }

    @Override
    public String getKey() {
        if (this.getSource() == null) {
            throw new IllegalStateException("ResourceItem.getKey called on object with no ResourceFile: " + this);
        }
        String qualifiers = ((ResourceFile)this.getSource()).getQualifiers();
        if (!qualifiers.isEmpty()) {
            return this.mType.getName() + "-" + qualifiers + "/" + this.getName();
        }
        return this.mType.getName() + "/" + this.getName();
    }

    @Override
    void addExtraAttributes(Document document, Node node, String namespaceUri) {
        NodeUtils.addAttribute(document, node, null, "type", this.mType.getName());
    }

    @Override
    Node getAdoptedNode(Document document) {
        return NodeUtils.adoptNode(document, this.mValue);
    }

    @Override
    protected void wasTouched() {
        this.mResourceValue = null;
    }

    @Nullable
    public ResourceValue getResourceValue(boolean isFrameworks) {
        if (this.mResourceValue == null) {
            if (this.mValue == null) {
                Density density;
                Density density2 = density = this.mType == ResourceType.DRAWABLE ? this.getFolderDensity() : null;
                this.mResourceValue = density != null ? new DensityBasedResourceValue(this.mType, this.getName(), ((ResourceFile)this.getSource()).getFile().getAbsolutePath(), density, isFrameworks) : new ResourceValue(this.mType, this.getName(), ((ResourceFile)this.getSource()).getFile().getAbsolutePath(), isFrameworks);
            } else {
                this.mResourceValue = this.parseXmlToResourceValue(isFrameworks);
            }
        }
        return this.mResourceValue;
    }

    @Nullable
    private Density getFolderDensity() {
        DensityQualifier densityQualifier;
        Iterable segments;
        FolderConfiguration config;
        String qualifiers = ((ResourceFile)this.getSource()).getQualifiers();
        if (!qualifiers.isEmpty() && qualifiers.contains("dpi") && (config = FolderConfiguration.getConfigFromQualifiers(segments = Splitter.on((char)'-').split((CharSequence)qualifiers))) != null && (densityQualifier = config.getDensityQualifier()) != null) {
            return densityQualifier.getValue();
        }
        return null;
    }

    public String getXmlString(ResourceType type, boolean system) {
        if (type == ResourceType.ID) {
            return (system ? "@android:+id/" : "@+id/") + "/" + this.getName();
        }
        return (system ? "@android:" : "@") + type.getName() + "/" + this.getName();
    }

    public boolean compareValueWith(ResourceItem resource) {
        if (this.mValue != null && resource.mValue != null) {
            return NodeUtils.compareElementNode(this.mValue, resource.mValue);
        }
        return this.mValue == resource.mValue;
    }

    public String toString() {
        return "ResourceItem{mName='" + this.getName() + '\'' + ", mType=" + this.mType + ", mStatus=" + this.getStatus() + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceItem that = (ResourceItem)o;
        return this.mType == that.mType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mType.hashCode();
        return result;
    }

    @Nullable
    private ResourceValue parseXmlToResourceValue(boolean isFrameworks) {
        ResourceValue value;
        assert (this.mValue != null);
        NamedNodeMap attributes = this.mValue.getAttributes();
        ResourceType type = this.getType(this.mValue.getLocalName(), attributes);
        if (type == null) {
            return null;
        }
        String name = this.getName();
        switch (type) {
            case STYLE: {
                String parent = ResourceItem.getAttributeValue(attributes, "parent");
                try {
                    value = this.parseStyleValue(new StyleResourceValue(type, name, parent, isFrameworks));
                    break;
                }
                catch (Throwable t) {
                    System.err.println("Problem parsing attribute " + name + " of type " + type + " for node " + this.mValue);
                    return null;
                }
            }
            case DECLARE_STYLEABLE: {
                value = this.parseDeclareStyleable(new DeclareStyleableResourceValue(type, name, isFrameworks));
                break;
            }
            case ARRAY: {
                value = this.parseArrayValue(new ArrayResourceValue(name, isFrameworks));
                break;
            }
            case PLURALS: {
                value = this.parsePluralsValue(new PluralsResourceValue(name, isFrameworks));
                break;
            }
            case ATTR: {
                value = this.parseAttrValue(new AttrResourceValue(type, name, isFrameworks));
                break;
            }
            default: {
                value = this.parseValue(new ResourceValue(type, name, isFrameworks));
            }
        }
        return value;
    }

    @Nullable
    private ResourceType getType(String qName, NamedNodeMap attributes) {
        String typeValue = "item".equals(qName) ? ResourceItem.getAttributeValue(attributes, "type") : qName;
        return ResourceType.getEnum((String)typeValue);
    }

    @Nullable
    private static String getAttributeValue(NamedNodeMap attributes, String attributeName) {
        Attr attribute = (Attr)attributes.getNamedItem(attributeName);
        if (attribute != null) {
            return attribute.getValue();
        }
        return null;
    }

    @NonNull
    private ResourceValue parseStyleValue(@NonNull StyleResourceValue styleValue) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (name = ResourceItem.getAttributeValue(attributes = child.getAttributes(), "name")) == null) continue;
            boolean isFrameworkAttr = styleValue.isFramework();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                isFrameworkAttr = true;
            }
            ResourceValue resValue = new ResourceValue(null, name, styleValue.isFramework());
            resValue.setValue(ValueXmlHelper.unescapeResourceString(ResourceItem.getTextNode(child), false, true));
            styleValue.addValue(resValue, isFrameworkAttr);
        }
        return styleValue;
    }

    @NonNull
    private AttrResourceValue parseAttrValue(@NonNull AttrResourceValue attrValue) {
        return ResourceItem.parseAttrValue(this.mValue, attrValue);
    }

    @NonNull
    private static AttrResourceValue parseAttrValue(@NonNull Node valueNode, @NonNull AttrResourceValue attrValue) {
        NodeList children = valueNode.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            String value;
            NamedNodeMap attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (name = ResourceItem.getAttributeValue(attributes = child.getAttributes(), "name")) == null || (value = ResourceItem.getAttributeValue(attributes, "value")) == null) continue;
            try {
                attrValue.addValue(name, Integer.valueOf((int)Long.decode(value).longValue()));
                continue;
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return attrValue;
    }

    private ResourceValue parseArrayValue(ArrayResourceValue arrayValue) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            String text = ResourceItem.getTextNode(child);
            text = ValueXmlHelper.unescapeResourceString(text, false, true);
            arrayValue.addElement(text);
        }
        return arrayValue;
    }

    private ResourceValue parsePluralsValue(PluralsResourceValue value) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String quantity;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (quantity = ResourceItem.getAttributeValue(attributes = child.getAttributes(), "quantity")) == null) continue;
            String text = ResourceItem.getTextNode(child);
            text = ValueXmlHelper.unescapeResourceString(text, false, true);
            value.addPlural(quantity, text);
        }
        return value;
    }

    @NonNull
    private ResourceValue parseDeclareStyleable(@NonNull DeclareStyleableResourceValue declareStyleable) {
        NodeList children = this.mValue.getChildNodes();
        int n = children.getLength();
        for (int i = 0; i < n; ++i) {
            NamedNodeMap attributes;
            String name;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || (name = ResourceItem.getAttributeValue(attributes = child.getAttributes(), "name")) == null) continue;
            boolean isFrameworkAttr = declareStyleable.isFramework();
            if (name.startsWith("android:")) {
                name = name.substring(SdkConstants.ANDROID_NS_NAME_PREFIX_LEN);
                isFrameworkAttr = true;
            }
            AttrResourceValue attr = ResourceItem.parseAttrValue(child, new AttrResourceValue(ResourceType.ATTR, name, isFrameworkAttr));
            declareStyleable.addValue(attr);
        }
        return declareStyleable;
    }

    @NonNull
    private ResourceValue parseValue(@NonNull ResourceValue value) {
        value.setValue(ValueXmlHelper.unescapeResourceString(ResourceItem.getTextNode(this.mValue), false, true));
        return value;
    }

    @NonNull
    private static String getTextNode(@NonNull Node node) {
        StringBuilder sb = new StringBuilder();
        NodeList children = node.getChildNodes();
        int n = children.getLength();
        block5: for (int i = 0; i < n; ++i) {
            Node child = children.item(i);
            short nodeType = child.getNodeType();
            switch (nodeType) {
                case 1: {
                    Element element = (Element)child;
                    if ("g".equals(element.getLocalName()) && element.getNamespaceURI() != null && element.getNamespaceURI().startsWith("urn:oasis:names:tc:xliff:document:")) {
                        if (element.hasAttribute("example")) {
                            String example = element.getAttribute("example");
                            sb.append('(').append(example).append(')');
                            continue block5;
                        }
                        if (element.hasAttribute("id")) {
                            String id = element.getAttribute("id");
                            sb.append('$').append('{').append(id).append('}');
                            continue block5;
                        }
                    }
                    sb.append(ResourceItem.getTextNode(child));
                    continue block5;
                }
                case 3: {
                    sb.append(child.getNodeValue());
                    continue block5;
                }
                case 4: {
                    sb.append(child.getNodeValue());
                }
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(@NonNull ResourceItem resourceItem) {
        int comp = this.mType.compareTo((Enum)resourceItem.getType());
        if (comp == 0) {
            comp = this.getName().compareTo(resourceItem.getName());
        }
        return comp;
    }

    public void setIgnoredFromDiskMerge(boolean ignored) {
        this.mIgnoredFromDiskMerge = ignored;
    }

    public boolean getIgnoredFromDiskMerge() {
        return this.mIgnoredFromDiskMerge;
    }
}

