/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.repository;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GradleCoordinate {
    public static final int PLUS_REV = -1;
    private final String myGroupId;
    private final String myArtifactId;
    private final ArtifactType myArtifactType;
    private final List<Integer> myRevisions = new ArrayList<Integer>(3);
    private final boolean myIsAnyRevision;
    private static final Pattern MAVEN_PATTERN = Pattern.compile("([\\w\\d\\.-]+):([\\w\\d\\.-]+):([\\d+\\.\\+]+)(@[\\w-]+)?");
    private static final Pattern REVISION_PATTERN = Pattern.compile("(\\d+|\\+)");
    public static final Comparator<GradleCoordinate> COMPARE_PLUS_LOWER = new Comparator<GradleCoordinate>(){

        @Override
        public int compare(@NonNull GradleCoordinate a, @NonNull GradleCoordinate b) {
            if (!a.isSameArtifact(b)) {
                return a.myArtifactId.compareTo(b.myArtifactId);
            }
            if (a.myIsAnyRevision) {
                return -1;
            }
            if (b.myIsAnyRevision) {
                return 1;
            }
            for (int i = 0; i < a.myRevisions.size(); ++i) {
                int delta = (Integer)a.myRevisions.get(i) - (Integer)b.myRevisions.get(i);
                if (delta == 0) continue;
                return delta;
            }
            return 0;
        }
    };
    public static final Comparator<GradleCoordinate> COMPARE_PLUS_HIGHER = new Comparator<GradleCoordinate>(){

        @Override
        public int compare(@NonNull GradleCoordinate a, @NonNull GradleCoordinate b) {
            if (!a.isSameArtifact(b)) {
                return a.myArtifactId.compareTo(b.myArtifactId);
            }
            if (a.myIsAnyRevision) {
                return 1;
            }
            if (b.myIsAnyRevision) {
                return -1;
            }
            for (int i = 0; i < a.myRevisions.size(); ++i) {
                int delta;
                int revision2;
                int revision1 = (Integer)a.myRevisions.get(i);
                if (revision1 == -1) {
                    revision1 = Integer.MAX_VALUE;
                }
                if ((revision2 = ((Integer)b.myRevisions.get(i)).intValue()) == -1) {
                    revision2 = Integer.MAX_VALUE;
                }
                if ((delta = revision1 - revision2) == 0) continue;
                return delta;
            }
            return 0;
        }
    };

    public GradleCoordinate(@NonNull String groupId, @NonNull String artifactId, Integer ... revisions) {
        this(groupId, artifactId, Arrays.asList(revisions), null);
    }

    public GradleCoordinate(@NonNull String groupId, @NonNull String artifactId, @NonNull List<Integer> revisions, @Nullable ArtifactType type) {
        this.myGroupId = groupId;
        this.myArtifactId = artifactId;
        this.myRevisions.addAll(revisions);
        this.myIsAnyRevision = !this.myRevisions.isEmpty() && this.myRevisions.get(0) == -1;
        this.myArtifactType = type;
    }

    @Nullable
    public static GradleCoordinate parseCoordinateString(@NonNull String coordinateString) {
        if (coordinateString == null) {
            return null;
        }
        Matcher matcher = MAVEN_PATTERN.matcher(coordinateString);
        if (!matcher.matches()) {
            return null;
        }
        String groupId = matcher.group(1);
        String artifactId = matcher.group(2);
        String revision = matcher.group(3);
        String typeString = matcher.group(4);
        ArtifactType type = null;
        if (typeString != null) {
            type = ArtifactType.getArtifactType(typeString.substring(1));
        }
        matcher = REVISION_PATTERN.matcher(revision);
        ArrayList<Integer> revisions = new ArrayList<Integer>(matcher.groupCount());
        while (matcher.find()) {
            String group = matcher.group();
            revisions.add(group.equals("+") ? -1 : Integer.parseInt(group));
            if (!group.equals("+")) continue;
            break;
        }
        return new GradleCoordinate(groupId, artifactId, revisions, type);
    }

    public String toString() {
        String s = String.format(Locale.US, "%s:%s:%s", this.myGroupId, this.myArtifactId, this.getFullRevision());
        if (this.myArtifactType != null) {
            s = s + "@" + this.myArtifactType.toString();
        }
        return s;
    }

    @Nullable
    public String getGroupId() {
        return this.myGroupId;
    }

    @Nullable
    public String getArtifactId() {
        return this.myArtifactId;
    }

    @Nullable
    public String getId() {
        if (this.myGroupId == null || this.myArtifactId == null) {
            return null;
        }
        return String.format("%s:%s", this.myGroupId, this.myArtifactId);
    }

    @Nullable
    public ArtifactType getType() {
        return this.myArtifactType;
    }

    public boolean acceptsGreaterRevisions() {
        return this.myRevisions.get(this.myRevisions.size() - 1) == -1;
    }

    public String getFullRevision() {
        StringBuilder revision = new StringBuilder();
        for (int i : this.myRevisions) {
            if (revision.length() > 0) {
                revision.append('.');
            }
            revision.append(i == -1 ? "+" : Integer.valueOf(i));
        }
        return revision.toString();
    }

    public int getMajorVersion() {
        return this.myRevisions.isEmpty() ? Integer.MIN_VALUE : this.myRevisions.get(0);
    }

    public int getMinorVersion() {
        return this.myRevisions.size() < 2 ? Integer.MIN_VALUE : this.myRevisions.get(1);
    }

    public int getMicroVersion() {
        return this.myRevisions.size() < 3 ? Integer.MIN_VALUE : this.myRevisions.get(2);
    }

    public boolean isSameArtifact(@NonNull GradleCoordinate o) {
        return o.myGroupId.equals(this.myGroupId) && o.myArtifactId.equals(this.myArtifactId);
    }

    public boolean equals(@NonNull Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GradleCoordinate that = (GradleCoordinate)o;
        if (!((Object)this.myRevisions).equals(that.myRevisions)) {
            return false;
        }
        if (!this.myArtifactId.equals(that.myArtifactId)) {
            return false;
        }
        if (!this.myGroupId.equals(that.myGroupId)) {
            return false;
        }
        if (this.myArtifactType == null != (that.myArtifactType == null)) {
            return false;
        }
        return this.myArtifactType == null || this.myArtifactType.equals((Object)that.myArtifactType);
    }

    public int hashCode() {
        int result = this.myGroupId.hashCode();
        result = 31 * result + this.myArtifactId.hashCode();
        for (Integer i : this.myRevisions) {
            result = 31 * result + i;
        }
        if (this.myArtifactType != null) {
            result = 31 * result + this.myArtifactType.hashCode();
        }
        return result;
    }

    public static enum ArtifactType {
        POM("pom"),
        JAR("jar"),
        MAVEN_PLUGIN("maven-plugin"),
        EJB("ejb"),
        WAR("war"),
        EAR("ear"),
        RAR("rar"),
        PAR("par"),
        AAR("aar");

        private final String myId;

        private ArtifactType(String id) {
            this.myId = id;
        }

        @Nullable
        public static ArtifactType getArtifactType(@Nullable String name) {
            if (name != null) {
                for (ArtifactType type : ArtifactType.values()) {
                    if (!type.myId.equalsIgnoreCase(name)) continue;
                    return type;
                }
            }
            return null;
        }

        public String toString() {
            return this.myId;
        }
    }
}

