/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.resources;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.ide.common.rendering.api.LayoutLog;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceUrl;
import com.android.resources.ResourceType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ResourceResolver
extends RenderResources {
    public static final String THEME_NAME = "Theme";
    public static final String THEME_NAME_DOT = "Theme.";
    public static final String XLIFF_NAMESPACE_PREFIX = "urn:oasis:names:tc:xliff:document:";
    public static final String XLIFF_G_TAG = "g";
    public static final String ATTR_EXAMPLE = "example";
    public static final int MAX_RESOURCE_INDIRECTION = 50;
    private final Map<ResourceType, Map<String, ResourceValue>> mProjectResources;
    private final Map<ResourceType, Map<String, ResourceValue>> mFrameworkResources;
    private final Map<StyleResourceValue, StyleResourceValue> mStyleInheritanceMap = new HashMap<StyleResourceValue, StyleResourceValue>();
    private StyleResourceValue mDefaultTheme;
    private final List<StyleResourceValue> mThemes;
    private RenderResources.FrameworkResourceIdProvider mFrameworkProvider;
    private LayoutLog mLogger;
    private String mThemeName;
    private boolean mIsProjectTheme;

    private ResourceResolver(Map<ResourceType, Map<String, ResourceValue>> projectResources, Map<ResourceType, Map<String, ResourceValue>> frameworkResources, String themeName, boolean isProjectTheme) {
        this.mProjectResources = projectResources;
        this.mFrameworkResources = frameworkResources;
        this.mThemeName = themeName;
        this.mIsProjectTheme = isProjectTheme;
        this.mThemes = new LinkedList<StyleResourceValue>();
    }

    public static ResourceResolver create(Map<ResourceType, Map<String, ResourceValue>> projectResources, Map<ResourceType, Map<String, ResourceValue>> frameworkResources, String themeName, boolean isProjectTheme) {
        ResourceResolver resolver = new ResourceResolver(projectResources, frameworkResources, themeName, isProjectTheme);
        resolver.computeStyleMaps();
        return resolver;
    }

    public void setDeviceDefaults(@Nullable String lightStyle, @Nullable String darkStyle) {
        if (darkStyle != null) {
            this.replace("Theme.DeviceDefault", darkStyle);
        }
        if (lightStyle != null && this.replace("Theme.DeviceDefault.Light", lightStyle)) {
            this.replace("Theme.DeviceDefault.Light.DarkActionBar", lightStyle + ".DarkActionBar");
        }
    }

    private boolean replace(String fromStyleName, String toStyleName) {
        ResourceValue to;
        ResourceValue from;
        Map<String, ResourceValue> map = this.mFrameworkResources.get(ResourceType.STYLE);
        if (map != null && (from = map.get(fromStyleName)) instanceof StyleResourceValue && (to = map.get(toStyleName)) instanceof StyleResourceValue) {
            this.mStyleInheritanceMap.put((StyleResourceValue)from, (StyleResourceValue)to);
            return true;
        }
        return false;
    }

    public String getThemeName() {
        return this.mThemeName;
    }

    public boolean isProjectTheme() {
        return this.mIsProjectTheme;
    }

    public Map<ResourceType, Map<String, ResourceValue>> getProjectResources() {
        return this.mProjectResources;
    }

    public Map<ResourceType, Map<String, ResourceValue>> getFrameworkResources() {
        return this.mFrameworkResources;
    }

    public void setFrameworkResourceIdProvider(RenderResources.FrameworkResourceIdProvider provider) {
        this.mFrameworkProvider = provider;
    }

    public void setLogger(LayoutLog logger) {
        this.mLogger = logger;
    }

    public StyleResourceValue getDefaultTheme() {
        return this.mDefaultTheme;
    }

    public void applyStyle(StyleResourceValue theme, boolean useAsPrimary) {
        if (theme == null) {
            return;
        }
        if (useAsPrimary) {
            this.mThemes.add(0, theme);
        } else {
            this.mThemes.add(theme);
        }
    }

    public void clearStyles() {
        this.mThemes.clear();
        this.mThemes.add(this.mDefaultTheme);
    }

    public List<StyleResourceValue> getAllThemes() {
        return this.mThemes;
    }

    public StyleResourceValue getTheme(String name, boolean frameworkTheme) {
        ResourceValue theme;
        if (frameworkTheme) {
            Map<String, ResourceValue> frameworkStyleMap = this.mFrameworkResources.get(ResourceType.STYLE);
            theme = frameworkStyleMap.get(name);
        } else {
            Map<String, ResourceValue> projectStyleMap = this.mProjectResources.get(ResourceType.STYLE);
            theme = projectStyleMap.get(name);
        }
        if (theme instanceof StyleResourceValue) {
            return (StyleResourceValue)theme;
        }
        return null;
    }

    public boolean themeIsParentOf(StyleResourceValue parentTheme, StyleResourceValue childTheme) {
        do {
            if ((childTheme = this.mStyleInheritanceMap.get(childTheme)) != null) continue;
            return false;
        } while (childTheme != parentTheme);
        return true;
    }

    public ResourceValue getFrameworkResource(ResourceType resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mFrameworkResources);
    }

    public ResourceValue getProjectResource(ResourceType resourceType, String resourceName) {
        return this.getResource(resourceType, resourceName, this.mProjectResources);
    }

    @Deprecated
    public ResourceValue findItemInStyle(StyleResourceValue style, String attrName) {
        ResourceValue item = this.findItemInStyle(style, attrName, false);
        if (item == null) {
            item = this.findItemInStyle(style, attrName, true);
        }
        return item;
    }

    public ResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
        return this.findItemInStyle(style, itemName, isFrameworkAttr, 0);
    }

    private ResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr, int depth) {
        StyleResourceValue parentStyle;
        ResourceValue item = style.findValue(itemName, isFrameworkAttr);
        if (item == null && (parentStyle = this.mStyleInheritanceMap.get(style)) != null) {
            if (depth >= 50) {
                if (this.mLogger != null) {
                    this.mLogger.error("broken", String.format("Cyclic style parent definitions: %1$s", this.computeCyclicStyleChain(style)), null);
                }
                return null;
            }
            return this.findItemInStyle(parentStyle, itemName, isFrameworkAttr, depth + 1);
        }
        return item;
    }

    private String computeCyclicStyleChain(StyleResourceValue style) {
        StringBuilder sb = new StringBuilder(100);
        this.appendStyleParents(style, new HashSet<StyleResourceValue>(), 0, sb);
        return sb.toString();
    }

    private void appendStyleParents(StyleResourceValue style, Set<StyleResourceValue> seen, int depth, StringBuilder sb) {
        if (depth >= 50) {
            sb.append("...");
            return;
        }
        boolean haveSeen = seen.contains(style);
        seen.add(style);
        sb.append('\"');
        if (style.isFramework()) {
            sb.append("android:");
        }
        sb.append(style.getName());
        sb.append('\"');
        if (haveSeen) {
            return;
        }
        StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(style);
        if (parentStyle != null) {
            if (style.getParentStyle() != null) {
                sb.append(" specifies parent ");
            } else {
                sb.append(" implies parent ");
            }
            this.appendStyleParents(parentStyle, seen, depth + 1, sb);
        }
    }

    public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
        if (reference == null) {
            return null;
        }
        ResourceUrl resource = ResourceUrl.parse(reference);
        if (resource != null && resource.hasValidName()) {
            if (resource.theme) {
                if (this.mDefaultTheme == null) {
                    return null;
                }
                if (resource.type != ResourceType.ATTR) {
                    return null;
                }
                ResourceValue item = this.findItemInTheme(resource.name, forceFrameworkOnly || resource.framework);
                if (item == null && this.mLogger != null) {
                    this.mLogger.warning("resources.resolve.theme", String.format("Couldn't find theme resource %1$s for the current theme", reference), (Object)new ResourceValue(ResourceType.ATTR, reference, resource.framework));
                }
                return item;
            }
            return this.findResValue(resource.type, resource.name, forceFrameworkOnly || resource.framework);
        }
        return null;
    }

    public ResourceValue resolveValue(ResourceType type, String name, String value, boolean isFrameworkValue) {
        if (value == null) {
            return null;
        }
        ResourceValue resValue = this.findResValue(value, isFrameworkValue);
        if (resValue == null) {
            return new ResourceValue(type, name, value, isFrameworkValue);
        }
        return this.resolveResValue(resValue);
    }

    public ResourceValue resolveResValue(ResourceValue resValue) {
        return this.resolveResValue(resValue, 0);
    }

    private ResourceValue resolveResValue(ResourceValue resValue, int depth) {
        if (resValue == null) {
            return null;
        }
        String value = resValue.getValue();
        if (value == null) {
            return resValue;
        }
        ResourceValue resolvedResValue = this.findResValue(value, resValue.isFramework());
        if (resolvedResValue == null) {
            return resValue;
        }
        if (resValue == resolvedResValue || depth >= 50) {
            if (this.mLogger != null) {
                this.mLogger.error("broken", String.format("Potential stack overflow trying to resolve '%s': cyclic resource definitions? Render may not be accurate.", value), null);
            }
            return resValue;
        }
        return this.resolveResValue(resolvedResValue, depth + 1);
    }

    private ResourceValue findResValue(ResourceType resType, String resName, boolean frameworkOnly) {
        Map<String, ResourceValue> typeMap;
        ResourceValue item;
        if (!frameworkOnly && (item = (typeMap = this.mProjectResources.get(resType)).get(resName)) != null) {
            return item;
        }
        typeMap = this.mFrameworkResources.get(resType);
        item = typeMap.get(resName);
        if (item != null) {
            return item;
        }
        if (this.mFrameworkProvider != null && resType == ResourceType.ID && this.mFrameworkProvider.getId(resType, resName) != null) {
            return new ResourceValue(resType, resName, true);
        }
        if (this.mLogger != null) {
            this.mLogger.warning("resources.resolve", "Couldn't resolve resource @" + (frameworkOnly ? "android:" : "") + resType + "/" + resName, (Object)new ResourceValue(resType, resName, frameworkOnly));
        }
        return null;
    }

    private ResourceValue getResource(ResourceType resourceType, String resourceName, Map<ResourceType, Map<String, ResourceValue>> resourceRepository) {
        ResourceValue item;
        Map<String, ResourceValue> typeMap = resourceRepository.get(resourceType);
        if (typeMap != null && (item = typeMap.get(resourceName)) != null) {
            item = this.resolveResValue(item);
            return item;
        }
        return null;
    }

    private void computeStyleMaps() {
        Map<String, ResourceValue> projectStyleMap = this.mProjectResources.get(ResourceType.STYLE);
        Map<String, ResourceValue> frameworkStyleMap = this.mFrameworkResources.get(ResourceType.STYLE);
        ResourceValue theme = null;
        if (this.mIsProjectTheme) {
            if (projectStyleMap != null) {
                theme = projectStyleMap.get(this.mThemeName);
            }
        } else if (frameworkStyleMap != null) {
            theme = frameworkStyleMap.get(this.mThemeName);
        }
        if (theme instanceof StyleResourceValue) {
            this.computeStyleInheritance(projectStyleMap.values(), projectStyleMap, frameworkStyleMap);
            if (frameworkStyleMap != null) {
                this.computeStyleInheritance(frameworkStyleMap.values(), null, frameworkStyleMap);
            }
            this.mDefaultTheme = (StyleResourceValue)theme;
            this.mThemes.clear();
            this.mThemes.add(this.mDefaultTheme);
        }
    }

    private void computeStyleInheritance(Collection<ResourceValue> styles, Map<String, ResourceValue> inProjectStyleMap, Map<String, ResourceValue> inFrameworkStyleMap) {
        for (ResourceValue value : styles) {
            StyleResourceValue parentStyle;
            if (!(value instanceof StyleResourceValue)) continue;
            StyleResourceValue style = (StyleResourceValue)value;
            String parentName = style.getParentStyle();
            if (parentName == null) {
                parentName = ResourceResolver.getParentName(value.getName());
            }
            if (parentName == null || (parentStyle = this.getStyle(parentName, inProjectStyleMap, inFrameworkStyleMap)) == null) continue;
            this.mStyleInheritanceMap.put(style, parentStyle);
        }
    }

    private static String getParentName(String styleName) {
        int index = styleName.lastIndexOf(46);
        if (index != -1) {
            return styleName.substring(0, index);
        }
        return null;
    }

    private StyleResourceValue getStyle(String parentName, Map<String, ResourceValue> inProjectStyleMap, Map<String, ResourceValue> inFrameworkStyleMap) {
        boolean frameworkOnly = false;
        String name = parentName;
        if (name.startsWith("@")) {
            name = name.substring("@".length());
        }
        if (name.startsWith("android:")) {
            frameworkOnly = true;
            name = name.substring("android:".length());
        }
        if (name.startsWith("style/")) {
            name = name.substring("style/".length());
        } else if (name.indexOf(47) != -1) {
            return null;
        }
        ResourceValue parent = null;
        if (!frameworkOnly && inProjectStyleMap != null) {
            parent = inProjectStyleMap.get(name);
        }
        if (parent == null) {
            if (inFrameworkStyleMap == null) {
                return null;
            }
            parent = inFrameworkStyleMap.get(name);
        }
        if (parent instanceof StyleResourceValue) {
            return (StyleResourceValue)parent;
        }
        if (this.mLogger != null) {
            this.mLogger.error("resources.resolve", String.format("Unable to resolve parent style name: %s", parentName), null);
        }
        return null;
    }

    public boolean isTheme(@NonNull ResourceValue value, @Nullable Map<ResourceValue, Boolean> cache) {
        Boolean known;
        if (cache != null && (known = cache.get(value)) != null) {
            return known;
        }
        if (value instanceof StyleResourceValue) {
            StyleResourceValue srv = (StyleResourceValue)value;
            String name = srv.getName();
            if (name.startsWith(THEME_NAME_DOT) || name.equals(THEME_NAME)) {
                if (cache != null) {
                    cache.put(value, true);
                }
                return true;
            }
            StyleResourceValue parentStyle = this.mStyleInheritanceMap.get(srv);
            if (parentStyle != null) {
                boolean result = this.isTheme((ResourceValue)parentStyle, cache);
                if (cache != null) {
                    cache.put(value, result);
                }
                return result;
            }
        }
        return false;
    }

    public boolean themeExtends(@NonNull String parentStyle, @NonNull String themeStyle) {
        ResourceValue parentValue = this.findResValue(parentStyle, parentStyle.startsWith("@android:style/"));
        if (parentValue instanceof StyleResourceValue) {
            ResourceValue themeValue = this.findResValue(themeStyle, themeStyle.startsWith("@android:style/"));
            if (themeValue == parentValue) {
                return true;
            }
            if (themeValue instanceof StyleResourceValue) {
                return this.themeIsParentOf((StyleResourceValue)parentValue, (StyleResourceValue)themeValue);
            }
        }
        return false;
    }

    public ResourceResolver createRecorder(List<ResourceValue> lookupChain) {
        RecordingResourceResolver resolver = new RecordingResourceResolver(lookupChain, this.mProjectResources, this.mFrameworkResources, this.mThemeName, this.mIsProjectTheme);
        resolver.mFrameworkProvider = this.mFrameworkProvider;
        resolver.mLogger = this.mLogger;
        resolver.mDefaultTheme = this.mDefaultTheme;
        resolver.mStyleInheritanceMap.putAll(this.mStyleInheritanceMap);
        resolver.mThemes.addAll(this.mThemes);
        return resolver;
    }

    private static class RecordingResourceResolver
    extends ResourceResolver {
        @NonNull
        private List<ResourceValue> mLookupChain;

        private RecordingResourceResolver(@NonNull List<ResourceValue> lookupChain, @NonNull Map<ResourceType, Map<String, ResourceValue>> projectResources, @NonNull Map<ResourceType, Map<String, ResourceValue>> frameworkResources, @NonNull String themeName, boolean isProjectTheme) {
            super(projectResources, frameworkResources, themeName, isProjectTheme);
            this.mLookupChain = lookupChain;
        }

        @Override
        public ResourceValue resolveResValue(ResourceValue resValue) {
            this.mLookupChain.add(resValue);
            return super.resolveResValue(resValue);
        }

        @Override
        public ResourceValue findResValue(String reference, boolean forceFrameworkOnly) {
            ResourceValue resValue;
            ResourceValue prev;
            if (!this.mLookupChain.isEmpty() && reference.startsWith("@") && !reference.equals((prev = this.mLookupChain.get(this.mLookupChain.size() - 1)).getValue())) {
                ResourceValue next = new ResourceValue(prev.getResourceType(), prev.getName(), prev.isFramework());
                next.setValue(reference);
                this.mLookupChain.add(next);
            }
            if ((resValue = super.findResValue(reference, forceFrameworkOnly)) != null) {
                this.mLookupChain.add(resValue);
            }
            return resValue;
        }

        @Override
        public ResourceValue findItemInStyle(StyleResourceValue style, String itemName, boolean isFrameworkAttr) {
            ResourceValue value = super.findItemInStyle(style, itemName, isFrameworkAttr);
            if (value != null) {
                this.mLookupChain.add(value);
            }
            return value;
        }

        public ResourceValue findItemInTheme(String attrName, boolean isFrameworkAttr) {
            ResourceValue value = super.findItemInTheme(attrName, isFrameworkAttr);
            if (value != null) {
                this.mLookupChain.add(value);
            }
            return value;
        }

        @Override
        public ResourceValue resolveValue(ResourceType type, String name, String value, boolean isFrameworkValue) {
            ResourceValue resourceValue = super.resolveValue(type, name, value, isFrameworkValue);
            if (resourceValue != null) {
                this.mLookupChain.add(resourceValue);
            }
            return resourceValue;
        }
    }
}

