/*
 * Decompiled with CFR 0.152.
 */
package com.android.ide.common.build;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.build.FilterData;
import com.android.build.OutputFile;
import com.android.build.VariantOutput;
import com.android.builder.testing.api.DeviceConfigProvider;
import com.android.ide.common.build.SplitSelectTool;
import com.android.ide.common.process.ProcessException;
import com.android.ide.common.process.ProcessExecutor;
import com.android.resources.Density;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;

public class SplitOutputMatcher {
    @NonNull
    public static List<File> computeBestOutput(@NonNull ProcessExecutor processExecutor, @Nullable File splitSelectExe, @NonNull DeviceConfigProvider deviceConfigProvider, @NonNull List<? extends VariantOutput> outputs, @Nullable Collection<String> variantAbiFilters) throws ProcessException {
        ArrayList<String> splitApksPath = new ArrayList<String>();
        OutputFile mainApk = null;
        for (VariantOutput variantOutput : outputs) {
            for (OutputFile outputFile : variantOutput.getOutputs()) {
                if (outputFile.getOutputFile().getAbsolutePath().equals(variantOutput.getMainOutputFile().getOutputFile().getAbsolutePath())) continue;
                splitApksPath.add(outputFile.getOutputFile().getAbsolutePath());
            }
            mainApk = variantOutput.getMainOutputFile();
        }
        if (mainApk == null) {
            throw new RuntimeException("Cannot retrieve the main APK from variant outputs");
        }
        if (splitApksPath.isEmpty()) {
            ArrayList<File> apkFiles = new ArrayList<File>();
            List<OutputFile> list = SplitOutputMatcher.computeBestOutput(outputs, variantAbiFilters, deviceConfigProvider.getDensity(), deviceConfigProvider.getAbis());
            for (OutputFile outputFile : list) {
                apkFiles.add(outputFile.getOutputFile());
            }
            return apkFiles;
        }
        if (splitSelectExe == null) {
            throw new RuntimeException("Pure splits installation requires build tools 22 or above");
        }
        return SplitOutputMatcher.computeBestOutput(processExecutor, splitSelectExe, deviceConfigProvider, mainApk.getOutputFile(), splitApksPath);
    }

    @NonNull
    public static List<File> computeBestOutput(@NonNull ProcessExecutor processExecutor, @NonNull File splitSelectExe, @NonNull DeviceConfigProvider deviceConfigProvider, @NonNull File mainApk, @NonNull Collection<String> splitApksPath) throws ProcessException {
        if (splitApksPath.isEmpty()) {
            return ImmutableList.of((Object)mainApk);
        }
        ArrayList<File> apkFiles = new ArrayList<File>();
        HashSet<String> resultApksPath = new HashSet<String>();
        for (String abi : deviceConfigProvider.getAbis()) {
            resultApksPath.addAll(SplitSelectTool.splitSelect(processExecutor, splitSelectExe, deviceConfigProvider.getConfigFor(abi), mainApk.getAbsolutePath(), splitApksPath));
        }
        for (String resultApkPath : resultApksPath) {
            apkFiles.add(new File(resultApkPath));
        }
        apkFiles.add(mainApk);
        return apkFiles;
    }

    @NonNull
    public static List<OutputFile> computeBestOutput(@NonNull List<? extends VariantOutput> outputs, @Nullable Collection<String> variantAbiFilters, int deviceDensity, @NonNull Collection<String> deviceAbis) {
        Density densityEnum = Density.getEnum((int)deviceDensity);
        String densityValue = densityEnum == null ? null : densityEnum.getResourceValue();
        HashSet<VariantOutput> matches = new HashSet<VariantOutput>();
        for (VariantOutput variantOutput : outputs) {
            for (OutputFile output : variantOutput.getOutputs()) {
                String densityFilter = SplitOutputMatcher.getFilter(output, OutputFile.DENSITY);
                String abiFilter = SplitOutputMatcher.getFilter(output, OutputFile.ABI);
                if (densityFilter != null && !densityFilter.equals(densityValue) || abiFilter != null && !deviceAbis.contains(abiFilter)) continue;
                matches.add(variantOutput);
            }
        }
        if (matches.isEmpty()) {
            return ImmutableList.of();
        }
        VariantOutput match = Collections.max(matches, new Comparator<VariantOutput>(){

            @Override
            public int compare(VariantOutput splitOutput, VariantOutput splitOutput2) {
                return splitOutput.getVersionCode() - splitOutput2.getVersionCode();
            }
        });
        OutputFile outputFile = match.getMainOutputFile();
        return SplitOutputMatcher.isMainApkCompatibleWithDevice(outputFile, variantAbiFilters, deviceAbis) ? ImmutableList.of((Object)outputFile) : ImmutableList.of();
    }

    private static boolean isMainApkCompatibleWithDevice(OutputFile mainOutputFile, Collection<String> variantAbiFilters, Collection<String> deviceAbis) {
        if (SplitOutputMatcher.getFilter(mainOutputFile, OutputFile.ABI) == null && variantAbiFilters != null && !variantAbiFilters.isEmpty()) {
            for (String abi : deviceAbis) {
                if (!variantAbiFilters.contains(abi)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Nullable
    private static String getFilter(@NonNull OutputFile outputFile, @NonNull String filterType) {
        for (FilterData filterData : outputFile.getFilters()) {
            if (!filterData.getFilterType().equals(filterType)) continue;
            return filterData.getIdentifier();
        }
        return null;
    }
}

