/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.closures.mutable;

import com.aol.cyclops.closures.Convertable;
import com.aol.cyclops.closures.mutable.Mutable;
import java.beans.ConstructorProperties;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class MutableChar
implements Supplier<Character>,
Consumer<Character>,
Convertable<Character> {
    private char var;

    public static <T> MutableChar of(char var) {
        return new MutableChar(var);
    }

    public static MutableChar fromExternal(final Supplier<Character> s, final Consumer<Character> c) {
        return new MutableChar(){

            @Override
            public char getAsChar() {
                return ((Character)s.get()).charValue();
            }

            @Override
            public Character get() {
                return Character.valueOf(this.getAsChar());
            }

            @Override
            public MutableChar set(char value) {
                c.accept(Character.valueOf(value));
                return this;
            }
        };
    }

    public <R> Mutable<R> mapOutputToObj(final Function<Character, R> fn) {
        final MutableChar host = this;
        return new Mutable<R>(){

            @Override
            public R get() {
                return fn.apply(host.get());
            }
        };
    }

    public <T1> Mutable<T1> mapInputToObj(final Function<T1, Character> fn) {
        final MutableChar host = this;
        return new Mutable<T1>(){

            @Override
            public Mutable<T1> set(T1 value) {
                host.set(((Character)fn.apply(value)).charValue());
                return this;
            }
        };
    }

    public char getAsChar() {
        return this.var;
    }

    public MutableChar set(char var) {
        this.var = var;
        return this;
    }

    public MutableChar mutate(CharFunction varFn) {
        return this.set(varFn.apply(this.get().charValue()));
    }

    @Override
    public void accept(Character t) {
        this.set(t.charValue());
    }

    @Override
    public Character get() {
        return Character.valueOf(this.getAsChar());
    }

    @ConstructorProperties(value={"var"})
    public MutableChar(char var) {
        this.var = var;
    }

    public MutableChar() {
    }

    public String toString() {
        return "MutableChar(var=" + this.var + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableChar)) {
            return false;
        }
        MutableChar other = (MutableChar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.var == other.var;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MutableChar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.var;
        return result;
    }

    public static interface CharFunction {
        public char apply(char var1);
    }
}

