/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.closures.mutable;

import com.aol.cyclops.closures.Convertable;
import com.aol.cyclops.closures.mutable.Mutable;
import java.beans.ConstructorProperties;
import java.util.OptionalDouble;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.stream.DoubleStream;

public class MutableDouble
implements DoubleSupplier,
DoubleConsumer,
Convertable<Double> {
    private double var;

    public static <T> MutableDouble of(double var) {
        return new MutableDouble(var);
    }

    public static MutableDouble fromExternal(final DoubleSupplier s, final DoubleConsumer c) {
        return new MutableDouble(){

            @Override
            public double getAsDouble() {
                return s.getAsDouble();
            }

            @Override
            public Double get() {
                return this.getAsDouble();
            }

            @Override
            public MutableDouble set(double value) {
                c.accept(value);
                return this;
            }
        };
    }

    public <R> Mutable<R> mapOutputToObj(final Function<Double, R> fn) {
        final MutableDouble host = this;
        return new Mutable<R>(){

            @Override
            public R get() {
                return fn.apply(host.get());
            }
        };
    }

    public <T1> Mutable<T1> mapInputToObj(final Function<T1, Double> fn) {
        final MutableDouble host = this;
        return new Mutable<T1>(){

            @Override
            public Mutable<T1> set(T1 value) {
                host.set((Double)fn.apply(value));
                return this;
            }
        };
    }

    public MutableDouble mapOutput(final DoubleUnaryOperator fn) {
        final MutableDouble host = this;
        return new MutableDouble(){

            @Override
            public double getAsDouble() {
                return fn.applyAsDouble(host.getAsDouble());
            }
        };
    }

    public MutableDouble mapInput(final DoubleUnaryOperator fn) {
        final MutableDouble host = this;
        return new MutableDouble(){

            @Override
            public MutableDouble set(double value) {
                host.set(fn.applyAsDouble(value));
                return this;
            }
        };
    }

    @Override
    public double getAsDouble() {
        return this.var;
    }

    public MutableDouble set(double var) {
        this.var = var;
        return this;
    }

    public MutableDouble mutate(DoubleFunction<Double> varFn) {
        return this.set(varFn.apply(this.get()));
    }

    public OptionalDouble toOptionalDouble() {
        return OptionalDouble.of(this.var);
    }

    public DoubleStream toDoubleStream() {
        return DoubleStream.of(this.var);
    }

    @Override
    public Double get() {
        return this.getAsDouble();
    }

    @Override
    public void accept(double value) {
        this.set(value);
    }

    @ConstructorProperties(value={"var"})
    public MutableDouble(double var) {
        this.var = var;
    }

    public MutableDouble() {
    }

    public String toString() {
        return "MutableDouble(var=" + this.var + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableDouble)) {
            return false;
        }
        MutableDouble other = (MutableDouble)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return Double.compare(this.var, other.var) == 0;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MutableDouble;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $var = Double.doubleToLongBits(this.var);
        result = result * 59 + (int)($var >>> 32 ^ $var);
        return result;
    }
}

