/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.closures.mutable;

import com.aol.cyclops.closures.Convertable;
import com.aol.cyclops.closures.mutable.Mutable;
import java.beans.ConstructorProperties;
import java.util.OptionalInt;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;

public class MutableInt
implements IntSupplier,
IntConsumer,
Convertable<Integer> {
    private int var;

    public static MutableInt of(int var) {
        return new MutableInt(var);
    }

    public static MutableInt fromExternal(final IntSupplier s, final IntConsumer c) {
        return new MutableInt(){

            @Override
            public int getAsInt() {
                return s.getAsInt();
            }

            @Override
            public Integer get() {
                return this.getAsInt();
            }

            @Override
            public MutableInt set(int value) {
                c.accept(value);
                return this;
            }
        };
    }

    public <R> Mutable<R> mapOutputToObj(final Function<Integer, R> fn) {
        final MutableInt host = this;
        return new Mutable<R>(){

            @Override
            public R get() {
                return fn.apply(host.get());
            }
        };
    }

    public <T1> Mutable<T1> mapInputToObj(final Function<T1, Integer> fn) {
        final MutableInt host = this;
        return new Mutable<T1>(){

            @Override
            public Mutable<T1> set(T1 value) {
                host.set((Integer)fn.apply(value));
                return this;
            }
        };
    }

    public MutableInt mapOutput(final IntUnaryOperator fn) {
        final MutableInt host = this;
        return new MutableInt(){

            @Override
            public int getAsInt() {
                return fn.applyAsInt(host.getAsInt());
            }
        };
    }

    public MutableInt mapInput(final IntUnaryOperator fn) {
        final MutableInt host = this;
        return new MutableInt(){

            @Override
            public MutableInt set(int value) {
                host.set(fn.applyAsInt(value));
                return this;
            }
        };
    }

    @Override
    public int getAsInt() {
        return this.var;
    }

    public MutableInt set(int var) {
        this.var = var;
        return this;
    }

    public MutableInt mutate(IntFunction<Integer> varFn) {
        this.var = varFn.apply(this.var);
        return this;
    }

    public OptionalInt toOptionalInt() {
        return OptionalInt.of(this.var);
    }

    public IntStream toIntStream() {
        return IntStream.of(this.var);
    }

    @Override
    public Integer get() {
        return this.getAsInt();
    }

    @Override
    public void accept(int value) {
        this.set(value);
    }

    @ConstructorProperties(value={"var"})
    public MutableInt(int var) {
        this.var = var;
    }

    public MutableInt() {
    }

    public String toString() {
        return "MutableInt(var=" + this.var + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MutableInt)) {
            return false;
        }
        MutableInt other = (MutableInt)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.var == other.var;
    }

    protected boolean canEqual(Object other) {
        return other instanceof MutableInt;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.var;
        return result;
    }
}

