/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.functions.caching;

import com.aol.cyclops.functions.QuadFunction;
import com.aol.cyclops.functions.TriFunction;
import com.aol.cyclops.functions.caching.Cacheable;
import java.beans.ConstructorProperties;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public class Memoize {
    public static <T> Supplier<T> memoizeSupplier(Supplier<T> s) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return () -> lazy.computeIfAbsent("k", arg_0 -> Memoize.lambda$null$63((Supplier)s, arg_0));
    }

    public static <T> Supplier<T> memoizeSupplier(Supplier<T> s, Cacheable<T> cache) {
        return () -> cache.computeIfAbsent("k", arg_0 -> Memoize.lambda$null$65((Supplier)s, arg_0));
    }

    public static <T> Callable<T> memoizeCallable(Callable<T> s, Cacheable<T> cache) {
        return () -> cache.computeIfAbsent("k", a -> {
            try {
                return s.call();
            }
            catch (Exception e) {
                Memoize.throwSoftenedException(e);
                return null;
            }
        });
    }

    public static <T> Callable<T> memoizeCallable(Callable<T> s) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return () -> lazy.computeIfAbsent("k", a -> {
            try {
                return s.call();
            }
            catch (Exception e) {
                Memoize.throwSoftenedException(e);
                return null;
            }
        });
    }

    public static <T, R> Function<T, R> memoizeFunction(Function<T, R> fn) {
        ConcurrentHashMap lazy = new ConcurrentHashMap();
        return t -> lazy.computeIfAbsent(t, fn);
    }

    public static <T, R> Function<T, R> memoizeFunction(Function<T, R> fn, Cacheable<R> cache) {
        return t -> cache.computeIfAbsent(t, fn);
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> memoizeBiFunction(BiFunction<T1, T2, R> fn) {
        Function<Pair, Object> memoise2 = Memoize.memoizeFunction(pair -> fn.apply(((Pair)pair)._1, ((Pair)pair)._2));
        return (t1, t2) -> memoise2.apply(new Pair<Object, Object>(t1, t2));
    }

    public static <T1, T2, R> BiFunction<T1, T2, R> memoizeBiFunction(BiFunction<T1, T2, R> fn, Cacheable<R> cache) {
        Function<Pair, Object> memoise2 = Memoize.memoizeFunction(pair -> fn.apply(((Pair)pair)._1, ((Pair)pair)._2), cache);
        return (t1, t2) -> memoise2.apply(new Pair<Object, Object>(t1, t2));
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> memoizeTriFunction(TriFunction<T1, T2, T3, R> fn) {
        Function<Triple, Object> memoise2 = Memoize.memoizeFunction(triple -> fn.apply(((Triple)triple)._1, ((Triple)triple)._2, ((Triple)triple)._3));
        return (t1, t2, t3) -> memoise2.apply(new Triple<Object, Object, Object>(t1, t2, t3));
    }

    public static <T1, T2, T3, R> TriFunction<T1, T2, T3, R> memoizeTriFunction(TriFunction<T1, T2, T3, R> fn, Cacheable<R> cache) {
        Function<Triple, Object> memoise2 = Memoize.memoizeFunction(triple -> fn.apply(((Triple)triple)._1, ((Triple)triple)._2, ((Triple)triple)._3), cache);
        return (t1, t2, t3) -> memoise2.apply(new Triple<Object, Object, Object>(t1, t2, t3));
    }

    public static <T1, T2, T3, T4, R> QuadFunction<T1, T2, T3, T4, R> memoizeQuadFunction(QuadFunction<T1, T2, T3, T4, R> fn) {
        Function<Quad, Object> memoise2 = Memoize.memoizeFunction(quad -> fn.apply(((Quad)quad)._1, ((Quad)quad)._2, ((Quad)quad)._3, ((Quad)quad)._4));
        return (t1, t2, t3, t4) -> memoise2.apply(new Quad<Object, Object, Object, Object>(t1, t2, t3, t4));
    }

    public static <T1, T2, T3, T4, R> QuadFunction<T1, T2, T3, T4, R> memoizeQuadFunction(QuadFunction<T1, T2, T3, T4, R> fn, Cacheable<R> cache) {
        Function<Quad, Object> memoise2 = Memoize.memoizeFunction(quad -> fn.apply(((Quad)quad)._1, ((Quad)quad)._2, ((Quad)quad)._3, ((Quad)quad)._4), cache);
        return (t1, t2, t3, t4) -> memoise2.apply(new Quad<Object, Object, Object, Object>(t1, t2, t3, t4));
    }

    public static <T> Predicate<T> memoizePredicate(Predicate<T> p) {
        Function<Object, Boolean> memoised = Memoize.memoizeFunction(t -> p.test(t));
        return t -> (Boolean)memoised.apply(t);
    }

    public static <T> Predicate<T> memoizePredicate(Predicate<T> p, Cacheable<Boolean> cache) {
        Function<Object, Boolean> memoised = Memoize.memoizeFunction(t -> p.test(t), cache);
        return t -> (Boolean)memoised.apply(t);
    }

    private static void throwSoftenedException(Throwable e) {
        new Thrower().uncheck(e);
    }

    private static /* synthetic */ Object lambda$null$65(Supplier supplier, Object a) {
        return supplier.get();
    }

    private static /* synthetic */ Object lambda$null$63(Supplier supplier, Object a) {
        return supplier.get();
    }

    static class Thrower<T extends Throwable> {
        Thrower() {
        }

        private void uncheck(Throwable throwable) throws T {
            throw throwable;
        }
    }

    static final class Quad<T1, T2, T3, T4> {
        private final T1 _1;
        private final T2 _2;
        private final T3 _3;
        private final T4 _4;

        @ConstructorProperties(value={"_1", "_2", "_3", "_4"})
        public Quad(T1 _1, T2 _2, T3 _3, T4 _4) {
            this._1 = _1;
            this._2 = _2;
            this._3 = _3;
            this._4 = _4;
        }

        public T1 get_1() {
            return this._1;
        }

        public T2 get_2() {
            return this._2;
        }

        public T3 get_3() {
            return this._3;
        }

        public T4 get_4() {
            return this._4;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Quad)) {
                return false;
            }
            Quad other = (Quad)o;
            T1 this$_1 = this.get_1();
            T1 other$_1 = other.get_1();
            if (this$_1 == null ? other$_1 != null : !this$_1.equals(other$_1)) {
                return false;
            }
            T2 this$_2 = this.get_2();
            T2 other$_2 = other.get_2();
            if (this$_2 == null ? other$_2 != null : !this$_2.equals(other$_2)) {
                return false;
            }
            T3 this$_3 = this.get_3();
            T3 other$_3 = other.get_3();
            if (this$_3 == null ? other$_3 != null : !this$_3.equals(other$_3)) {
                return false;
            }
            T4 this$_4 = this.get_4();
            T4 other$_4 = other.get_4();
            return !(this$_4 == null ? other$_4 != null : !this$_4.equals(other$_4));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T1 $_1 = this.get_1();
            result = result * 59 + ($_1 == null ? 0 : $_1.hashCode());
            T2 $_2 = this.get_2();
            result = result * 59 + ($_2 == null ? 0 : $_2.hashCode());
            T3 $_3 = this.get_3();
            result = result * 59 + ($_3 == null ? 0 : $_3.hashCode());
            T4 $_4 = this.get_4();
            result = result * 59 + ($_4 == null ? 0 : $_4.hashCode());
            return result;
        }

        public String toString() {
            return "Memoize.Quad(_1=" + this.get_1() + ", _2=" + this.get_2() + ", _3=" + this.get_3() + ", _4=" + this.get_4() + ")";
        }
    }

    static final class Triple<T1, T2, T3> {
        private final T1 _1;
        private final T2 _2;
        private final T3 _3;

        @ConstructorProperties(value={"_1", "_2", "_3"})
        public Triple(T1 _1, T2 _2, T3 _3) {
            this._1 = _1;
            this._2 = _2;
            this._3 = _3;
        }

        public T1 get_1() {
            return this._1;
        }

        public T2 get_2() {
            return this._2;
        }

        public T3 get_3() {
            return this._3;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Triple)) {
                return false;
            }
            Triple other = (Triple)o;
            T1 this$_1 = this.get_1();
            T1 other$_1 = other.get_1();
            if (this$_1 == null ? other$_1 != null : !this$_1.equals(other$_1)) {
                return false;
            }
            T2 this$_2 = this.get_2();
            T2 other$_2 = other.get_2();
            if (this$_2 == null ? other$_2 != null : !this$_2.equals(other$_2)) {
                return false;
            }
            T3 this$_3 = this.get_3();
            T3 other$_3 = other.get_3();
            return !(this$_3 == null ? other$_3 != null : !this$_3.equals(other$_3));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T1 $_1 = this.get_1();
            result = result * 59 + ($_1 == null ? 0 : $_1.hashCode());
            T2 $_2 = this.get_2();
            result = result * 59 + ($_2 == null ? 0 : $_2.hashCode());
            T3 $_3 = this.get_3();
            result = result * 59 + ($_3 == null ? 0 : $_3.hashCode());
            return result;
        }

        public String toString() {
            return "Memoize.Triple(_1=" + this.get_1() + ", _2=" + this.get_2() + ", _3=" + this.get_3() + ")";
        }
    }

    static final class Pair<T1, T2> {
        private final T1 _1;
        private final T2 _2;

        @ConstructorProperties(value={"_1", "_2"})
        public Pair(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }

        public T1 get_1() {
            return this._1;
        }

        public T2 get_2() {
            return this._2;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            T1 this$_1 = this.get_1();
            T1 other$_1 = other.get_1();
            if (this$_1 == null ? other$_1 != null : !this$_1.equals(other$_1)) {
                return false;
            }
            T2 this$_2 = this.get_2();
            T2 other$_2 = other.get_2();
            return !(this$_2 == null ? other$_2 != null : !this$_2.equals(other$_2));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            T1 $_1 = this.get_1();
            result = result * 59 + ($_1 == null ? 0 : $_1.hashCode());
            T2 $_2 = this.get_2();
            result = result * 59 + ($_2 == null ? 0 : $_2.hashCode());
            return result;
        }

        public String toString() {
            return "Memoize.Pair(_1=" + this.get_1() + ", _2=" + this.get_2() + ")";
        }
    }
}

