/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.comprehensions.converters;

import com.aol.cyclops.lambda.api.MonadicConverter;
import com.aol.cyclops.objects.AsDecomposable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class ObjectToStreamConverter
implements MonadicConverter<Stream> {
    private static final Map<Class, Boolean> shouldConvertCache = new ConcurrentHashMap<Class, Boolean>();
    public static int priority = 500;

    @Override
    public int priority() {
        return priority;
    }

    @Override
    public boolean accept(Object o) {
        return shouldConvertCache.computeIfAbsent(o.getClass(), c -> this.shouldConvert((Class)c));
    }

    @Override
    public Stream convertToMonadicForm(Object f) {
        return StreamSupport.stream(AsDecomposable.asDecomposable((Object)f).unapply().spliterator(), false);
    }

    private Boolean shouldConvert(Class c) {
        return !Stream.of(c.getMethods()).filter(method -> "map".equals(method.getName())).filter(method -> method.getParameterCount() == 1).findFirst().isPresent();
    }
}

