/*
 * Decompiled with CFR 0.152.
 */
package com.aol.cyclops.streams.future;

import com.aol.cyclops.sequence.future.DoubleOperators;
import com.aol.cyclops.streams.HasExec;
import com.aol.cyclops.streams.HasStream;
import java.util.DoubleSummaryStatistics;
import java.util.OptionalDouble;
import java.util.concurrent.CompletableFuture;
import java.util.function.ToDoubleFunction;
import java.util.stream.DoubleStream;

public interface DoubleOperatorsMixin<T>
extends DoubleOperators<T>,
HasStream<T>,
HasExec {
    default public CompletableFuture<Double> sumDouble(ToDoubleFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).sum(), this.getExec());
    }

    default public CompletableFuture<OptionalDouble> maxDouble(ToDoubleFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).max(), this.getExec());
    }

    default public CompletableFuture<OptionalDouble> minDouble(ToDoubleFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).min(), this.getExec());
    }

    default public CompletableFuture<OptionalDouble> averageDouble(ToDoubleFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).average(), this.getExec());
    }

    default public CompletableFuture<DoubleSummaryStatistics> summaryStatisticsDouble(ToDoubleFunction<T> fn) {
        return CompletableFuture.supplyAsync(() -> this.getStream().flatMapToDouble(t -> DoubleStream.of(fn.applyAsDouble(t))).summaryStatistics(), this.getExec());
    }
}

