/*
 * Decompiled with CFR 0.152.
 */
package com.apicatalog.jsonld.processor;

import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.JsonLdErrorCode;
import com.apicatalog.jsonld.JsonLdOptions;
import com.apicatalog.jsonld.JsonLdVersion;
import com.apicatalog.jsonld.compaction.Compaction;
import com.apicatalog.jsonld.context.ActiveContext;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.flattening.NodeMap;
import com.apicatalog.jsonld.flattening.NodeMapBuilder;
import com.apicatalog.jsonld.framing.Frame;
import com.apicatalog.jsonld.framing.Framing;
import com.apicatalog.jsonld.framing.FramingState;
import com.apicatalog.jsonld.json.JsonMapBuilder;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.lang.BlankNode;
import com.apicatalog.jsonld.loader.DocumentLoaderOptions;
import com.apicatalog.jsonld.processor.ExpansionProcessor;
import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonString;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class FramingProcessor {
    private FramingProcessor() {
    }

    public static final JsonObject frame(Document input, Document frame, JsonLdOptions options) throws JsonLdError {
        if (frame == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Frame or Frame.Document is null.");
        }
        JsonStructure frameStructure = frame.getJsonContent().orElseThrow(() -> new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Frame is not JSON object but null."));
        if (JsonUtils.isNotObject((JsonValue)frameStructure)) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Frame is not JSON object but [" + frameStructure + "].");
        }
        JsonObject frameObject = frameStructure.asJsonObject();
        JsonLdOptions expansionOptions = new JsonLdOptions(options);
        expansionOptions.setOrdered(false);
        JsonArray expandedInput = ExpansionProcessor.expand(input, expansionOptions, false);
        JsonArray expandedFrame = ExpansionProcessor.expand(frame, expansionOptions, true);
        JsonObject context = JsonValue.EMPTY_JSON_OBJECT;
        if (frameObject.containsKey((Object)"@context")) {
            context = (JsonValue)frameObject.get((Object)"@context");
        }
        URI contextBase = frame.getContextUrl() != null ? frame.getDocumentUrl() : options.getBase();
        ActiveContext activeContext = new ActiveContext(input.getDocumentUrl(), input.getDocumentUrl(), options).newContext().create((JsonValue)context, contextBase);
        ArrayList<String> frameKeysExpanded = new ArrayList<String>();
        for (String key : frameObject.keySet()) {
            frameKeysExpanded.add(activeContext.uriExpansion().vocab(true).expand(key));
        }
        boolean frameDefault = frameKeysExpanded.contains("@graph");
        FramingState state = new FramingState();
        state.setEmbed(options.getEmbed());
        state.setEmbedded(false);
        state.setExplicitInclusion(options.isExplicit());
        state.setRequireAll(options.isRequiredAll());
        state.setOmitDefault(options.isOmitDefault());
        state.setGraphMap(NodeMapBuilder.with((JsonStructure)expandedInput, new NodeMap()).build());
        if (frameDefault) {
            state.setGraphName("@default");
        } else {
            state.setGraphName("@merged");
            state.getGraphMap().merge();
        }
        JsonMapBuilder resultMap = JsonMapBuilder.create();
        Framing.with(state, new ArrayList<String>(state.getGraphMap().subjects(state.getGraphName())), Frame.of((JsonStructure)expandedFrame), resultMap, null).ordered(options.isOrdered()).frame();
        Object result = resultMap.valuesToArray();
        if (!activeContext.inMode(JsonLdVersion.V1_0)) {
            result = FramingProcessor.removeBlankId((Collection<JsonValue>)result);
        }
        JsonArrayBuilder filtered = Json.createArrayBuilder();
        result.stream().map(FramingProcessor::removePreserve).forEach(arg_0 -> ((JsonArrayBuilder)filtered).add(arg_0));
        JsonValue compactedResults = Compaction.with(activeContext).compactArrays(options.isCompactArrays()).ordered(options.isOrdered()).compact((JsonValue)filtered.build());
        if (JsonUtils.isEmptyArray(compactedResults)) {
            compactedResults = JsonValue.EMPTY_JSON_OBJECT;
        } else if (JsonUtils.isArray(compactedResults)) {
            String key = activeContext.uriCompaction().vocab(true).compact("@graph");
            compactedResults = Json.createObjectBuilder().add(key, compactedResults).build();
        }
        compactedResults = FramingProcessor.replaceNull(compactedResults);
        boolean omitGraph = options.isOmitGraph() == null ? activeContext.inMode(JsonLdVersion.V1_1) : options.isOmitGraph().booleanValue();
        if (!omitGraph && !compactedResults.asJsonObject().containsKey((Object)"@graph")) {
            compactedResults = compactedResults.asJsonObject().isEmpty() ? Json.createObjectBuilder().add("@graph", (JsonValue)JsonValue.EMPTY_JSON_ARRAY).build() : Json.createObjectBuilder().add("@graph", Json.createArrayBuilder().add(compactedResults)).build();
        }
        if (JsonUtils.isNotEmptyArray((JsonValue)context) && JsonUtils.isNotEmptyObject((JsonValue)context)) {
            compactedResults = Json.createObjectBuilder((JsonObject)compactedResults.asJsonObject()).add("@context", (JsonValue)context).build();
        }
        return compactedResults.asJsonObject();
    }

    public static final JsonObject frame(URI input, URI frame, JsonLdOptions options) throws JsonLdError {
        return FramingProcessor.frame(FramingProcessor.getDocument(input, options), FramingProcessor.getDocument(frame, options), options);
    }

    private static Document getDocument(URI document, JsonLdOptions options) throws JsonLdError {
        if (options.getDocumentLoader() == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Document loader is null. Cannot fetch [" + document + "].");
        }
        DocumentLoaderOptions loaderOptions = new DocumentLoaderOptions();
        loaderOptions.setExtractAllScripts(options.isExtractAllScripts());
        Document remoteDocument = options.getDocumentLoader().loadDocument(document, loaderOptions);
        if (remoteDocument == null) {
            throw new JsonLdError(JsonLdErrorCode.LOADING_DOCUMENT_FAILED, "Cannot load document [" + document + "].");
        }
        return remoteDocument;
    }

    private static final JsonValue removePreserve(JsonValue value) {
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            for (JsonValue item : value.asJsonArray()) {
                array.add(FramingProcessor.removePreserve(item));
            }
            return array.build();
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            if ("@preserve".equals(entry.getKey())) {
                return (JsonValue)((JsonValue)entry.getValue()).asJsonArray().get(0);
            }
            object.add((String)entry.getKey(), FramingProcessor.removePreserve((JsonValue)entry.getValue()));
        }
        return object.build();
    }

    private static final JsonValue replaceNull(JsonValue value) {
        if (JsonUtils.isString(value) && "@null".equals(((JsonString)value).getString())) {
            return JsonValue.NULL;
        }
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            value.asJsonArray().stream().map(FramingProcessor::replaceNull).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
            JsonArray result = array.build();
            return result.size() != 1 || JsonUtils.isNotNull((JsonValue)result.get(0)) ? result : JsonValue.EMPTY_JSON_ARRAY;
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            object.add((String)entry.getKey(), FramingProcessor.replaceNull((JsonValue)entry.getValue()));
        }
        return object.build();
    }

    private static final Collection<JsonValue> removeBlankId(Collection<JsonValue> array) {
        HashMap candidates = new HashMap();
        array.forEach(v -> FramingProcessor.findBlankNodes(v, candidates));
        List remove = candidates.entrySet().stream().filter(e -> (Integer)e.getValue() == 1).map(Map.Entry::getKey).collect(Collectors.toList());
        if (remove.isEmpty()) {
            return array;
        }
        return array.stream().map(v -> FramingProcessor.removeBlankIdKey(v, remove)).collect(Collectors.toList());
    }

    private static final JsonValue removeBlankIdKey(JsonValue value, List<String> blankNodes) {
        if (JsonUtils.isScalar(value)) {
            return value;
        }
        if (JsonUtils.isArray(value)) {
            JsonArrayBuilder array = Json.createArrayBuilder();
            value.asJsonArray().stream().map(item -> FramingProcessor.removeBlankIdKey(item, blankNodes)).forEach(arg_0 -> ((JsonArrayBuilder)array).add(arg_0));
            return array.build();
        }
        JsonObjectBuilder object = Json.createObjectBuilder();
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            if ("@id".equals(entry.getKey()) && JsonUtils.isString((JsonValue)entry.getValue()) && blankNodes.contains(((JsonString)entry.getValue()).getString())) continue;
            object.add((String)entry.getKey(), FramingProcessor.removeBlankIdKey((JsonValue)entry.getValue(), blankNodes));
        }
        return object.build();
    }

    private static final void findBlankNodes(JsonValue value, Map<String, Integer> blankNodes) {
        if (JsonUtils.isString(value)) {
            if (BlankNode.isWellFormed(((JsonString)value).getString())) {
                Integer count = blankNodes.computeIfAbsent(((JsonString)value).getString(), x -> 0);
                count = count + 1;
                blankNodes.put(((JsonString)value).getString(), count);
            }
            return;
        }
        if (JsonUtils.isScalar(value)) {
            return;
        }
        if (JsonUtils.isArray(value)) {
            for (JsonValue item : value.asJsonArray()) {
                FramingProcessor.findBlankNodes(item, blankNodes);
            }
            return;
        }
        for (Map.Entry entry : value.asJsonObject().entrySet()) {
            FramingProcessor.findBlankNodes((JsonValue)entry.getValue(), blankNodes);
        }
    }
}

