package org.approvaltests.internal.logs;

import com.spun.util.io.FileUtils;
import org.lambda.utils.Once;

import java.io.File;

public class ApprovedFileLog
{
  static
  {
    FileUtils.writeFile(get(), "");
    Once.run(() -> LoggingUtils.downloadScriptIfMissing("detect_and_remove_abandoned"));
  }
  public static File get()
  {
    File file = new File(LoggingUtils.APPROVAL_TEMP_DIRECTORY + "/.approved_files.log");
    FileUtils.createIfNeeded(file.getAbsolutePath());
    return file;
  }
  public static void log(File file)
  {
    File log = get();
    FileUtils.appendToFile(log, file.getAbsolutePath() + "\n");
  }
}
