/*
 * Decompiled with CFR 0.152.
 */
package com.apptasticsoftware.rssreader.module.itunes;

import com.apptasticsoftware.rssreader.Channel;
import com.apptasticsoftware.rssreader.DateTimeParser;
import com.apptasticsoftware.rssreader.module.itunes.ItunesOwner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class ItunesChannel
extends Channel {
    private String itunesImage;
    private final List<String> itunesCategories = new ArrayList<String>();
    private boolean itunesExplicit;
    private String itunesAuthor;
    private ItunesOwner itunesOwner;
    private String itunesTitle;
    private String itunesSubtitle;
    private String itunesSummary;
    private String itunesType;
    private String itunesNewFeedUrl;
    private boolean itunesBlock;
    private boolean itunesComplete;

    public ItunesChannel(DateTimeParser dateTimeParser) {
        super(dateTimeParser);
    }

    public String getItunesImage() {
        return this.itunesImage;
    }

    public void setItunesImage(String image) {
        this.itunesImage = image;
    }

    public List<String> getItunesCategories() {
        return Collections.unmodifiableList(this.itunesCategories);
    }

    public void addItunesCategory(String itunesCategory) {
        if (itunesCategory != null) {
            this.itunesCategories.add(itunesCategory);
        }
    }

    public Boolean getItunesExplicit() {
        return this.itunesExplicit;
    }

    public void setItunesExplicit(Boolean itunesExplicit) {
        this.itunesExplicit = itunesExplicit;
    }

    public Optional<String> getItunesAuthor() {
        return Optional.ofNullable(this.itunesAuthor);
    }

    public void setItunesAuthor(String itunesAuthor) {
        this.itunesAuthor = itunesAuthor;
    }

    public void setItunesOwner(ItunesOwner itunesOwner) {
        this.itunesOwner = itunesOwner;
    }

    public Optional<ItunesOwner> getItunesOwner() {
        return Optional.ofNullable(this.itunesOwner);
    }

    public Optional<String> getItunesTitle() {
        return Optional.ofNullable(this.itunesTitle);
    }

    public void setItunesTitle(String itunesTitle) {
        this.itunesTitle = itunesTitle;
    }

    public Optional<String> getItunesSubtitle() {
        return Optional.ofNullable(this.itunesSubtitle);
    }

    public void setItunesSubtitle(String itunesSubtitle) {
        this.itunesSubtitle = itunesSubtitle;
    }

    public String getItunesSummary() {
        return this.itunesSummary;
    }

    public void setItunesSummary(String itunesSummary) {
        this.itunesSummary = itunesSummary;
    }

    public Optional<String> getItunesType() {
        return Optional.ofNullable(this.itunesType);
    }

    public void setItunesType(String itunesType) {
        this.itunesType = itunesType;
    }

    public Optional<String> getItunesNewFeedUrl() {
        return Optional.ofNullable(this.itunesNewFeedUrl);
    }

    public void setItunesNewFeedUrl(String itunesNewFeedUrl) {
        this.itunesNewFeedUrl = itunesNewFeedUrl;
    }

    public boolean isItunesBlock() {
        return this.itunesBlock;
    }

    public void setItunesBlock(boolean itunesBlock) {
        this.itunesBlock = itunesBlock;
    }

    public boolean isItunesComplete() {
        return this.itunesComplete;
    }

    public void setItunesComplete(boolean itunesComplete) {
        this.itunesComplete = itunesComplete;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ItunesChannel that = (ItunesChannel)o;
        return this.getItunesExplicit() == that.getItunesExplicit() && this.isItunesBlock() == that.isItunesBlock() && this.isItunesComplete() == that.isItunesComplete() && Objects.equals(this.getItunesImage(), that.getItunesImage()) && this.getItunesCategories().equals(that.getItunesCategories()) && Objects.equals(this.getItunesAuthor(), that.getItunesAuthor()) && Objects.equals(this.getItunesOwner(), that.getItunesOwner()) && Objects.equals(this.getItunesTitle(), that.getItunesTitle()) && Objects.equals(this.getItunesSubtitle(), that.getItunesSubtitle()) && Objects.equals(this.getItunesSummary(), that.getItunesSummary()) && Objects.equals(this.getItunesType(), that.getItunesType()) && Objects.equals(this.getItunesNewFeedUrl(), that.getItunesNewFeedUrl());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.getItunesImage(), this.getItunesCategories(), this.getItunesExplicit(), this.getItunesAuthor(), this.getItunesOwner(), this.getItunesTitle(), this.getItunesSubtitle(), this.getItunesSummary(), this.getItunesType(), this.getItunesNewFeedUrl(), this.isItunesBlock(), this.isItunesComplete());
    }
}

