/*
 * Decompiled with CFR 0.152.
 */
package com.arpnetworking.commons.maven.javassist.plugin;

import com.arpnetworking.commons.maven.javassist.ClassProcessor;
import com.arpnetworking.commons.maven.javassist.plugin.ClassProcessorTask;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javax.annotation.Nullable;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.sonatype.plexus.build.incremental.BuildContext;

public abstract class AbstractProcessMojo
extends AbstractMojo {
    @Component
    private BuildContext buildContext;
    @Parameter(property="processor", required=true)
    private String processor;
    @Parameter(property="includes")
    private String[] includes;
    @Parameter(property="excludes")
    private String[] excludes;
    @Parameter(property="threads", defaultValue="1")
    private String threads;
    @Parameter(property="project", defaultValue="${project}", readonly=true)
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException, MojoFailureException {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Path outputDirectory = this.getOutputDirectory(this.project);
            List<String> classpathElementsToLoad = this.getClasspathElementsToLoad(this.project);
            ClassPool classPool = this.createClassPool(classpathElementsToLoad);
            URLClassLoader pluginClassLoader = this.createUrlClassLoader(classpathElementsToLoad, originalContextClassLoader);
            Thread.currentThread().setContextClassLoader(pluginClassLoader);
            ClassProcessor classProcessor = AbstractProcessMojo.createProcessor(pluginClassLoader, this.processor);
            Predicate<CtClass> includePredicate = AbstractProcessMojo.createIncludePredicate(this.includes);
            Predicate<CtClass> excludePredicate = AbstractProcessMojo.createExcludePredicate(this.excludes);
            ExecutorService executorService = AbstractProcessMojo.createExecutorService(this.threads);
            CompletableFuture[] completableFutures = (CompletableFuture[])this.getClasspathElementsToProcess(this.project).stream().flatMap(classpathElement -> this.findClasses(classPool, (String)classpathElement).stream()).map(ctClass -> CompletableFuture.runAsync(new ClassProcessorTask(this.buildContext, (CtClass)ctClass, classProcessor, includePredicate, excludePredicate, outputDirectory, this.getLog()), executorService)).toArray(CompletableFuture[]::new);
            try {
                CompletableFuture.allOf(completableFutures).get();
            }
            catch (InterruptedException e) {
                throw new MojoExecutionException("Class processing interrupted", (Exception)e);
            }
            catch (CompletionException | ExecutionException e) {
                throw AbstractProcessMojo.unwrapTaskException(e, e.getCause());
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    protected abstract Path getOutputDirectory(MavenProject var1);

    protected abstract List<String> getClasspathElementsToProcess(MavenProject var1) throws MojoExecutionException;

    protected abstract List<String> getClasspathElementsToLoad(MavenProject var1) throws MojoExecutionException;

    URLClassLoader createUrlClassLoader(List<String> classpathElements, ClassLoader contextClassLoader) throws MojoExecutionException {
        try {
            URL[] urls = new URL[classpathElements.size()];
            int i = 0;
            for (String classpathElement : classpathElements) {
                urls[i++] = new File(classpathElement).toURI().toURL();
            }
            return URLClassLoader.newInstance(urls, contextClassLoader);
        }
        catch (MalformedURLException e) {
            throw new MojoExecutionException("Unable to instantiate class loader", (Exception)e);
        }
    }

    ClassPool createClassPool(List<String> classpathElements) throws MojoExecutionException {
        ClassPool classPool = new ClassPool(ClassPool.getDefault());
        for (String classPathElement : classpathElements) {
            try {
                classPool.appendClassPath(classPathElement);
            }
            catch (NotFoundException e) {
                throw new MojoExecutionException("Unable to add class path to pool: " + classPathElement, (Exception)((Object)e));
            }
        }
        return classPool;
    }

    List<CtClass> findClasses(ClassPool classPool, String classPathElement) {
        this.getLog().debug((CharSequence)String.format("Searching classpath element: %s", classPathElement));
        PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:**.{class}");
        Path basePath = Paths.get(classPathElement, new String[0]);
        ArrayList<CtClass> ctClasses = new ArrayList<CtClass>();
        try {
            Files.walkFileTree(basePath, new ClasspathSimpleFileVisitor(matcher, ctClasses, classPool, basePath));
        }
        catch (IOException e) {
            throw new CompletionException("Unable to resolve compile classpath elements", e);
        }
        return ctClasses;
    }

    static ExecutorService createExecutorService(String threads) {
        int threadCount = threads.endsWith("C") ? Integer.parseInt(threads.substring(0, threads.length() - 1)) * Runtime.getRuntime().availableProcessors() : Integer.parseInt(threads);
        ClassLoader currentThreadContextClassloader = Thread.currentThread().getContextClassLoader();
        AtomicInteger threadIndex = new AtomicInteger(1);
        return Executors.newFixedThreadPool(threadCount, r -> {
            Thread thread = new Thread(r);
            thread.setName("javassist-processor-" + threadIndex.getAndIncrement());
            thread.setContextClassLoader(currentThreadContextClassloader);
            return thread;
        });
    }

    static ClassProcessor createProcessor(ClassLoader classLoader, String processorClassName) throws MojoExecutionException {
        try {
            Object classProcessor = classLoader.loadClass(processorClassName).newInstance();
            if (classProcessor instanceof ClassProcessor) {
                return (ClassProcessor)classProcessor;
            }
            throw new MojoExecutionException("Invalid class processor: " + processorClassName);
        }
        catch (ClassNotFoundException e) {
            throw new MojoExecutionException("Class processor not found: " + processorClassName, (Exception)e);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Unable to instantiate processor: " + processorClassName, e);
        }
    }

    static MojoExecutionException unwrapTaskException(Exception exception, @Nullable Throwable cause) {
        if (cause instanceof CompletionException || cause instanceof ExecutionException) {
            return AbstractProcessMojo.unwrapTaskException((Exception)cause, cause.getCause());
        }
        if (cause != null) {
            return new MojoExecutionException("Class processing failed", cause);
        }
        return new MojoExecutionException("Unknown class processing exception", exception);
    }

    static Predicate<CtClass> createIncludePredicate(@Nullable String[] classes) {
        if (classes == null || classes.length == 0) {
            return ctClass -> true;
        }
        Set<PathMatcher> includeSet = AbstractProcessMojo.createPathMatcherSet(classes);
        return AbstractProcessMojo.createMatchingPredicate(includeSet);
    }

    static Predicate<CtClass> createExcludePredicate(@Nullable String[] classes) {
        if (classes == null || classes.length == 0) {
            return ctClass -> false;
        }
        Set<PathMatcher> excludeSet = AbstractProcessMojo.createPathMatcherSet(classes);
        return AbstractProcessMojo.createMatchingPredicate(excludeSet);
    }

    static Predicate<CtClass> createMatchingPredicate(Set<PathMatcher> pathMatchers) {
        return ctClass -> {
            for (PathMatcher pathMatcher : pathMatchers) {
                if (!pathMatcher.matches(Paths.get(ctClass.getName(), new String[0]))) continue;
                return true;
            }
            return false;
        };
    }

    static Set<PathMatcher> createPathMatcherSet(String[] targets) {
        return Arrays.stream(targets).map(inclusion -> FileSystems.getDefault().getPathMatcher("glob:" + inclusion)).collect(Collectors.toSet());
    }

    private static class ClasspathSimpleFileVisitor
    extends SimpleFileVisitor<Path> {
        private final PathMatcher _matcher;
        private final List<CtClass> _ctClasses;
        private final ClassPool _classPool;
        private final Path _basePath;

        ClasspathSimpleFileVisitor(PathMatcher matcher, List<CtClass> ctClasses, ClassPool classPool, Path basePath) {
            this._matcher = matcher;
            this._ctClasses = ctClasses;
            this._classPool = classPool;
            this._basePath = basePath;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (this._matcher.matches(file)) {
                String relativeFileName = this._basePath.relativize(file).toString();
                String className = relativeFileName.substring(0, relativeFileName.lastIndexOf(".")).replace(File.separator, ".");
                try {
                    this._ctClasses.add(this._classPool.get(className));
                }
                catch (NotFoundException e) {
                    throw new IOException("Unable to load class: " + file + " (" + className + ")", e);
                }
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

