/*
 * Decompiled with CFR 0.152.
 */
package com.arpnetworking.commons.maven.javassist.plugin;

import com.arpnetworking.commons.maven.javassist.ClassProcessor;
import com.google.common.base.Throwables;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javassist.CannotCompileException;
import javassist.CtClass;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import org.apache.maven.plugin.logging.Log;
import org.sonatype.plexus.build.incremental.BuildContext;

final class ClassProcessorTask
implements Runnable,
CompletableFuture.AsynchronousCompletionTask {
    private final BuildContext _context;
    private final CtClass _ctClass;
    private final ClassProcessor _processor;
    private final Predicate<CtClass> _includePredicate;
    private final Predicate<CtClass> _excludePredicate;
    private final Path _outputDirectory;
    private final Log _log;
    private static final String PROCESSED_ANNOTATION_CLASS = "com.arpnetworking.commons.maven.javassist.Processed";

    ClassProcessorTask(BuildContext context, CtClass ctClass, ClassProcessor processor, Predicate<CtClass> includePredicate, Predicate<CtClass> excludePredicate, Path outputDirectory, Log log) {
        this._context = context;
        this._ctClass = ctClass;
        this._processor = processor;
        this._includePredicate = includePredicate;
        this._excludePredicate = excludePredicate;
        this._outputDirectory = outputDirectory;
        this._log = log;
    }

    @Override
    public void run() {
        if (!this.accept()) {
            return;
        }
        this._log.info((CharSequence)("Processing class: " + this._ctClass.getName()));
        this._processor.process(this._ctClass);
        this.markAsProcessed(this._ctClass, this._processor);
        this._ctClass.getClassFile().compact();
        this._ctClass.rebuildClassFile();
        this.writeClass(this._ctClass, this._outputDirectory, this._context);
    }

    boolean accept() {
        if (!this._includePredicate.test(this._ctClass)) {
            this._log.debug((CharSequence)("Class is not included: " + this._ctClass.getName()));
            return false;
        }
        if (this._excludePredicate.test(this._ctClass)) {
            this._log.debug((CharSequence)("Class is excluded: " + this._ctClass.getName()));
            return false;
        }
        if (this._ctClass.isFrozen()) {
            this._log.debug((CharSequence)("Class is frozen: " + this._ctClass.getName()));
            return false;
        }
        if (!this._processor.accept(this._ctClass)) {
            this._log.debug((CharSequence)("Class is not accepted: " + this._ctClass.getName()));
            return false;
        }
        if (this.isAlreadyProcessed(this._ctClass, this._processor)) {
            this._log.info((CharSequence)("Class already processed: " + this._ctClass.getName()));
            return false;
        }
        return true;
    }

    void markAsProcessed(CtClass ctClass, ClassProcessor processor) {
        ArrayMemberValue valueArray;
        MemberValue[] existingProcessorValues;
        MemberValue value;
        Annotation annotation;
        ClassFile classFile = ctClass.getClassFile();
        AnnotationsAttribute annotationAttribute = null;
        for (Object attributeObject : classFile.getAttributes()) {
            if (!(attributeObject instanceof AnnotationsAttribute)) continue;
            annotationAttribute = (AnnotationsAttribute)attributeObject;
            break;
        }
        if (annotationAttribute == null) {
            this._log.debug((CharSequence)("Creating annotation attribute on: " + ctClass.getName()));
            annotationAttribute = new AnnotationsAttribute(classFile.getConstPool(), "RuntimeVisibleAnnotations");
            classFile.addAttribute((AttributeInfo)annotationAttribute);
        }
        if ((annotation = annotationAttribute.getAnnotation(PROCESSED_ANNOTATION_CLASS)) == null) {
            this._log.debug((CharSequence)("Creating processed annotation on: " + ctClass.getName()));
            annotation = new Annotation(PROCESSED_ANNOTATION_CLASS, classFile.getConstPool());
        }
        if ((value = annotation.getMemberValue("value")) == null) {
            value = new ArrayMemberValue(classFile.getConstPool());
            annotation.addMemberValue("value", value);
        }
        MemberValue[] newProcessorValues = (existingProcessorValues = (valueArray = (ArrayMemberValue)value).getValue()) != null ? Arrays.copyOf(valueArray.getValue(), valueArray.getValue().length + 1) : new MemberValue[1];
        newProcessorValues[newProcessorValues.length - 1] = new StringMemberValue(processor.getClass().getName(), classFile.getConstPool());
        valueArray.setValue(newProcessorValues);
        this._log.debug((CharSequence)("New processed annotation value on: " + ctClass.getName() + " = " + valueArray));
        annotationAttribute.addAnnotation(annotation);
    }

    boolean isAlreadyProcessed(CtClass ctClass, ClassProcessor processor) {
        Annotation annotation;
        ClassFile classFile = ctClass.getClassFile();
        AnnotationsAttribute annotationAttribute = null;
        for (Object attributeObject : classFile.getAttributes()) {
            if (!(attributeObject instanceof AnnotationsAttribute)) continue;
            annotationAttribute = (AnnotationsAttribute)attributeObject;
            break;
        }
        if (annotationAttribute != null && (annotation = annotationAttribute.getAnnotation(PROCESSED_ANNOTATION_CLASS)) != null) {
            MemberValue value = annotation.getMemberValue("value");
            this._log.debug((CharSequence)("Existing processed annotation on: " + ctClass.getName() + " = " + value));
            ArrayMemberValue valueArray = (ArrayMemberValue)value;
            for (MemberValue processorValue : valueArray.getValue()) {
                StringMemberValue processorValueString = (StringMemberValue)processorValue;
                if (!processor.getClass().getName().equals(processorValueString.getValue())) continue;
                return true;
            }
        }
        this._log.debug((CharSequence)("No annotation attribute or processed annotation found on: " + ctClass.getName()));
        return false;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_BAD_PRACTICE"})
    void writeClass(CtClass ctClass, Path outputDirectory, BuildContext context) {
        File classFile = outputDirectory.resolve(Paths.get(ctClass.getName().replace('.', '/') + ".class", new String[0])).toFile();
        File classDirectory = classFile.getParentFile();
        classDirectory.mkdirs();
        try (DataOutputStream outputStream = new DataOutputStream(new BufferedOutputStream(context.newFileOutputStream(classFile)));){
            this._ctClass.toBytecode(outputStream);
        }
        catch (IOException | CannotCompileException e) {
            throw Throwables.propagate((Throwable)e);
        }
        context.refresh(classDirectory);
    }
}

