/*
 * Decompiled with CFR 0.152.
 */
package com.arpnetworking.commons.maven.javassist.plugin;

import com.arpnetworking.commons.maven.javassist.plugin.AbstractProcessMojo;
import com.google.common.collect.ImmutableList;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="test-process", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, requiresDependencyResolution=ResolutionScope.TEST)
public class ProcessTestMojo
extends AbstractProcessMojo {
    @Override
    protected Path getOutputDirectory(MavenProject project) {
        return Paths.get(project.getBuild().getTestOutputDirectory(), new String[0]);
    }

    @Override
    protected List<String> getClasspathElementsToProcess(MavenProject project) throws MojoExecutionException {
        return Collections.singletonList(project.getBuild().getTestOutputDirectory());
    }

    @Override
    protected List<String> getClasspathElementsToLoad(MavenProject project) throws MojoExecutionException {
        try {
            return ImmutableList.copyOf((Collection)project.getTestClasspathElements());
        }
        catch (DependencyResolutionRequiredException e) {
            throw new MojoExecutionException("Unable to load test class path elements", (Exception)((Object)e));
        }
    }
}

