/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.task;

import com.atlassian.bamboo.specs.api.builders.plan.artifact.Artifact;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.builders.task.BaseSshTask;
import com.atlassian.bamboo.specs.model.task.ScpTaskProperties;
import org.jetbrains.annotations.NotNull;

public class ScpTask
extends BaseSshTask<ScpTask, ScpTaskProperties> {
    private boolean localPathAntStyle = false;
    private String localPath;
    private String artifactName;
    private String remotePath;

    public ScpTask fromLocalPath(String localPath) {
        return this.fromLocalPath(localPath, false);
    }

    public ScpTask fromLocalPath(String localPath, boolean antStyle) {
        ImporterUtils.checkNotEmpty((String)"local path", (String)localPath);
        this.localPath = localPath;
        this.localPathAntStyle = antStyle;
        return this;
    }

    public ScpTask fromArtifact(String artifactName) {
        ImporterUtils.checkNotEmpty((String)"artifact name", (String)artifactName);
        this.artifactName = artifactName;
        return this;
    }

    public ScpTask fromArtifact(Artifact artifact) {
        ImporterUtils.checkNotNull((String)"artifact", (Object)artifact);
        return this.fromArtifact(artifact.getName());
    }

    public ScpTask toRemotePath(String remotePath) {
        ImporterUtils.checkNotEmpty((String)"remote path", (String)remotePath);
        this.remotePath = remotePath;
        return this;
    }

    @NotNull
    protected ScpTaskProperties build() {
        return new ScpTaskProperties(this.description, this.taskEnabled, this.host, this.username, this.authenticationType, this.password, this.key, this.passphrase, this.hostFingerprint, this.port, this.artifactName, this.localPath, this.localPathAntStyle, this.remotePath);
    }
}

