/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.builders.trigger;

import com.atlassian.bamboo.specs.api.builders.trigger.Trigger;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.util.CronExpressionCreationHelper;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.model.trigger.ScheduledTriggerProperties;
import java.time.DayOfWeek;
import java.time.LocalTime;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;

public class ScheduledTrigger
extends Trigger<ScheduledTrigger, ScheduledTriggerProperties> {
    private String cronExpression;

    public ScheduledTrigger() throws PropertiesValidationException {
        this.name("Scheduled");
    }

    public ScheduledTrigger scheduleEvery(int every, @NotNull TimeUnit at) {
        return this.cronExpression(CronExpressionCreationHelper.scheduleEvery((int)every, (TimeUnit)at));
    }

    public ScheduledTrigger scheduleOnceDaily(@NotNull LocalTime at) {
        return this.cronExpression(CronExpressionCreationHelper.scheduleOnceDaily((LocalTime)at));
    }

    public ScheduledTrigger scheduleWeekly(@NotNull LocalTime at, DayOfWeek ... onDays) {
        return this.cronExpression(CronExpressionCreationHelper.scheduleWeekly((LocalTime)at, (DayOfWeek[])onDays));
    }

    public ScheduledTrigger scheduleWeekly(@NotNull LocalTime at, @NotNull Collection<DayOfWeek> days) {
        return this.cronExpression(CronExpressionCreationHelper.scheduleWeekly((LocalTime)at, days));
    }

    public ScheduledTrigger scheduleMonthly(@NotNull LocalTime at, int dayOfMonth) {
        return this.cronExpression(CronExpressionCreationHelper.scheduleMonthly((LocalTime)at, (int)dayOfMonth));
    }

    public ScheduledTrigger cronExpression(@NotNull String cronExpression) {
        ImporterUtils.checkNotNull((String)"cronExpression", (Object)cronExpression);
        this.cronExpression = cronExpression;
        return this;
    }

    protected ScheduledTriggerProperties build() {
        return new ScheduledTriggerProperties(this.name, this.description, this.triggerEnabled, this.cronExpression);
    }
}

