/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationContext;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.codegen.emitters.ValueEmitterFactory;
import com.atlassian.bamboo.specs.util.MapBuilder;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class MapEmitter
implements CodeEmitter<Map> {
    @NotNull
    public String emitCode(@NotNull CodeGenerationContext context, @NotNull Map value) throws CodeGenerationException {
        StringBuilder builder = new StringBuilder();
        Map map = value;
        if (map.isEmpty()) {
            return context.importClassName(Collections.class) + ".emptyMap()";
        }
        builder.append("new ").append(context.importClassName(MapBuilder.class)).append("()");
        context.incIndentation();
        Set entrySet = map.entrySet();
        for (Map.Entry entry : entrySet) {
            builder.append(context.newLine());
            builder.append(".append(");
            CodeEmitter codeEmitter = ValueEmitterFactory.emitterFor(entry.getKey());
            builder.append(codeEmitter.emitCode(context, entry.getKey()));
            builder.append(", ");
            CodeEmitter codeEmitter2 = ValueEmitterFactory.emitterFor(entry.getValue());
            builder.append(codeEmitter2.emitCode(context, entry.getValue()));
            builder.append(")");
        }
        builder.append(context.newLine());
        builder.append(".build()");
        context.decIndentation();
        return builder.toString();
    }
}

