/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.codegen.emitters;

import com.atlassian.bamboo.specs.api.codegen.CodeEmitter;
import com.atlassian.bamboo.specs.api.codegen.CodeGenerationException;
import com.atlassian.bamboo.specs.api.model.EntityProperties;
import com.atlassian.bamboo.specs.codegen.emitters.CodeGenerationUtils;
import com.atlassian.bamboo.specs.codegen.emitters.DurationEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.EntityPropertiesEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.LiteralEmitter;
import com.atlassian.bamboo.specs.codegen.emitters.MapEmitter;
import java.time.Duration;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class ValueEmitterFactory {
    private ValueEmitterFactory() {
    }

    public static CodeEmitter emitterFor(@NotNull EntityProperties entity) throws CodeGenerationException {
        CodeEmitter codeEmitter = CodeGenerationUtils.findEmitterByAnnotation(entity.getClass());
        if (codeEmitter != null) {
            return codeEmitter;
        }
        return new EntityPropertiesEmitter();
    }

    public static CodeEmitter emitterFor(@NotNull Object object) throws CodeGenerationException {
        if (object instanceof EntityProperties) {
            return ValueEmitterFactory.emitterFor((EntityProperties)object);
        }
        if (object instanceof Duration) {
            return new DurationEmitter();
        }
        if (object instanceof Map) {
            return new MapEmitter();
        }
        return new LiteralEmitter();
    }
}

